/* Public domain. */

#include <drm/drm_gem.h>
#include <drm/drm_framebuffer.h>

void
drm_gem_fb_destroy(struct drm_framebuffer *fb)
{
	int i;

	for (i = 0; i < 4; i++)
		drm_gem_object_put_unlocked(fb->obj[i]);
	drm_framebuffer_cleanup(fb);
	free(fb, M_DRM, 0);
}

int
drm_gem_fb_create_handle(struct drm_framebuffer *fb, struct drm_file *file,
    unsigned int *handle)
{
	return drm_gem_handle_create(file, fb->obj[0], handle);
}
