/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.util.List;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.solr.common.SolrException;
import org.apache.solr.search.QParser;
import org.apache.solr.search.WrappedQuery;

public class QueryUtils {
    public static boolean isNegative(Query q) {
        if (!(q instanceof BooleanQuery)) {
            return false;
        }
        BooleanQuery bq = (BooleanQuery)q;
        List clauses = bq.clauses();
        if (clauses.size() == 0) {
            return false;
        }
        for (BooleanClause clause : clauses) {
            if (clause.isProhibited()) continue;
            return false;
        }
        return true;
    }

    public static Query getAbs(Query q) {
        if (q instanceof BoostQuery) {
            BoostQuery bq = (BoostQuery)q;
            Query subQ = bq.getQuery();
            Query absSubQ = QueryUtils.getAbs(subQ);
            if (absSubQ == subQ) {
                return q;
            }
            return new BoostQuery(absSubQ, bq.getBoost());
        }
        if (q instanceof WrappedQuery) {
            Query subQ = ((WrappedQuery)q).getWrappedQuery();
            Query absSubQ = QueryUtils.getAbs(subQ);
            if (absSubQ == subQ) {
                return q;
            }
            return new WrappedQuery(absSubQ);
        }
        if (!(q instanceof BooleanQuery)) {
            return q;
        }
        BooleanQuery bq = (BooleanQuery)q;
        List clauses = bq.clauses();
        if (clauses.size() == 0) {
            return q;
        }
        for (BooleanClause clause : clauses) {
            if (clause.isProhibited()) continue;
            return q;
        }
        if (clauses.size() == 1) {
            Query negClause = ((BooleanClause)clauses.iterator().next()).getQuery();
            return negClause;
        }
        BooleanQuery.Builder newBqB = new BooleanQuery.Builder();
        for (BooleanClause clause : clauses) {
            newBqB.add(clause.getQuery(), BooleanClause.Occur.SHOULD);
        }
        return newBqB.build();
    }

    public static Query makeQueryable(Query q) {
        if (q instanceof WrappedQuery) {
            return QueryUtils.makeQueryable(((WrappedQuery)q).getWrappedQuery());
        }
        return QueryUtils.isNegative(q) ? QueryUtils.fixNegativeQuery(q) : q;
    }

    public static Query fixNegativeQuery(Query q) {
        BoostQuery bq;
        float boost = 1.0f;
        if (q instanceof BoostQuery) {
            bq = (BoostQuery)q;
            boost = bq.getBoost();
            q = bq.getQuery();
        }
        bq = (BooleanQuery)q;
        BooleanQuery.Builder newBqB = new BooleanQuery.Builder();
        newBqB.setMinimumNumberShouldMatch(bq.getMinimumNumberShouldMatch());
        for (BooleanClause clause : bq) {
            newBqB.add(clause);
        }
        newBqB.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.MUST);
        BooleanQuery newBq = newBqB.build();
        return new BoostQuery((Query)newBq, boost);
    }

    public static BooleanQuery build(BooleanQuery.Builder builder, QParser parser) {
        int configuredMax = parser != null ? parser.getReq().getCore().getSolrConfig().booleanQueryMaxClauseCount : BooleanQuery.getMaxClauseCount();
        BooleanQuery bq = builder.build();
        if (bq.clauses().size() > configuredMax) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Too many clauses in boolean query: encountered=" + bq.clauses().size() + " configured in solrconfig.xml via maxBooleanClauses=" + configuredMax);
        }
        return bq;
    }

    public static Query combineQueryAndFilter(Query scoreQuery, Query filterQuery) {
        if (scoreQuery == null || scoreQuery instanceof MatchAllDocsQuery) {
            if (filterQuery == null) {
                return new MatchAllDocsQuery();
            }
            return new ConstantScoreQuery(filterQuery);
        }
        if (filterQuery == null || filterQuery instanceof MatchAllDocsQuery) {
            return scoreQuery;
        }
        return new BooleanQuery.Builder().add(scoreQuery, BooleanClause.Occur.MUST).add(filterQuery, BooleanClause.Occur.FILTER).build();
    }
}

