/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.equate;

import docking.widgets.table.AbstractSortedTableModel;
import ghidra.app.plugin.core.equate.EquateTablePlugin;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Equate;
import ghidra.program.model.symbol.EquateReference;
import ghidra.program.model.symbol.EquateTable;
import ghidra.program.util.OperandFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.table.ProgramTableModel;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

class EquateReferenceTableModel
extends AbstractSortedTableModel<EquateReference>
implements ProgramTableModel {
    private static final Comparator<EquateReference> ADDRESS_COMPARATOR = (er1, er2) -> {
        Address addr1 = er1.getAddress();
        Address addr2 = er2.getAddress();
        return addr1.compareTo((Object)addr2);
    };
    private static final Comparator<EquateReference> OPERAND_COMPARATOR = (er1, er2) -> {
        short opIndex2;
        short opIndex1 = er1.getOpIndex();
        if (opIndex1 < (opIndex2 = er2.getOpIndex())) {
            return -1;
        }
        if (opIndex1 > opIndex2) {
            return 1;
        }
        return 0;
    };
    static final String ADDR_COL_NAME = "Ref Addr";
    static final String OPINDEX_COL_NAME = "Op Index";
    static final int ADDR_COL = 0;
    static final int OPINDEX_COL = 1;
    private EquateTablePlugin plugin;
    private List<EquateReference> referenceList = new ArrayList<EquateReference>();
    private Equate equate;

    EquateReferenceTableModel(EquateTablePlugin plugin) {
        this.plugin = plugin;
    }

    Equate getEquate() {
        return this.equate;
    }

    void setEquate(Equate equate) {
        this.equate = equate;
        this.populateReferences();
        this.fireTableDataChanged();
    }

    public String getName() {
        return "Equate References";
    }

    public String getColumnName(int column) {
        String[] names = new String[]{ADDR_COL_NAME, OPINDEX_COL_NAME};
        if (column < 0 || column > 1) {
            return "UNKNOWN";
        }
        return names[column];
    }

    public int findColumn(String columnName) {
        if (columnName.equals(ADDR_COL_NAME)) {
            return 0;
        }
        if (columnName.equals(OPINDEX_COL_NAME)) {
            return 1;
        }
        return 0;
    }

    public Class<?> getColumnClass(int columnIndex) {
        return EquateReference.class;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        return this.referenceList.size();
    }

    protected Comparator<EquateReference> createSortComparator(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return ADDRESS_COMPARATOR;
            }
            case 1: {
                return OPERAND_COMPARATOR;
            }
        }
        return super.createSortComparator(columnIndex);
    }

    public Object getColumnValueForRow(EquateReference eqref, int columnIndex) {
        switch (columnIndex) {
            case 0: 
            case 1: {
                return eqref;
            }
        }
        return "UNKNOWN";
    }

    public List<EquateReference> getModelData() {
        return this.referenceList;
    }

    private void populateReferences() {
        EquateReference[] refs;
        this.referenceList.clear();
        Program program = this.getProgram();
        if (program == null) {
            return;
        }
        EquateTable equateTable = program.getEquateTable();
        if (equateTable == null || this.equate == null) {
            return;
        }
        for (EquateReference ref : refs = this.equate.getReferences()) {
            this.referenceList.add(ref);
        }
    }

    public boolean isSortable(int columnIndex) {
        return true;
    }

    @Override
    public ProgramLocation getProgramLocation(int row, int column) {
        EquateReference reference = (EquateReference)this.getRowObject(row);
        OperandFieldLocation loc = new OperandFieldLocation(this.getProgram(), reference.getAddress(), null, null, null, (int)reference.getOpIndex(), 0);
        return loc;
    }

    @Override
    public ProgramSelection getProgramSelection(int[] rows) {
        AddressSet addressSet = new AddressSet();
        for (int row : rows) {
            EquateReference reference = (EquateReference)this.getRowObject(row);
            Address addr = reference.getAddress();
            addressSet.addRange(addr, addr);
        }
        return new ProgramSelection((AddressSetView)addressSet);
    }

    @Override
    public Program getProgram() {
        return this.plugin.getProgram();
    }
}

