/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin;

import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.bin.MutableByteProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.mem.Memory;
import java.io.IOException;

public class MemoryMutableByteProvider
extends MemoryByteProvider
implements MutableByteProvider {
    public MemoryMutableByteProvider(Memory memory, AddressSpace space) {
        super(memory, space);
    }

    public MemoryMutableByteProvider(Memory memory, Address baseAddress) {
        super(memory, baseAddress);
    }

    @Override
    public void writeByte(long index, byte value) throws IOException {
        try {
            this.memory.setByte(this.baseAddress.add(index), value);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void writeBytes(long index, byte[] values) throws IOException {
        try {
            this.memory.setBytes(this.baseAddress.add(index), values);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }
}

