/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf;

import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.EnumDataType;
import ghidra.util.StringUtilities;
import ghidra.util.exception.DuplicateNameException;
import java.util.HashMap;
import java.util.Map;

public class ElfProgramHeaderType {
    private static Map<Integer, ElfProgramHeaderType> defaultElfProgramHeaderTypeMap = new HashMap<Integer, ElfProgramHeaderType>();
    public static ElfProgramHeaderType PT_NULL = ElfProgramHeaderType.addDefaultProgramHeaderType(0, "PT_NULL", "Unused/Undefined segment");
    public static ElfProgramHeaderType PT_LOAD = ElfProgramHeaderType.addDefaultProgramHeaderType(1, "PT_LOAD", "Loadable segment");
    public static ElfProgramHeaderType PT_DYNAMIC = ElfProgramHeaderType.addDefaultProgramHeaderType(2, "PT_DYNAMIC", "Dynamic linking information");
    public static ElfProgramHeaderType PT_INTERP = ElfProgramHeaderType.addDefaultProgramHeaderType(3, "PT_INTERP", "Interpreter path name");
    public static ElfProgramHeaderType PT_NOTE = ElfProgramHeaderType.addDefaultProgramHeaderType(4, "PT_NOTE", "Auxiliary information location");
    public static ElfProgramHeaderType PT_SHLIB = ElfProgramHeaderType.addDefaultProgramHeaderType(5, "PT_SHLIB", "");
    public static ElfProgramHeaderType PT_PHDR = ElfProgramHeaderType.addDefaultProgramHeaderType(6, "PT_PHDR", "Program header table");
    public static ElfProgramHeaderType PT_TLS = ElfProgramHeaderType.addDefaultProgramHeaderType(7, "PT_TLS", "Thread-Local Storage template");
    public static ElfProgramHeaderType PT_GNU_EH_FRAME = ElfProgramHeaderType.addDefaultProgramHeaderType(1685382480, "PT_GNU_EH_FRAME", "GCC .eh_frame_hdr segment");
    public static ElfProgramHeaderType PT_GNU_STACK = ElfProgramHeaderType.addDefaultProgramHeaderType(1685382481, "PT_GNU_STACK", "Indicates stack executability");
    public static ElfProgramHeaderType PT_GNU_RELRO = ElfProgramHeaderType.addDefaultProgramHeaderType(1685382482, "PT_GNU_RELRO", "Specifies segments which may be read-only post-relocation");
    public final int value;
    public final String name;
    public final String description;

    private static ElfProgramHeaderType addDefaultProgramHeaderType(int value, String name, String description) {
        try {
            ElfProgramHeaderType type = new ElfProgramHeaderType(value, name, description);
            ElfProgramHeaderType.addProgramHeaderType(type, defaultElfProgramHeaderTypeMap);
            return type;
        }
        catch (DuplicateNameException e) {
            throw new RuntimeException("ElfProgramHeaderType initialization error", e);
        }
    }

    public static void addProgramHeaderType(ElfProgramHeaderType type, Map<Integer, ElfProgramHeaderType> programHeaderTypeMap) throws DuplicateNameException {
        ElfProgramHeaderType conflictType = programHeaderTypeMap.get(type.value);
        if (conflictType != null) {
            throw new DuplicateNameException("ElfProgramHeaderType conflict during initialization (" + type.name + " / " + conflictType.name + "), value=0x" + Integer.toHexString(type.value));
        }
        for (ElfProgramHeaderType existingType : programHeaderTypeMap.values()) {
            if (!type.name.equalsIgnoreCase(existingType.name)) continue;
            throw new DuplicateNameException("ElfProgramHeaderType conflict during initialization, name=" + type.name);
        }
        programHeaderTypeMap.put(type.value, type);
    }

    public ElfProgramHeaderType(int value, String name, String description) {
        if (value < 0) {
            throw new IllegalArgumentException("ElfProgramHeaderType value out of range: 0x" + Long.toHexString(value));
        }
        this.value = value;
        this.name = name;
        this.description = description;
    }

    public static void addDefaultTypes(Map<Integer, ElfProgramHeaderType> programHeaderTypeMap) {
        programHeaderTypeMap.putAll(defaultElfProgramHeaderTypeMap);
    }

    public static EnumDataType getEnumDataType(boolean is32bit, String typeSuffix, Map<Integer, ElfProgramHeaderType> dynamicTypeMap) {
        Object name;
        int size = is32bit ? 4 : 8;
        Object object = name = is32bit ? "Elf32_PHType" : "Elf64_PHType";
        if (typeSuffix != null) {
            name = (String)name + typeSuffix;
        }
        EnumDataType phTypeEnum = new EnumDataType(new CategoryPath("/ELF"), (String)name, size);
        for (ElfProgramHeaderType type : dynamicTypeMap.values()) {
            phTypeEnum.add(type.name, (long)type.value);
        }
        return phTypeEnum;
    }

    public String toString() {
        return this.name + "(0x" + StringUtilities.pad((String)Integer.toHexString(this.value), (char)'0', (int)8) + ")";
    }
}

