/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.task;

import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.CancelledListener;
import ghidra.util.task.TaskMonitor;

class BasicTaskMonitor
implements TaskMonitor {
    private WeakSet<CancelledListener> listeners = WeakDataStructureFactory.createCopyOnReadWeakSet();
    private String message;
    private long progress;
    private long maxProgress;
    private boolean cancelEnabled = true;
    private boolean isCancelled;
    private boolean isIndeterminate;

    BasicTaskMonitor() {
    }

    public void addCancelledListener(CancelledListener l) {
        this.listeners.add((Object)l);
    }

    public void removeCancelledListener(CancelledListener l) {
        this.listeners.remove((Object)l);
    }

    public void incrementProgress(long incrementAmount) {
        this.setProgress(this.progress + incrementAmount);
    }

    public long getProgress() {
        return this.progress;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void checkCanceled() throws CancelledException {
        if (this.isCancelled) {
            throw new CancelledException();
        }
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public void setProgress(long value) {
        this.progress = value;
    }

    public void initialize(long maxValue) {
        this.setMaximum(maxValue);
        this.setProgress(0L);
    }

    public void setMaximum(long max) {
        this.maxProgress = max;
        if (this.progress > max) {
            this.progress = max;
        }
    }

    public void setIndeterminate(boolean indeterminate) {
        this.isIndeterminate = indeterminate;
    }

    public void setCancelEnabled(boolean enable) {
        this.cancelEnabled = enable;
    }

    public boolean isCancelEnabled() {
        return this.cancelEnabled;
    }

    public void cancel() {
        boolean wasCancelled = this.isCancelled;
        this.isCancelled = true;
        if (!wasCancelled) {
            this.notifyCancelledListeners();
        }
    }

    public void clearCanceled() {
        this.isCancelled = false;
    }

    public long getMaximum() {
        return this.maxProgress;
    }

    public boolean isIndeterminate() {
        return this.isIndeterminate;
    }

    public void setShowProgressValue(boolean showProgressValue) {
    }

    private void notifyCancelledListeners() {
        for (CancelledListener listener : this.listeners) {
            listener.cancelled();
        }
    }
}

