/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.decompiler.ClangFunction;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.component.DecompilerController;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighFunctionDBUtil;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.Msg;
import ghidra.util.UndefinedFunction;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;

public class CommitParamsAction
extends AbstractDecompilerAction {
    private final DecompilerController controller;

    public CommitParamsAction(PluginTool tool, DecompilerController controller) {
        super("Commit Params/Return");
        this.controller = controller;
        this.setPopupMenuData(new MenuData(new String[]{"Commit Params/Return"}, "Commit"));
        this.setKeyBindingData(new KeyBindingData(80, 0));
        this.setDescription("Save Parameters/Return definitions to Program, locking them into their current type definitions");
    }

    private HighFunction getHighFunction() {
        DecompilerPanel decompilerPanel = this.controller.getDecompilerPanel();
        ClangToken tokenAtCursor = decompilerPanel.getTokenAtCursor();
        if (tokenAtCursor == null) {
            return null;
        }
        ClangFunction clfunc = tokenAtCursor.getClangFunction();
        if (clfunc == null) {
            return null;
        }
        return clfunc.getHighFunction();
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        Function function = this.controller.getFunction();
        if (function == null || function instanceof UndefinedFunction) {
            return false;
        }
        return this.getHighFunction() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        Program program = this.controller.getProgram();
        int transaction = program.startTransaction("Commit Params/Return");
        try {
            HighFunction hfunc = this.getHighFunction();
            SourceType source = SourceType.ANALYSIS;
            if (hfunc.getFunction().getSignatureSource() == SourceType.USER_DEFINED) {
                source = SourceType.USER_DEFINED;
            }
            HighFunctionDBUtil.commitReturnToDatabase((HighFunction)hfunc, (SourceType)source);
            HighFunctionDBUtil.commitParamsToDatabase((HighFunction)hfunc, (boolean)true, (SourceType)source);
        }
        catch (DuplicateNameException e) {
            throw new AssertException("Unexpected exception", (Throwable)e);
        }
        catch (InvalidInputException e) {
            Msg.showError((Object)((Object)this), null, (String)"Parameter Commit Failed", (Object)e.getMessage());
        }
        finally {
            program.endTransaction(transaction, true);
        }
    }
}

