/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.jml;

import com.jeta.forms.store.JETAObjectOutput;
import com.jeta.forms.store.JETAPersistable;
import com.jeta.forms.store.jml.JMLException;
import com.jeta.forms.store.jml.JMLSerializer;
import com.jeta.forms.store.jml.JMLUtils;
import com.jeta.forms.store.jml.dom.JMLDocument;
import com.jeta.forms.store.jml.dom.JMLNode;
import com.jeta.forms.store.properties.JETAProperty;
import java.io.IOException;

public class JMLObjectOutput
implements JETAObjectOutput {
    private JMLDocument m_document;
    private JMLNode m_objnode;

    public JMLObjectOutput(JMLDocument jMLDocument, JMLNode jMLNode) {
        this.m_document = jMLDocument;
        this.m_objnode = jMLNode;
    }

    public void writeVersion(int n) throws IOException {
    }

    public void writeInt(String string, int n) throws IOException {
        try {
            this.m_objnode.appendChild(JMLUtils.createPropertyNode(this.m_document, string, String.valueOf(n)));
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    public void writeObject(String string, Object object) throws IOException {
        try {
            if (object != null) {
                this.m_objnode.appendChild(JMLUtils.createPropertyNode(this.m_document, string, object));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException(exception.getMessage());
        }
    }

    public void writeBoolean(String string, boolean bl) throws IOException {
        try {
            this.m_objnode.appendChild(JMLUtils.createPropertyNode(this.m_document, string, String.valueOf(bl)));
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    public void writeFloat(String string, float f) throws IOException {
        try {
            this.m_objnode.appendChild(JMLUtils.createPropertyNode(this.m_document, string, String.valueOf(f)));
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    public JETAObjectOutput getSuperClassOutput(Class clazz) {
        if (clazz == JETAProperty.class) {
            return this;
        }
        JMLNode jMLNode = JMLUtils.createSuperClassNode(this.m_document, clazz);
        this.m_objnode.appendChild(jMLNode);
        return new JMLObjectOutput(this.m_document, jMLNode);
    }

    public void writeBoolean(String string, boolean bl, boolean bl2) throws IOException {
        if (bl != bl2) {
            this.writeBoolean(string, bl);
        }
    }

    public void writeInt(String string, int n, int n2) throws IOException {
        if (n != n2) {
            this.writeInt(string, n);
        }
    }

    public void writeFloat(String string, float f, float f2) throws IOException {
        if (f != f2) {
            this.writeFloat(string, f);
        }
    }

    public static class XMLObjectOutputSerializer
    implements JMLSerializer {
        public JMLNode serialize(JMLDocument jMLDocument, Object object) throws JMLException {
            JETAPersistable jETAPersistable = (JETAPersistable)object;
            JMLNode jMLNode = JMLUtils.createObjectNode(jMLDocument, object);
            JMLObjectOutput jMLObjectOutput = new JMLObjectOutput(jMLDocument, jMLNode);
            try {
                jETAPersistable.write(jMLObjectOutput);
                return jMLNode;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new JMLException(iOException.getMessage());
            }
        }
    }
}

