/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.algo;

import ghidra.graph.GEdge;
import ghidra.graph.MutableGDirectedGraphWrapper;
import ghidra.graph.algo.GraphNavigator;
import java.util.Set;
import util.CollectionUtils;

abstract class AbstractDominanceAlgorithm<V, E extends GEdge<V>> {
    private static final String DUMMY_ROOT_NAME = "Dummy Root Vertex";
    private static final String DUMMY_SINK_NAME = "Dummy Sink Vertex";

    AbstractDominanceAlgorithm() {
    }

    protected static <V, E extends GEdge<V>> V unifySources(MutableGDirectedGraphWrapper<V, E> graph, GraphNavigator<V, E> graphNavigator) {
        Set<V> sources = graphNavigator.getSources(graph);
        if (sources.isEmpty()) {
            throw new IllegalArgumentException("The graph does not contain at least one source node");
        }
        if (sources.size() == 1) {
            return (V)CollectionUtils.any(sources);
        }
        Object dummy = graph.addDummyVertex(DUMMY_ROOT_NAME);
        sources.forEach(s -> {
            if (graphNavigator.isTopDown()) {
                graph.addDummyEdge(dummy, s);
            } else {
                graph.addDummyEdge(s, dummy);
            }
        });
        return dummy;
    }

    protected static <V, E extends GEdge<V>> V unifySinks(MutableGDirectedGraphWrapper<V, E> graph, GraphNavigator<V, E> graphNavigator) {
        Set<V> sinks = graphNavigator.getSinks(graph);
        if (sinks.isEmpty()) {
            throw new IllegalArgumentException("The graph does not contain at least one sink node");
        }
        if (sinks.size() == 1) {
            return sinks.iterator().next();
        }
        Object dummy = graph.addDummyVertex(DUMMY_SINK_NAME);
        sinks.forEach(s -> {
            if (graphNavigator.isTopDown()) {
                graph.addDummyEdge(s, dummy);
            } else {
                graph.addDummyEdge(dummy, s);
            }
        });
        return dummy;
    }
}

