/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.ByteField;
import db.DBHandle;
import db.Field;
import db.LongField;
import db.Record;
import db.RecordIterator;
import db.Schema;
import db.StringField;
import db.Table;
import ghidra.program.database.data.DataTypeManagerDB;
import ghidra.program.database.data.EnumDBAdapter;
import ghidra.util.UniversalID;
import ghidra.util.exception.VersionException;
import java.io.IOException;
import java.util.Date;

class EnumDBAdapterV1
extends EnumDBAdapter {
    static final int VERSION = 1;
    static final int V1_ENUM_NAME_COL = 0;
    static final int V1_ENUM_COMMENT_COL = 1;
    static final int V1_ENUM_CAT_COL = 2;
    static final int V1_ENUM_SIZE_COL = 3;
    static final int V1_ENUM_SOURCE_ARCHIVE_ID_COL = 4;
    static final int V1_ENUM_UNIVERSAL_DT_ID_COL = 5;
    static final int V1_ENUM_SOURCE_SYNC_TIME_COL = 6;
    static final int V1_ENUM_LAST_CHANGE_TIME_COL = 7;
    static final Schema V1_ENUM_SCHEMA = new Schema(1, "Enum ID", new Class[]{StringField.class, StringField.class, LongField.class, ByteField.class, LongField.class, LongField.class, LongField.class, LongField.class}, new String[]{"Name", "Comment", "Category ID", "Size", "Source Archive ID", "Source Data Type ID", "Source Sync Time", "Last Change Time"});
    private Table enumTable;

    public EnumDBAdapterV1(DBHandle handle, boolean create) throws VersionException, IOException {
        if (create) {
            this.enumTable = handle.createTable("Enumeration Data Types", V1_ENUM_SCHEMA, new int[]{2, 5});
        } else {
            this.enumTable = handle.getTable("Enumeration Data Types");
            if (this.enumTable == null) {
                throw new VersionException("Missing Table: Enumeration Data Types");
            }
            int version = this.enumTable.getSchema().getVersion();
            if (version != 1) {
                String msg = "Expected version 1 for table Enumeration Data Types but got " + this.enumTable.getSchema().getVersion();
                if (version < 1) {
                    throw new VersionException(msg, 1, true);
                }
                throw new VersionException(msg, 2, false);
            }
        }
    }

    @Override
    public Record createRecord(String name, String comments, long categoryID, byte size, long sourceArchiveID, long sourceDataTypeID, long lastChangeTime) throws IOException {
        long tableKey = this.enumTable.getKey();
        long key = DataTypeManagerDB.createKey(8, tableKey);
        Record record = V1_ENUM_SCHEMA.createRecord(key);
        record.setString(0, name);
        record.setString(1, comments);
        record.setLongValue(2, categoryID);
        record.setByteValue(3, size);
        record.setLongValue(4, sourceArchiveID);
        record.setLongValue(5, sourceDataTypeID);
        record.setLongValue(6, lastChangeTime);
        record.setLongValue(7, lastChangeTime);
        this.enumTable.putRecord(record);
        return record;
    }

    @Override
    public Record getRecord(long enumID) throws IOException {
        return this.enumTable.getRecord(enumID);
    }

    @Override
    public RecordIterator getRecords() throws IOException {
        return this.enumTable.iterator();
    }

    @Override
    public void updateRecord(Record record, boolean setLastChangeTime) throws IOException {
        if (setLastChangeTime) {
            record.setLongValue(7, new Date().getTime());
        }
        this.enumTable.putRecord(record);
    }

    @Override
    public boolean removeRecord(long enumID) throws IOException {
        return this.enumTable.deleteRecord(enumID);
    }

    @Override
    protected void deleteTable(DBHandle handle) throws IOException {
        handle.deleteTable("Enumeration Data Types");
    }

    @Override
    public long[] getRecordIdsInCategory(long categoryID) throws IOException {
        return this.enumTable.findRecords((Field)new LongField(categoryID), 2);
    }

    @Override
    long[] getRecordIdsForSourceArchive(long archiveID) throws IOException {
        return this.enumTable.findRecords((Field)new LongField(archiveID), 4);
    }

    @Override
    Record getRecordWithIDs(UniversalID sourceID, UniversalID datatypeID) throws IOException {
        long[] keys = this.enumTable.findRecords((Field)new LongField(datatypeID.getValue()), 5);
        for (int i = 0; i < keys.length; ++i) {
            Record record = this.enumTable.getRecord(keys[i]);
            if (record.getLongValue(4) != sourceID.getValue()) continue;
            return record;
        }
        return null;
    }
}

