/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.framework.options.SaveState;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.util.FunctionLocation;

public class FunctionSignatureFieldLocation
extends FunctionLocation {
    private String signature;
    private boolean isFieldBasedPoisitioning;

    public FunctionSignatureFieldLocation(Program program, Address locationAddr, Address functionAddr, int charOffset, String signature) {
        super(program, locationAddr, functionAddr, 0, 0, charOffset);
        this.signature = signature;
    }

    public FunctionSignatureFieldLocation(Program program, Address functionAddr, int col, String signature) {
        this(program, functionAddr, functionAddr, col, signature);
    }

    public FunctionSignatureFieldLocation(Program program, Address functionAddr) {
        this(program, functionAddr, functionAddr, 0, "");
        this.isFieldBasedPoisitioning = true;
    }

    public FunctionSignatureFieldLocation() {
    }

    public boolean isFieldBasedPositioning() {
        return this.isFieldBasedPoisitioning;
    }

    public String getSignature() {
        return this.signature;
    }

    @Override
    public String toString() {
        return super.toString() + ", Function signature = " + this.signature;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.isFieldBasedPoisitioning ? 1231 : 1237);
        result = 31 * result + (this.signature == null ? 0 : this.signature.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionSignatureFieldLocation other = (FunctionSignatureFieldLocation)obj;
        if (this.isFieldBasedPoisitioning != other.isFieldBasedPoisitioning) {
            return false;
        }
        return !(this.signature == null ? other.signature != null : !this.signature.equals(other.signature));
    }

    @Override
    public void saveState(SaveState obj) {
        super.saveState(obj);
        obj.putString("_SIGNATURE", this.signature);
    }

    @Override
    public void restoreState(Program p, SaveState obj) {
        super.restoreState(p, obj);
        this.signature = obj.getString("_SIGNATURE", null);
    }
}

