/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.nettyutils;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class WhitelistFilter
extends ChannelInboundHandlerAdapter {
    private final List<InetAddress> whitelist = new CopyOnWriteArrayList<InetAddress>();

    public void allowAll(InetAddress[] addresses) {
        if (addresses == null) {
            throw new NullPointerException("addresses");
        }
        for (int i = 0; i < addresses.length; ++i) {
            InetAddress addr = addresses[i];
            this.allow(addr);
        }
    }

    public void allowAll(Iterable<InetAddress> addresses) {
        if (addresses == null) {
            throw new NullPointerException("addresses");
        }
        for (InetAddress address : addresses) {
            this.allow(address);
        }
    }

    public void allow(InetAddress address) {
        this.whitelist.add(address);
    }

    public void remove(InetAddress address) {
        if (address == null) {
            throw new NullPointerException("address");
        }
        this.whitelist.remove(address);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        if (!this.isBlocked(ctx.channel())) {
            ctx.fireChannelActive();
        } else {
            System.out.println("connection refused : " + ctx.channel().remoteAddress());
            this.blockSession(ctx.channel());
        }
    }

    private void blockSession(Channel session) {
        SocketAddress remoteAddress = session.remoteAddress();
        session.close();
    }

    private boolean isBlocked(Channel session) {
        SocketAddress remoteAddress = session.remoteAddress();
        return !(remoteAddress instanceof InetSocketAddress) || !this.whitelist.contains(((InetSocketAddress)remoteAddress).getAddress());
    }
}

