/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core;

import com.dropbox.core.json.JsonArrayReader;
import com.dropbox.core.json.JsonReadException;
import com.dropbox.core.json.JsonReader;
import com.dropbox.core.util.Collector;
import com.dropbox.core.util.DumpWriter;
import com.dropbox.core.util.Dumpable;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;

public class DbxDeltaC<C>
extends Dumpable {
    public final boolean reset;
    public final C entries;
    public final String cursor;
    public final boolean hasMore;

    public DbxDeltaC(boolean reset, C entries, String cursor, boolean hasMore) {
        this.reset = reset;
        this.entries = entries;
        this.cursor = cursor;
        this.hasMore = hasMore;
    }

    @Override
    protected void dumpFields(DumpWriter out) {
        out.field("reset", this.reset);
        out.field("cursor", this.cursor);
        out.field("entries", this.hasMore);
    }

    public static final class Entry<MD extends Dumpable>
    extends Dumpable {
        public final String lcPath;
        public final MD metadata;

        public Entry(String lcPath, MD metadata) {
            this.lcPath = lcPath;
            this.metadata = metadata;
        }

        @Override
        protected void dumpFields(DumpWriter out) {
            out.field("lcPath", this.lcPath);
            out.field("metadata", (Dumpable)this.metadata);
        }

        public static final class Reader<MD extends Dumpable>
        extends JsonReader<Entry<MD>> {
            public final JsonReader<MD> metadataReader;

            public Reader(JsonReader<MD> metadataReader) {
                this.metadataReader = metadataReader;
            }

            @Override
            public Entry<MD> read(JsonParser parser) throws IOException, JsonReadException {
                return Reader.read(parser, this.metadataReader);
            }

            public static <MD extends Dumpable> Entry<MD> read(JsonParser parser, JsonReader<MD> metadataReader) throws IOException, JsonReadException {
                Dumpable metadata;
                String lcPath;
                JsonLocation arrayStart = JsonReader.expectArrayStart(parser);
                if (JsonReader.isArrayEnd(parser)) {
                    throw new JsonReadException("expecting a two-element array of [path, metadata], found a zero-element array", arrayStart);
                }
                try {
                    lcPath = JsonReader.StringReader.read(parser);
                }
                catch (JsonReadException ex) {
                    throw ex.addArrayContext(0);
                }
                if (JsonReader.isArrayEnd(parser)) {
                    throw new JsonReadException("expecting a two-element array of [path, metadata], found a one-element array", arrayStart);
                }
                try {
                    metadata = (Dumpable)metadataReader.readOptional(parser);
                }
                catch (JsonReadException ex) {
                    throw ex.addArrayContext(1);
                }
                if (!JsonReader.isArrayEnd(parser)) {
                    throw new JsonReadException("expecting a two-element array of [path, metadata], found more than two elements", arrayStart);
                }
                parser.nextToken();
                return new Entry<Dumpable>(lcPath, metadata);
            }
        }
    }

    public static final class Reader<C, MD extends Dumpable>
    extends JsonReader<DbxDeltaC<C>> {
        public final JsonReader<MD> metadataReader;
        public final Collector<Entry<MD>, C> entryCollector;
        private static final int FM_reset = 0;
        private static final int FM_entries = 1;
        private static final int FM_cursor = 2;
        private static final int FM_has_more = 3;
        private static final JsonReader.FieldMapping FM;

        public Reader(JsonReader<MD> metadataReader, Collector<Entry<MD>, C> entryCollector) {
            this.metadataReader = metadataReader;
            this.entryCollector = entryCollector;
        }

        @Override
        public DbxDeltaC<C> read(JsonParser parser) throws IOException, JsonReadException {
            return Reader.read(parser, this.metadataReader, this.entryCollector);
        }

        public static <C, MD extends Dumpable> DbxDeltaC<C> read(JsonParser parser, JsonReader<MD> metadataReader, Collector<Entry<MD>, C> entryCollector) throws IOException, JsonReadException {
            JsonLocation top = JsonReader.expectObjectStart(parser);
            Boolean reset = null;
            Object entries = null;
            String cursor = null;
            Boolean has_more = null;
            while (parser.getCurrentToken() == JsonToken.FIELD_NAME) {
                String fieldName = parser.getCurrentName();
                JsonReader.nextToken(parser);
                int fi = FM.get(fieldName);
                try {
                    if (fi == -1) {
                        JsonReader.skipValue(parser);
                        continue;
                    }
                    switch (fi) {
                        case 0: {
                            reset = JsonReader.BooleanReader.readField(parser, fieldName, reset);
                            break;
                        }
                        case 1: {
                            Entry.Reader<MD> entryReader = new Entry.Reader<MD>(metadataReader);
                            entries = JsonArrayReader.mk(entryReader, entryCollector).readField(parser, fieldName, entries);
                            break;
                        }
                        case 2: {
                            cursor = JsonReader.StringReader.readField(parser, fieldName, cursor);
                            break;
                        }
                        case 3: {
                            has_more = JsonReader.BooleanReader.readField(parser, fieldName, has_more);
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)("bad index: " + fi + ", field = \"" + fieldName + "\""));
                        }
                    }
                }
                catch (JsonReadException ex) {
                    throw ex.addFieldContext(fieldName);
                }
            }
            JsonReader.expectObjectEnd(parser);
            if (reset == null) {
                throw new JsonReadException("missing field \"path\"", top);
            }
            if (entries == null) {
                throw new JsonReadException("missing field \"entries\"", top);
            }
            if (cursor == null) {
                throw new JsonReadException("missing field \"cursor\"", top);
            }
            if (has_more == null) {
                throw new JsonReadException("missing field \"has_more\"", top);
            }
            return new DbxDeltaC<Object>(reset, entries, cursor, has_more);
        }

        static {
            JsonReader.FieldMapping.Builder b = new JsonReader.FieldMapping.Builder();
            b.add("reset", 0);
            b.add("entries", 1);
            b.add("cursor", 2);
            b.add("has_more", 3);
            FM = b.build();
        }
    }
}

