/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.program.model.data.ArrayStringable;
import ghidra.program.model.data.BuiltIn;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeDisplayOptions;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypeWithCharset;
import ghidra.program.model.data.EndianSettingsDefinition;
import ghidra.program.model.data.RenderUnicodeSettingsDefinition;
import ghidra.program.model.data.StringDataInstance;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.scalar.Scalar;
import ghidra.util.StringUtilities;

public class WideCharDataType
extends BuiltIn
implements ArrayStringable,
DataTypeWithCharset {
    static final SettingsDefinition[] DEFAULT_WIDE_CHAR_SETTINGS = new SettingsDefinition[]{EndianSettingsDefinition.DEF, RenderUnicodeSettingsDefinition.RENDER};
    private static final long serialVersionUID = 1L;
    public static final WideCharDataType dataType = new WideCharDataType();

    public WideCharDataType() {
        this(null);
    }

    public WideCharDataType(DataTypeManager dtm) {
        super(null, "wchar_t", dtm);
    }

    @Override
    public int getLength() {
        return this.getDataOrganization().getWideCharSize();
    }

    @Override
    public boolean isDynamicallySized() {
        return true;
    }

    @Override
    public String getDescription() {
        return "Wide-Character (compiler-specific size)";
    }

    @Override
    protected SettingsDefinition[] getBuiltInSettingsDefinitions() {
        return DEFAULT_WIDE_CHAR_SETTINGS;
    }

    @Override
    public DataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new WideCharDataType(dtm);
    }

    @Override
    public String getMnemonic(Settings settings) {
        return "wchar_t";
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        return new StringDataInstance(this, settings, buf, this.getLength()).getCharRepresentation();
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        length = this.getLength();
        try {
            switch (this.getLength()) {
                case 2: {
                    return new Character((char)buf.getShort(0));
                }
                case 4: {
                    return new Scalar(32, buf.getInt(0), true);
                }
            }
        }
        catch (MemoryAccessException memoryAccessException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Class<?> getValueClass(Settings settings) {
        switch (this.getLength()) {
            case 2: {
                return Character.class;
            }
            case 4: {
                return Scalar.class;
            }
        }
        return null;
    }

    @Override
    public String getDefaultLabelPrefix(MemBuffer buf, Settings settings, int length, DataTypeDisplayOptions options) {
        if (length != 2 && length != 4) {
            return "WCHAR_??";
        }
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("WCHAR_");
        try {
            int val = (int)buf.getVarLengthUnsignedInt(0, length);
            if (StringUtilities.isAsciiChar((int)val)) {
                strBuf.append((char)val);
            } else {
                strBuf.append(Integer.toHexString(val));
                strBuf.append('h');
            }
        }
        catch (MemoryAccessException e) {
            strBuf.append("??");
        }
        return strBuf.toString();
    }

    @Override
    public String getDefaultLabelPrefix() {
        return "WCHAR";
    }

    @Override
    public String getCTypeDeclaration(DataOrganization dataOrganization) {
        return this.getCTypeDeclaration(this.getName(), dataOrganization.getWideCharSize(), true, dataOrganization, false);
    }

    @Override
    public boolean hasStringValue(Settings settings) {
        return true;
    }

    @Override
    public String getArrayDefaultLabelPrefix(MemBuffer buf, Settings settings, int len, DataTypeDisplayOptions options) {
        return new StringDataInstance(this, settings, buf, len).getLabel("u_", "UNI", "UNICODE", options);
    }

    @Override
    public String getArrayDefaultOffcutLabelPrefix(MemBuffer buf, Settings settings, int len, DataTypeDisplayOptions options, int offcutOffset) {
        return new StringDataInstance(this, settings, buf, len).getOffcutLabelString("u_", "UNI", "UNICODE", options, offcutOffset);
    }

    @Override
    public String getCharsetName(Settings settings) {
        switch (this.getLength()) {
            case 2: {
                return "UTF-16";
            }
            case 4: {
                return "UTF-32";
            }
        }
        return "US-ASCII";
    }
}

