/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.util;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;

public class MemoryByteIterator {
    private static final int BUF_SIZE = 16384;
    private Memory mem;
    private AddressSet addrSet;
    byte[] buf;
    int count = 0;
    int pos;

    public MemoryByteIterator(Memory mem, AddressSetView set) {
        this.mem = mem;
        this.addrSet = set.intersect(mem);
        this.buf = new byte[16384];
    }

    public boolean hasNext() {
        return this.count != 0 || !this.addrSet.isEmpty();
    }

    public byte next() throws MemoryAccessException {
        if (this.count == 0) {
            AddressRange range = this.addrSet.iterator().next();
            Address start = range.getMinAddress();
            long size = range.getLength();
            if (size > 16384L) {
                range = new AddressRangeImpl(start, start.add(16383L));
                size = 16384L;
            }
            this.count = (int)size;
            this.pos = 0;
            this.addrSet.delete(range);
            this.mem.getBytes(start, this.buf, 0, this.count);
        }
        --this.count;
        return this.buf[this.pos++];
    }
}

