/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import docking.widgets.table.AbstractSortedTableModel;
import docking.widgets.table.ColumnAnnotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class DynamicTableModel<T>
extends AbstractSortedTableModel<T> {
    private List<T> data;
    private List<AnnotatedColumn> columns = new ArrayList<AnnotatedColumn>();

    public DynamicTableModel(List<T> data, Class<T> tClass) {
        Method[] methods;
        this.data = data;
        for (Method method : methods = tClass.getMethods()) {
            if (!method.isAnnotationPresent(ColumnAnnotation.class)) continue;
            this.columns.add(new AnnotatedColumn(method));
        }
    }

    @Override
    public String getName() {
        return "Dynamic Table Model";
    }

    @Override
    public boolean isSortable(int columnIndex) {
        return true;
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public List<T> getModelData() {
        return this.data;
    }

    @Override
    public String getColumnName(int column) {
        return this.columns.get(column).getName();
    }

    @Override
    public Object getColumnValueForRow(T rowObject, int columnIndex) {
        return this.columns.get(columnIndex).getValue(rowObject);
    }

    class AnnotatedColumn {
        private String name;
        private Method method;

        public AnnotatedColumn(Method method) {
            this.method = method;
            this.name = method.getName();
            if (this.name.startsWith("get")) {
                this.name = this.name.substring(3);
            }
        }

        public String getName() {
            return this.name;
        }

        public Object getValue(T t) {
            try {
                return this.method.invoke(t, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

