/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexPermuteInputsShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBeans;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.mapping.Mappings;

public class JoinPushThroughJoinRule
extends RelRule<Config>
implements TransformationRule {
    public static final JoinPushThroughJoinRule RIGHT = Config.RIGHT.toRule();
    public static final JoinPushThroughJoinRule LEFT = Config.LEFT.toRule();

    protected JoinPushThroughJoinRule(Config config) {
        super(config);
    }

    @Deprecated
    public JoinPushThroughJoinRule(String description, boolean right, Class<? extends Join> joinClass, RelBuilderFactory relBuilderFactory) {
        this(Config.LEFT.withDescription(description).withRelBuilderFactory(relBuilderFactory).as(Config.class).withOperandFor(joinClass).withRight(right));
    }

    @Deprecated
    public JoinPushThroughJoinRule(String description, boolean right, Class<? extends Join> joinClass, RelFactories.ProjectFactory projectFactory) {
        this(Config.LEFT.withDescription(description).withRelBuilderFactory(RelBuilder.proto(projectFactory)).as(Config.class).withOperandFor(joinClass).withRight(right));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        if (((Config)this.config).isRight()) {
            JoinPushThroughJoinRule.onMatchRight(call);
        } else {
            JoinPushThroughJoinRule.onMatchLeft(call);
        }
    }

    private static void onMatchRight(RelOptRuleCall call) {
        Join topJoin = (Join)call.rel(0);
        Join bottomJoin = (Join)call.rel(1);
        Object relC = call.rel(2);
        RelNode relA = bottomJoin.getLeft();
        RelNode relB = bottomJoin.getRight();
        RelOptCluster cluster = topJoin.getCluster();
        int aCount = relA.getRowType().getFieldCount();
        int bCount = relB.getRowType().getFieldCount();
        int cCount = relC.getRowType().getFieldCount();
        ImmutableBitSet bBitSet = ImmutableBitSet.range(aCount, aCount + bCount);
        if (topJoin.getJoinType() != JoinRelType.INNER || bottomJoin.getJoinType() != JoinRelType.INNER) {
            return;
        }
        ArrayList<RexNode> intersecting = new ArrayList<RexNode>();
        ArrayList<RexNode> nonIntersecting = new ArrayList<RexNode>();
        JoinPushThroughJoinRule.split(topJoin.getCondition(), bBitSet, intersecting, nonIntersecting);
        if (nonIntersecting.isEmpty()) {
            return;
        }
        ArrayList<RexNode> bottomIntersecting = new ArrayList<RexNode>();
        ArrayList<RexNode> bottomNonIntersecting = new ArrayList<RexNode>();
        JoinPushThroughJoinRule.split(bottomJoin.getCondition(), bBitSet, bottomIntersecting, bottomNonIntersecting);
        Mappings.TargetMapping bottomMapping = Mappings.createShiftMapping(aCount + bCount + cCount, 0, 0, aCount, aCount, aCount + bCount, cCount);
        ArrayList newBottomList = new ArrayList();
        new RexPermuteInputsShuttle(bottomMapping, new RelNode[]{relA, relC}).visitList(nonIntersecting, newBottomList);
        new RexPermuteInputsShuttle(bottomMapping, new RelNode[]{relA, relC}).visitList(bottomNonIntersecting, newBottomList);
        RexBuilder rexBuilder = cluster.getRexBuilder();
        RexNode newBottomCondition = RexUtil.composeConjunction(rexBuilder, newBottomList);
        Join newBottomJoin = bottomJoin.copy(bottomJoin.getTraitSet(), newBottomCondition, relA, (RelNode)relC, bottomJoin.getJoinType(), bottomJoin.isSemiJoinDone());
        Mappings.TargetMapping topMapping = Mappings.createShiftMapping(aCount + bCount + cCount, 0, 0, aCount, aCount + cCount, aCount, bCount, aCount, aCount + bCount, cCount);
        ArrayList newTopList = new ArrayList();
        new RexPermuteInputsShuttle(topMapping, newBottomJoin, relB).visitList(intersecting, newTopList);
        new RexPermuteInputsShuttle(topMapping, newBottomJoin, relB).visitList(bottomIntersecting, newTopList);
        RexNode newTopCondition = RexUtil.composeConjunction(rexBuilder, newTopList);
        Join newTopJoin = topJoin.copy(topJoin.getTraitSet(), newTopCondition, newBottomJoin, relB, topJoin.getJoinType(), topJoin.isSemiJoinDone());
        assert (!Mappings.isIdentity(topMapping));
        RelBuilder relBuilder = call.builder();
        relBuilder.push(newTopJoin);
        relBuilder.project((Iterable<? extends RexNode>)relBuilder.fields(topMapping));
        call.transformTo(relBuilder.build());
    }

    private static void onMatchLeft(RelOptRuleCall call) {
        Join topJoin = (Join)call.rel(0);
        Join bottomJoin = (Join)call.rel(1);
        Object relC = call.rel(2);
        RelNode relA = bottomJoin.getLeft();
        RelNode relB = bottomJoin.getRight();
        RelOptCluster cluster = topJoin.getCluster();
        int aCount = relA.getRowType().getFieldCount();
        int bCount = relB.getRowType().getFieldCount();
        int cCount = relC.getRowType().getFieldCount();
        ImmutableBitSet aBitSet = ImmutableBitSet.range(aCount);
        if (topJoin.getJoinType() != JoinRelType.INNER || bottomJoin.getJoinType() != JoinRelType.INNER) {
            return;
        }
        ArrayList<RexNode> intersecting = new ArrayList<RexNode>();
        ArrayList<RexNode> nonIntersecting = new ArrayList<RexNode>();
        JoinPushThroughJoinRule.split(topJoin.getCondition(), aBitSet, intersecting, nonIntersecting);
        if (nonIntersecting.isEmpty()) {
            return;
        }
        ArrayList<RexNode> bottomIntersecting = new ArrayList<RexNode>();
        ArrayList<RexNode> bottomNonIntersecting = new ArrayList<RexNode>();
        JoinPushThroughJoinRule.split(bottomJoin.getCondition(), aBitSet, bottomIntersecting, bottomNonIntersecting);
        Mappings.TargetMapping bottomMapping = Mappings.createShiftMapping(aCount + bCount + cCount, cCount, aCount, bCount, 0, aCount + bCount, cCount);
        ArrayList newBottomList = new ArrayList();
        new RexPermuteInputsShuttle(bottomMapping, new RelNode[]{relC, relB}).visitList(nonIntersecting, newBottomList);
        new RexPermuteInputsShuttle(bottomMapping, new RelNode[]{relC, relB}).visitList(bottomNonIntersecting, newBottomList);
        RexBuilder rexBuilder = cluster.getRexBuilder();
        RexNode newBottomCondition = RexUtil.composeConjunction(rexBuilder, newBottomList);
        Join newBottomJoin = bottomJoin.copy(bottomJoin.getTraitSet(), newBottomCondition, (RelNode)relC, relB, bottomJoin.getJoinType(), bottomJoin.isSemiJoinDone());
        Mappings.TargetMapping topMapping = Mappings.createShiftMapping(aCount + bCount + cCount, cCount + bCount, 0, aCount, cCount, aCount, bCount, 0, aCount + bCount, cCount);
        ArrayList newTopList = new ArrayList();
        new RexPermuteInputsShuttle(topMapping, newBottomJoin, relA).visitList(intersecting, newTopList);
        new RexPermuteInputsShuttle(topMapping, newBottomJoin, relA).visitList(bottomIntersecting, newTopList);
        RexNode newTopCondition = RexUtil.composeConjunction(rexBuilder, newTopList);
        Join newTopJoin = topJoin.copy(topJoin.getTraitSet(), newTopCondition, newBottomJoin, relA, topJoin.getJoinType(), topJoin.isSemiJoinDone());
        RelBuilder relBuilder = call.builder();
        relBuilder.push(newTopJoin);
        relBuilder.project((Iterable<? extends RexNode>)relBuilder.fields(topMapping));
        call.transformTo(relBuilder.build());
    }

    static void split(RexNode condition, ImmutableBitSet bitSet, List<RexNode> intersecting, List<RexNode> nonIntersecting) {
        for (RexNode node : RelOptUtil.conjunctions(condition)) {
            ImmutableBitSet inputBitSet = RelOptUtil.InputFinder.bits(node);
            if (bitSet.intersects(inputBitSet)) {
                intersecting.add(node);
                continue;
            }
            nonIntersecting.add(node);
        }
    }

    public static interface Config
    extends RelRule.Config {
        public static final Config RIGHT = EMPTY.withDescription("JoinPushThroughJoinRule:right").as(Config.class).withOperandFor(LogicalJoin.class).withRight(true);
        public static final Config LEFT = EMPTY.withDescription("JoinPushThroughJoinRule:left").as(Config.class).withOperandFor(LogicalJoin.class).withRight(false);

        @Override
        default public JoinPushThroughJoinRule toRule() {
            return new JoinPushThroughJoinRule(this);
        }

        @ImmutableBeans.Property
        @ImmutableBeans.BooleanDefault(value=false)
        public boolean isRight();

        public Config withRight(boolean var1);

        default public Config withOperandFor(Class<? extends Join> joinClass) {
            return this.withOperandSupplier(b0 -> b0.operand(joinClass).inputs(b1 -> b1.operand(joinClass).anyInputs(), b2 -> b2.operand(RelNode.class).predicate(n -> !n.isEnforcer()).anyInputs())).as(Config.class);
        }
    }
}

