/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import java.util.function.LongConsumer;
import org.apache.solr.analytics.function.mapping.LambdaFunction;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.LongValue;
import org.apache.solr.analytics.value.LongValueStream;

class LongStreamInLongValueOutFunction
extends LongValue.AbstractLongValue
implements LongConsumer {
    private final LongValueStream param;
    private final LambdaFunction.TwoLongInLongOutLambda lambda;
    private final String name;
    private final String exprStr;
    private final AnalyticsValueStream.ExpressionType funcType;
    private boolean exists = false;
    private long value;

    public LongStreamInLongValueOutFunction(String name, LambdaFunction.TwoLongInLongOutLambda lambda, LongValueStream param) {
        this.name = name;
        this.lambda = lambda;
        this.param = param;
        this.exprStr = AnalyticsValueStream.createExpressionString(name, param);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param);
    }

    @Override
    public long getLong() {
        this.exists = false;
        this.param.streamLongs(this);
        return this.value;
    }

    @Override
    public boolean exists() {
        return this.exists;
    }

    @Override
    public void accept(long paramValue) {
        if (!this.exists) {
            this.exists = true;
            this.value = paramValue;
        } else {
            this.value = this.lambda.apply(this.value, paramValue);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

