/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.export;

import org.apache.lucene.util.ArrayUtil;
import org.apache.solr.handler.export.SortDoc;

final class SortQueue {
    protected int size = 0;
    protected final int maxSize;
    private final SortDoc[] heap;
    private final SortDoc proto;
    private SortDoc[] cache;

    public SortQueue(int maxSize, SortDoc proto) {
        int heapSize;
        this.proto = proto;
        if (0 == maxSize) {
            heapSize = 2;
        } else {
            if (maxSize > ArrayUtil.MAX_ARRAY_LENGTH) {
                throw new IllegalArgumentException("maxSize must be <= " + ArrayUtil.MAX_ARRAY_LENGTH + "; got: " + maxSize);
            }
            heapSize = maxSize + 1;
        }
        this.heap = new SortDoc[heapSize];
        this.maxSize = maxSize;
    }

    private static final boolean lessThan(SortDoc t1, SortDoc t2) {
        return t1.lessThan(t2);
    }

    protected void populate() {
        this.cache = new SortDoc[this.heap.length];
        for (int i = 1; i < this.heap.length; ++i) {
            this.cache[i] = this.heap[i] = this.proto.copy();
        }
        this.size = this.maxSize;
    }

    protected void reset() {
        if (this.cache != null) {
            System.arraycopy(this.cache, 1, this.heap, 1, this.heap.length - 1);
            this.size = this.maxSize;
        } else {
            this.populate();
        }
    }

    public final SortDoc add(SortDoc element) {
        ++this.size;
        this.heap[this.size] = element;
        this.upHeap();
        return this.heap[1];
    }

    public final SortDoc top() {
        return this.heap[1];
    }

    public final SortDoc pop() {
        if (this.size > 0) {
            SortDoc result = this.heap[1];
            this.heap[1] = this.heap[this.size];
            this.heap[this.size] = null;
            --this.size;
            this.downHeap();
            return result;
        }
        return null;
    }

    public final SortDoc updateTop() {
        this.downHeap();
        return this.heap[1];
    }

    public final int size() {
        return this.size;
    }

    public final void clear() {
        for (int i = 0; i <= this.size; ++i) {
            this.heap[i] = null;
        }
        this.size = 0;
    }

    private final void upHeap() {
        int i = this.size;
        SortDoc node = this.heap[i];
        for (int j = i >>> 1; j > 0 && SortQueue.lessThan(node, this.heap[j]); j >>>= 1) {
            this.heap[i] = this.heap[j];
            i = j;
        }
        this.heap[i] = node;
    }

    private final void downHeap() {
        int i = 1;
        SortDoc node = this.heap[i];
        int j = i << 1;
        int k = j + 1;
        if (k <= this.size && SortQueue.lessThan(this.heap[k], this.heap[j])) {
            j = k;
        }
        while (j <= this.size && SortQueue.lessThan(this.heap[j], node)) {
            this.heap[i] = this.heap[j];
            i = j;
            k = (j = i << 1) + 1;
            if (k > this.size || !SortQueue.lessThan(this.heap[k], this.heap[j])) continue;
            j = k;
        }
        this.heap[i] = node;
    }
}

