/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json.resolver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.layout.template.json.JsonTemplateLayout;
import org.apache.logging.log4j.layout.template.json.resolver.EventResolverContext;
import org.apache.logging.log4j.layout.template.json.resolver.TemplateResolver;
import org.apache.logging.log4j.layout.template.json.resolver.TemplateResolverConfig;
import org.apache.logging.log4j.layout.template.json.resolver.TemplateResolverContext;
import org.apache.logging.log4j.layout.template.json.resolver.TemplateResolverFactory;
import org.apache.logging.log4j.layout.template.json.util.JsonReader;
import org.apache.logging.log4j.layout.template.json.util.JsonWriter;

public final class TemplateResolvers {
    private static final String RESOLVER_FIELD_NAME = "$resolver";
    private static final TemplateResolver<?> EMPTY_ARRAY_RESOLVER = new UnresolvableTemplateResolver(){

        @Override
        public void resolve(Object value, JsonWriter jsonWriter) {
            jsonWriter.writeArrayStart();
            jsonWriter.writeArrayEnd();
        }
    };
    private static final TemplateResolver<?> EMPTY_OBJECT_RESOLVER = new UnresolvableTemplateResolver(){

        @Override
        public void resolve(Object value, JsonWriter jsonWriter) {
            jsonWriter.writeObjectStart();
            jsonWriter.writeObjectEnd();
        }
    };
    private static final TemplateResolver<?> NULL_RESOLVER = new UnresolvableTemplateResolver(){

        @Override
        public void resolve(Object value, JsonWriter jsonWriter) {
            jsonWriter.writeNull();
        }
    };

    private TemplateResolvers() {
    }

    public static <V, C extends TemplateResolverContext<V, C>> TemplateResolver<V> ofTemplate(C context, String template) {
        Map<String, Object> node;
        try {
            node = JsonReader.read(template);
        }
        catch (Exception error) {
            String message = String.format("failed parsing template (template=%s)", template);
            throw new RuntimeException(message, error);
        }
        if (context instanceof EventResolverContext) {
            EventResolverContext eventResolverContext = (EventResolverContext)context;
            JsonTemplateLayout.EventTemplateAdditionalField[] additionalFields = eventResolverContext.getAdditionalFields();
            TemplateResolvers.appendAdditionalFields(node, additionalFields);
            String rootObjectKey = eventResolverContext.getEventTemplateRootObjectKey();
            if (rootObjectKey != null) {
                node = Collections.singletonMap(rootObjectKey, node);
            }
        }
        return TemplateResolvers.ofObject(context, node);
    }

    private static void appendAdditionalFields(Object node, JsonTemplateLayout.EventTemplateAdditionalField[] additionalFields) {
        if (additionalFields.length > 0) {
            Map objectNode;
            try {
                Map map;
                objectNode = map = (Map)node;
            }
            catch (ClassCastException error) {
                String message = String.format("was expecting an object to merge additional fields: %s", node.getClass().getName());
                throw new IllegalArgumentException(message);
            }
            for (JsonTemplateLayout.EventTemplateAdditionalField additionalField : additionalFields) {
                Object additionalFieldValue;
                String additionalFieldKey = additionalField.getKey();
                switch (additionalField.getFormat()) {
                    case STRING: {
                        additionalFieldValue = additionalField.getValue();
                        break;
                    }
                    case JSON: {
                        try {
                            additionalFieldValue = JsonReader.read(additionalField.getValue());
                            break;
                        }
                        catch (Exception error) {
                            String message = String.format("failed reading JSON provided by additional field: %s", additionalFieldKey);
                            throw new IllegalArgumentException(message, error);
                        }
                    }
                    default: {
                        String message = String.format("unknown format %s for additional field: %s", new Object[]{additionalFieldKey, additionalField.getFormat()});
                        throw new IllegalArgumentException(message);
                    }
                }
                objectNode.put(additionalFieldKey, additionalFieldValue);
            }
        }
    }

    private static <V, C extends TemplateResolverContext<V, C>> TemplateResolver<V> ofObject(C context, Object object) {
        if (object == null) {
            TemplateResolver<?> nullResolver = NULL_RESOLVER;
            return nullResolver;
        }
        if (object instanceof List) {
            List list = (List)object;
            return TemplateResolvers.ofList(context, list);
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return TemplateResolvers.ofMap(context, map);
        }
        if (object instanceof String) {
            String string = (String)object;
            return TemplateResolvers.ofString(context, string);
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            return TemplateResolvers.ofNumber(number);
        }
        if (object instanceof Boolean) {
            boolean value = (Boolean)object;
            return TemplateResolvers.ofBoolean(value);
        }
        String message = String.format("invalid JSON node type (class=%s)", object.getClass().getName());
        throw new IllegalArgumentException(message);
    }

    private static <V, C extends TemplateResolverContext<V, C>> TemplateResolver<V> ofList(C context, List<Object> list) {
        List itemResolvers = list.stream().map(item -> {
            TemplateResolver itemResolver = TemplateResolvers.ofObject(context, item);
            if (itemResolver.isFlattening()) {
                throw new IllegalArgumentException("flattening resolvers are not allowed in lists");
            }
            return itemResolver;
        }).collect(Collectors.toList());
        if (itemResolvers.isEmpty()) {
            TemplateResolver<?> emptyArrayResolver = EMPTY_ARRAY_RESOLVER;
            return emptyArrayResolver;
        }
        return (value, jsonWriter) -> {
            jsonWriter.writeArrayStart();
            for (int itemResolverIndex = 0; itemResolverIndex < itemResolvers.size(); ++itemResolverIndex) {
                if (itemResolverIndex > 0) {
                    jsonWriter.writeSeparator();
                }
                TemplateResolver itemResolver = (TemplateResolver)itemResolvers.get(itemResolverIndex);
                itemResolver.resolve(value, jsonWriter);
            }
            jsonWriter.writeArrayEnd();
        };
    }

    private static <V, C extends TemplateResolverContext<V, C>> TemplateResolver<V> ofMap(C context, Map<String, Object> map) {
        if (map.containsKey(RESOLVER_FIELD_NAME)) {
            return TemplateResolvers.ofResolver(context, map);
        }
        ArrayList fieldNames = new ArrayList();
        final ArrayList fieldResolvers = new ArrayList();
        map.forEach((fieldName, fieldValue) -> {
            TemplateResolver fieldResolver = TemplateResolvers.ofObject(context, fieldValue);
            boolean resolvable = fieldResolver.isResolvable();
            if (resolvable) {
                fieldNames.add(fieldName);
                fieldResolvers.add(fieldResolver);
            }
        });
        final int fieldCount = fieldNames.size();
        if (fieldCount == 0) {
            TemplateResolver<?> emptyObjectResolver = EMPTY_OBJECT_RESOLVER;
            return emptyObjectResolver;
        }
        final List fieldPrefixes = fieldNames.stream().map(fieldName -> {
            try (JsonWriter jsonWriter = context.getJsonWriter();){
                jsonWriter.writeString((CharSequence)fieldName);
                jsonWriter.getStringBuilder().append(':');
                String string = jsonWriter.getStringBuilder().toString();
                return string;
            }
        }).collect(Collectors.toList());
        return new TemplateResolver<V>(){

            @Override
            public boolean isResolvable() {
                return true;
            }

            @Override
            public boolean isResolvable(V value) {
                for (int fieldIndex = 0; fieldIndex < fieldCount; ++fieldIndex) {
                    TemplateResolver fieldResolver = (TemplateResolver)fieldResolvers.get(fieldIndex);
                    boolean resolvable = fieldResolver.isResolvable(value);
                    if (!resolvable) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void resolve(V value, JsonWriter jsonWriter) {
                StringBuilder jsonWriterStringBuilder = jsonWriter.getStringBuilder();
                jsonWriter.writeObjectStart();
                int resolvedFieldCount = 0;
                for (int fieldIndex = 0; fieldIndex < fieldCount; ++fieldIndex) {
                    TemplateResolver fieldResolver = (TemplateResolver)fieldResolvers.get(fieldIndex);
                    boolean resolvable = fieldResolver.isResolvable(value);
                    if (!resolvable) continue;
                    boolean succeedingEntry = resolvedFieldCount > 0;
                    boolean flattening = fieldResolver.isFlattening();
                    if (flattening) {
                        boolean resolved;
                        int initLength = jsonWriterStringBuilder.length();
                        fieldResolver.resolve(value, jsonWriter, succeedingEntry);
                        boolean bl = resolved = jsonWriterStringBuilder.length() > initLength;
                        if (!resolved) continue;
                        ++resolvedFieldCount;
                        continue;
                    }
                    if (succeedingEntry) {
                        jsonWriter.writeSeparator();
                    }
                    String fieldPrefix = (String)fieldPrefixes.get(fieldIndex);
                    jsonWriter.writeRawString(fieldPrefix);
                    fieldResolver.resolve(value, jsonWriter, succeedingEntry);
                    ++resolvedFieldCount;
                }
                jsonWriter.writeObjectEnd();
            }
        };
    }

    private static <V, C extends TemplateResolverContext<V, C>> TemplateResolver<V> ofResolver(C context, Map<String, Object> map) {
        Object resolverNameObject = map.get(RESOLVER_FIELD_NAME);
        if (!(resolverNameObject instanceof String)) {
            throw new IllegalArgumentException("invalid resolver name: " + resolverNameObject);
        }
        String resolverName = (String)resolverNameObject;
        TemplateResolverFactory<V, C, TemplateResolver<V>> resolverFactory = context.getResolverFactoryByName().get(resolverName);
        if (resolverFactory == null) {
            throw new IllegalArgumentException("unknown resolver: " + resolverName);
        }
        TemplateResolverConfig resolverConfig = new TemplateResolverConfig(map);
        return resolverFactory.create(context, resolverConfig);
    }

    private static <V, C extends TemplateResolverContext<V, C>> TemplateResolver<V> ofString(C context, String fieldValue) {
        boolean substitutionNeeded = fieldValue.contains("${");
        JsonWriter contextJsonWriter = context.getJsonWriter();
        if (substitutionNeeded) {
            if (EventResolverContext.class.isAssignableFrom(context.getContextClass())) {
                return (value, jsonWriter) -> {
                    LogEvent logEvent = (LogEvent)value;
                    String replacedText = context.getSubstitutor().replace(logEvent, fieldValue);
                    jsonWriter.writeString(replacedText);
                };
            }
            String replacedText = context.getSubstitutor().replace(null, fieldValue);
            if (replacedText == null) {
                TemplateResolver<?> resolver = NULL_RESOLVER;
                return resolver;
            }
            String escapedReplacedText = contextJsonWriter.use(() -> contextJsonWriter.writeString(replacedText));
            return (value, jsonWriter) -> jsonWriter.writeRawString(escapedReplacedText);
        }
        String escapedFieldValue = contextJsonWriter.use(() -> contextJsonWriter.writeString(fieldValue));
        return (value, jsonWriter) -> jsonWriter.writeRawString(escapedFieldValue);
    }

    private static <V> TemplateResolver<V> ofNumber(Number number) {
        String numberString = String.valueOf(number);
        return (ignored, jsonWriter) -> jsonWriter.writeRawString(numberString);
    }

    private static <V> TemplateResolver<V> ofBoolean(boolean value) {
        return (ignored, jsonWriter) -> jsonWriter.writeBoolean(value);
    }

    private static abstract class UnresolvableTemplateResolver
    implements TemplateResolver<Object> {
        private UnresolvableTemplateResolver() {
        }

        @Override
        public final boolean isResolvable() {
            return false;
        }

        @Override
        public final boolean isResolvable(Object value) {
            return false;
        }
    }
}

