"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var canvas_1 = require("../../../../renderers/canvas");
var rendering_1 = require("../../rendering/rendering");
var rect_1 = require("./primitives/rect");
var bar_1 = require("./styles/bar");
function renderBars(ctx, barGeometries, sharedStyle, clippings, highlightedLegendItem) {
    canvas_1.withContext(ctx, function (ctx) {
        canvas_1.withClip(ctx, clippings, function (ctx) {
            barGeometries.forEach(function (barGeometry) {
                var x = barGeometry.x, y = barGeometry.y, width = barGeometry.width, height = barGeometry.height, color = barGeometry.color, seriesStyle = barGeometry.seriesStyle;
                var geometryStateStyle = rendering_1.getGeometryStateStyle(barGeometry.seriesIdentifier, highlightedLegendItem || null, sharedStyle);
                var _a = bar_1.buildBarStyles(color, seriesStyle.rect, seriesStyle.rectBorder, geometryStateStyle), fill = _a.fill, stroke = _a.stroke;
                var rect = { x: x, y: y, width: width, height: height };
                rect_1.renderRect(ctx, rect, fill, stroke);
            });
        });
    });
}
exports.renderBars = renderBars;
//# sourceMappingURL=bars.js.map