/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.assimp.AIString;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiExportDataBlob")
public class AIExportDataBlob
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SIZE;
    public static final int DATA;
    public static final int NAME;
    public static final int NEXT;

    public AIExportDataBlob(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), AIExportDataBlob.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="size_t")
    public long size() {
        return AIExportDataBlob.nsize(this.address());
    }

    @NativeType(value="void *")
    public ByteBuffer data() {
        return AIExportDataBlob.ndata(this.address());
    }

    @NativeType(value="struct aiString")
    public AIString name() {
        return AIExportDataBlob.nname(this.address());
    }

    @Nullable
    @NativeType(value="struct aiExportDataBlob *")
    public AIExportDataBlob next() {
        return AIExportDataBlob.nnext(this.address());
    }

    public AIExportDataBlob data(@NativeType(value="void *") ByteBuffer value) {
        AIExportDataBlob.ndata(this.address(), value);
        return this;
    }

    public AIExportDataBlob name(@NativeType(value="struct aiString") AIString value) {
        AIExportDataBlob.nname(this.address(), value);
        return this;
    }

    public AIExportDataBlob name(Consumer<AIString> consumer) {
        consumer.accept(this.name());
        return this;
    }

    public AIExportDataBlob next(@Nullable @NativeType(value="struct aiExportDataBlob *") AIExportDataBlob value) {
        AIExportDataBlob.nnext(this.address(), value);
        return this;
    }

    public AIExportDataBlob set(ByteBuffer data, AIString name, @Nullable AIExportDataBlob next) {
        this.data(data);
        this.name(name);
        this.next(next);
        return this;
    }

    public AIExportDataBlob set(AIExportDataBlob src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static AIExportDataBlob malloc() {
        return (AIExportDataBlob)AIExportDataBlob.wrap(AIExportDataBlob.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static AIExportDataBlob calloc() {
        return (AIExportDataBlob)AIExportDataBlob.wrap(AIExportDataBlob.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static AIExportDataBlob create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (AIExportDataBlob)AIExportDataBlob.wrap(AIExportDataBlob.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static AIExportDataBlob create(long address) {
        return (AIExportDataBlob)AIExportDataBlob.wrap(AIExportDataBlob.class, (long)address);
    }

    @Nullable
    public static AIExportDataBlob createSafe(long address) {
        return address == 0L ? null : (AIExportDataBlob)AIExportDataBlob.wrap(AIExportDataBlob.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)AIExportDataBlob.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)AIExportDataBlob.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)AIExportDataBlob.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AIExportDataBlob.__create((int)capacity, (int)SIZEOF);
        return (Buffer)AIExportDataBlob.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)AIExportDataBlob.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)AIExportDataBlob.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static AIExportDataBlob mallocStack() {
        return AIExportDataBlob.mallocStack(MemoryStack.stackGet());
    }

    public static AIExportDataBlob callocStack() {
        return AIExportDataBlob.callocStack(MemoryStack.stackGet());
    }

    public static AIExportDataBlob mallocStack(MemoryStack stack) {
        return (AIExportDataBlob)AIExportDataBlob.wrap(AIExportDataBlob.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIExportDataBlob callocStack(MemoryStack stack) {
        return (AIExportDataBlob)AIExportDataBlob.wrap(AIExportDataBlob.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return AIExportDataBlob.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return AIExportDataBlob.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)AIExportDataBlob.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)AIExportDataBlob.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SIZE));
    }

    public static ByteBuffer ndata(long struct) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)DATA)), (int)((int)AIExportDataBlob.nsize(struct)));
    }

    public static AIString nname(long struct) {
        return AIString.create(struct + (long)NAME);
    }

    @Nullable
    public static AIExportDataBlob nnext(long struct) {
        return AIExportDataBlob.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)NEXT)));
    }

    public static void nsize(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SIZE), (long)value);
    }

    public static void ndata(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)DATA), (long)MemoryUtil.memAddress((ByteBuffer)value));
        AIExportDataBlob.nsize(struct, value.remaining());
    }

    public static void nname(long struct, AIString value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)NAME), (long)AIString.SIZEOF);
    }

    public static void nnext(long struct, @Nullable AIExportDataBlob value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)DATA)));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            AIExportDataBlob.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = AIExportDataBlob.__struct((Struct.Member[])new Struct.Member[]{AIExportDataBlob.__member((int)POINTER_SIZE), AIExportDataBlob.__member((int)POINTER_SIZE), AIExportDataBlob.__member((int)AIString.SIZEOF, (int)AIString.ALIGNOF), AIExportDataBlob.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SIZE = layout.offsetof(0);
        DATA = layout.offsetof(1);
        NAME = layout.offsetof(2);
        NEXT = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<AIExportDataBlob, Buffer>
    implements NativeResource {
        private static final AIExportDataBlob ELEMENT_FACTORY = AIExportDataBlob.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected AIExportDataBlob getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="size_t")
        public long size() {
            return AIExportDataBlob.nsize(this.address());
        }

        @NativeType(value="void *")
        public ByteBuffer data() {
            return AIExportDataBlob.ndata(this.address());
        }

        @NativeType(value="struct aiString")
        public AIString name() {
            return AIExportDataBlob.nname(this.address());
        }

        @Nullable
        @NativeType(value="struct aiExportDataBlob *")
        public AIExportDataBlob next() {
            return AIExportDataBlob.nnext(this.address());
        }

        public Buffer data(@NativeType(value="void *") ByteBuffer value) {
            AIExportDataBlob.ndata(this.address(), value);
            return this;
        }

        public Buffer name(@NativeType(value="struct aiString") AIString value) {
            AIExportDataBlob.nname(this.address(), value);
            return this;
        }

        public Buffer name(Consumer<AIString> consumer) {
            consumer.accept(this.name());
            return this;
        }

        public Buffer next(@Nullable @NativeType(value="struct aiExportDataBlob *") AIExportDataBlob value) {
            AIExportDataBlob.nnext(this.address(), value);
            return this;
        }
    }
}

