/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectStatusInformation;
import ca.sqlpower.util.MonitorableImpl;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class ArchitectStatusBar
implements ArchitectStatusInformation {
    private static final Logger logger = Logger.getLogger(ArchitectStatusBar.class);
    private static final ImageIcon PROGRESS_BAR_ICON = new ImageIcon(ArchitectStatusBar.class.getResource("/icons/progressBar.png"));
    private final JPanel statusBar = new JPanel();
    private final JPanel progressBarPanel = new JPanel();
    @GuardedBy(value="this")
    private final List<ArchitectStatusProgressBar> progressBars = new ArrayList<ArchitectStatusProgressBar>();

    public ArchitectStatusBar() {
        DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("fill:pref:grow"), this.statusBar);
        builder.append((Component)this.progressBarPanel);
    }

    public JPanel getStatusBar() {
        return this.statusBar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MonitorableImpl createProgressMonitor() {
        ArchitectStatusProgressBar newBar = new ArchitectStatusProgressBar();
        ArchitectStatusBar architectStatusBar = this;
        synchronized (architectStatusBar) {
            this.progressBars.add(newBar);
        }
        this.resizeProgressBars();
        return newBar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeProgressBar(ArchitectStatusProgressBar bar) {
        ArchitectStatusBar architectStatusBar = this;
        synchronized (architectStatusBar) {
            this.progressBars.remove((Object)bar);
        }
        this.resizeProgressBars();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resizeProgressBars() {
        Graphics g = this.progressBarPanel.getGraphics();
        g.setColor(this.progressBarPanel.getBackground());
        g.fillRect(0, 0, this.progressBarPanel.getWidth(), this.progressBarPanel.getHeight());
        ArchitectStatusBar architectStatusBar = this;
        synchronized (architectStatusBar) {
            if (this.progressBars.isEmpty()) {
                return;
            }
            int newWidth = this.progressBarPanel.getWidth() / this.progressBars.size();
            int x = 0;
            for (ArchitectStatusProgressBar bar : this.progressBars) {
                bar.setX(x);
                bar.setWidth(newWidth);
                x += newWidth;
            }
        }
    }

    private class ArchitectStatusProgressBar
    extends MonitorableImpl {
        private int x = 0;
        private int width = 0;

        private ArchitectStatusProgressBar() {
        }

        public synchronized void setJobSize(Integer jobSize) {
            super.setJobSize(jobSize);
            this.paint();
        }

        public synchronized void setMessage(String message) {
            super.setMessage(message);
            this.paint();
        }

        public synchronized void setProgress(int progress) {
            super.setProgress(progress);
            this.paint();
            if (progress >= this.getJobSize()) {
                ArchitectStatusBar.this.removeProgressBar(this);
            }
        }

        public synchronized void incrementProgress() {
            super.incrementProgress();
            this.paint();
            if (this.getProgress() >= this.getJobSize()) {
                ArchitectStatusBar.this.removeProgressBar(this);
            }
        }

        public synchronized void setCancelled(boolean cancelled) {
            super.setCancelled(cancelled);
            this.paint();
            ArchitectStatusBar.this.removeProgressBar(this);
        }

        public synchronized void setFinished(boolean finished) {
            super.setFinished(finished);
            this.paint();
            ArchitectStatusBar.this.removeProgressBar(this);
        }

        private synchronized void paint() {
            Graphics g = ArchitectStatusBar.this.progressBarPanel.getGraphics();
            ArchitectStatusBar.this.progressBarPanel.setDoubleBuffered(true);
            if (!this.isCancelled() && !this.isFinished() && this.getJobSize() != null && this.getProgress() < this.getJobSize()) {
                BufferedImage buffer = new BufferedImage(this.getWidth(), ArchitectStatusBar.this.progressBarPanel.getHeight(), 2);
                Graphics bufferG = buffer.getGraphics();
                bufferG = ArchitectStatusBar.this.progressBarPanel.getGraphics();
                bufferG.setColor(ArchitectStatusBar.this.progressBarPanel.getBackground());
                bufferG.fillRect(this.getX(), 0, this.getWidth(), ArchitectStatusBar.this.progressBarPanel.getHeight());
                bufferG.drawImage(PROGRESS_BAR_ICON.getImage(), this.getX(), 0, this.getWidth() * this.getProgress() / this.getJobSize(), ArchitectStatusBar.this.progressBarPanel.getHeight(), null);
                bufferG.setColor(Color.BLACK);
                if (this.getMessage() != null) {
                    Font font = g.getFont();
                    FontMetrics fm = g.getFontMetrics();
                    for (int fontSize = font.getSize(); fm.getHeight() > ArchitectStatusBar.this.progressBarPanel.getHeight() && fontSize > 0; --fontSize) {
                        font = font.deriveFont((float)(fontSize - 1));
                        g.setFont(font);
                        fm = g.getFontMetrics();
                    }
                    int fontX = (int)((double)(this.getWidth() / 2) - fm.getStringBounds(this.getMessage(), g).getWidth() / 2.0) + this.getX();
                    int fontY = ArchitectStatusBar.this.progressBarPanel.getHeight() / 2 + fm.getHeight() / 2;
                    bufferG.drawString(this.getMessage(), fontX, fontY);
                }
                g.drawImage(buffer, this.getWidth(), ArchitectStatusBar.this.progressBarPanel.getHeight(), null);
            } else {
                g.setColor(ArchitectStatusBar.this.progressBarPanel.getBackground());
                g.fillRect(this.getX(), 0, this.getWidth(), ArchitectStatusBar.this.progressBarPanel.getHeight());
            }
        }

        public synchronized void setX(int x) {
            this.x = x;
            this.paint();
        }

        public synchronized int getX() {
            return this.x;
        }

        public synchronized void setWidth(int width) {
            this.width = width;
            this.paint();
        }

        public synchronized int getWidth() {
            return this.width;
        }
    }
}

