/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.LongStream;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.dfs.BlockBasedFile;
import org.eclipse.jgit.internal.storage.dfs.DfsBlock;
import org.eclipse.jgit.internal.storage.dfs.DfsBlockCacheConfig;
import org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.eclipse.jgit.internal.storage.dfs.DfsRepositoryDescription;
import org.eclipse.jgit.internal.storage.dfs.DfsStreamKey;
import org.eclipse.jgit.internal.storage.dfs.ReadableChannel;
import org.eclipse.jgit.internal.storage.pack.PackExt;

public final class DfsBlockCache {
    private static volatile DfsBlockCache cache;
    private final int tableSize;
    private final AtomicReferenceArray<HashEntry> table;
    private final ReentrantLock[] loadLocks;
    private final long maxBytes;
    private final long maxStreamThroughCache;
    private final int blockSize;
    private final int blockSizeShift;
    private final AtomicReference<AtomicLong[]> statHit;
    private final AtomicReference<AtomicLong[]> statMiss;
    private final AtomicReference<AtomicLong[]> statEvict;
    private final AtomicReference<AtomicLong[]> liveBytes;
    private final ReentrantLock clockLock;
    private Ref clockHand;

    public static void reconfigure(DfsBlockCacheConfig cfg) {
        cache = new DfsBlockCache(cfg);
    }

    public static DfsBlockCache getInstance() {
        return cache;
    }

    private DfsBlockCache(DfsBlockCacheConfig cfg) {
        this.tableSize = DfsBlockCache.tableSize(cfg);
        if (this.tableSize < 1) {
            throw new IllegalArgumentException(JGitText.get().tSizeMustBeGreaterOrEqual1);
        }
        this.table = new AtomicReferenceArray(this.tableSize);
        this.loadLocks = new ReentrantLock[cfg.getConcurrencyLevel()];
        for (int i = 0; i < this.loadLocks.length; ++i) {
            this.loadLocks[i] = new ReentrantLock(true);
        }
        this.maxBytes = cfg.getBlockLimit();
        this.maxStreamThroughCache = (long)((double)this.maxBytes * cfg.getStreamRatio());
        this.blockSize = cfg.getBlockSize();
        this.blockSizeShift = Integer.numberOfTrailingZeros(this.blockSize);
        this.clockLock = new ReentrantLock(true);
        String none = "";
        this.clockHand = new Ref<Object>(DfsStreamKey.of(new DfsRepositoryDescription(none), none, null), -1L, 0, null);
        this.clockHand.next = this.clockHand;
        this.statHit = new AtomicReference<AtomicLong[]>(DfsBlockCache.newCounters());
        this.statMiss = new AtomicReference<AtomicLong[]>(DfsBlockCache.newCounters());
        this.statEvict = new AtomicReference<AtomicLong[]>(DfsBlockCache.newCounters());
        this.liveBytes = new AtomicReference<AtomicLong[]>(DfsBlockCache.newCounters());
    }

    boolean shouldCopyThroughCache(long length) {
        return length <= this.maxStreamThroughCache;
    }

    public long[] getCurrentSize() {
        return DfsBlockCache.getStatVals(this.liveBytes);
    }

    public long getFillPercentage() {
        return LongStream.of(this.getCurrentSize()).sum() * 100L / this.maxBytes;
    }

    public long[] getHitCount() {
        return DfsBlockCache.getStatVals(this.statHit);
    }

    public long[] getMissCount() {
        return DfsBlockCache.getStatVals(this.statMiss);
    }

    public long[] getTotalRequestCount() {
        int i;
        AtomicLong[] hit = this.statHit.get();
        AtomicLong[] miss = this.statMiss.get();
        long[] cnt = new long[Math.max(hit.length, miss.length)];
        for (i = 0; i < hit.length; ++i) {
            int n = i;
            cnt[n] = cnt[n] + hit[i].get();
        }
        for (i = 0; i < miss.length; ++i) {
            int n = i;
            cnt[n] = cnt[n] + miss[i].get();
        }
        return cnt;
    }

    public long[] getHitRatio() {
        AtomicLong[] hit = this.statHit.get();
        AtomicLong[] miss = this.statMiss.get();
        long[] ratio = new long[Math.max(hit.length, miss.length)];
        for (int i = 0; i < ratio.length; ++i) {
            long missVal;
            long hitVal;
            long total;
            ratio[i] = i >= hit.length ? 0L : (i >= miss.length ? 100L : ((total = (hitVal = hit[i].get()) + (missVal = miss[i].get())) == 0L ? 0L : hitVal * 100L / total));
        }
        return ratio;
    }

    public long[] getEvictions() {
        return DfsBlockCache.getStatVals(this.statEvict);
    }

    public boolean hasBlock0(DfsStreamKey key2) {
        HashEntry e1 = this.table.get(this.slot(key2, 0L));
        DfsBlock v = (DfsBlock)this.scan(e1, key2, 0L);
        return v != null && v.contains(key2, 0L);
    }

    private int hash(int packHash, long off) {
        return packHash + (int)(off >>> this.blockSizeShift);
    }

    int getBlockSize() {
        return this.blockSize;
    }

    private static int tableSize(DfsBlockCacheConfig cfg) {
        int wsz = cfg.getBlockSize();
        long limit = cfg.getBlockLimit();
        if (wsz <= 0) {
            throw new IllegalArgumentException(JGitText.get().invalidWindowSize);
        }
        if (limit < (long)wsz) {
            throw new IllegalArgumentException(JGitText.get().windowSizeMustBeLesserThanLimit);
        }
        return (int)Math.min(5L * (limit / (long)wsz) / 2L, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DfsBlock getOrLoad(BlockBasedFile file2, long position, DfsReader ctx, @Nullable ReadableChannel fileChannel) throws IOException {
        long requestedPosition = position;
        DfsStreamKey key2 = file2.key;
        int slot = this.slot(key2, position = file2.alignToBlock(position));
        HashEntry e1 = this.table.get(slot);
        DfsBlock v = (DfsBlock)this.scan(e1, key2, position);
        if (v != null && v.contains(key2, requestedPosition)) {
            ++ctx.stats.blockCacheHit;
            DfsBlockCache.getStat(this.statHit, key2).incrementAndGet();
            return v;
        }
        this.reserveSpace(this.blockSize, key2);
        ReentrantLock regionLock = this.lockFor(key2, position);
        regionLock.lock();
        try {
            HashEntry n;
            HashEntry e2 = this.table.get(slot);
            if (e2 != e1 && (v = (DfsBlock)this.scan(e2, key2, position)) != null) {
                ++ctx.stats.blockCacheHit;
                DfsBlockCache.getStat(this.statHit, key2).incrementAndGet();
                this.creditSpace(this.blockSize, key2);
                DfsBlock dfsBlock = v;
                return dfsBlock;
            }
            DfsBlockCache.getStat(this.statMiss, key2).incrementAndGet();
            boolean credit = true;
            try {
                v = file2.readOneBlock(requestedPosition, ctx, fileChannel);
                credit = false;
            }
            finally {
                if (credit) {
                    this.creditSpace(this.blockSize, key2);
                }
            }
            if (position != v.start) {
                position = v.start;
                slot = this.slot(key2, position);
                e2 = this.table.get(slot);
            }
            Ref<DfsBlock> ref2 = new Ref<DfsBlock>(key2, position, v.size(), v);
            ref2.hot = true;
            while (!this.table.compareAndSet(slot, e2, n = new HashEntry(DfsBlockCache.clean(e2), ref2))) {
                e2 = this.table.get(slot);
            }
            this.addToClock(ref2, this.blockSize - v.size());
        }
        finally {
            regionLock.unlock();
        }
        if (v.contains(file2.key, requestedPosition)) {
            return v;
        }
        return this.getOrLoad(file2, requestedPosition, ctx, fileChannel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reserveSpace(int reserve, DfsStreamKey key2) {
        this.clockLock.lock();
        try {
            long live = LongStream.of(this.getCurrentSize()).sum() + (long)reserve;
            if (this.maxBytes < live) {
                Ref prev2 = this.clockHand;
                Ref hand = this.clockHand.next;
                do {
                    if (hand.hot) {
                        hand.hot = false;
                        prev2 = hand;
                        hand = hand.next;
                        continue;
                    }
                    if (prev2 == hand) break;
                    Ref dead = hand;
                    prev2.next = hand = hand.next;
                    dead.next = null;
                    dead.value = null;
                    live -= (long)dead.size;
                    DfsBlockCache.getStat(this.liveBytes, dead.key).addAndGet(-dead.size);
                    DfsBlockCache.getStat(this.statEvict, dead.key).incrementAndGet();
                } while (this.maxBytes < live);
                this.clockHand = prev2;
            }
            DfsBlockCache.getStat(this.liveBytes, key2).addAndGet(reserve);
        }
        finally {
            this.clockLock.unlock();
        }
    }

    private void creditSpace(int credit, DfsStreamKey key2) {
        this.clockLock.lock();
        try {
            DfsBlockCache.getStat(this.liveBytes, key2).addAndGet(-credit);
        }
        finally {
            this.clockLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToClock(Ref ref2, int credit) {
        this.clockLock.lock();
        try {
            if (credit != 0) {
                DfsBlockCache.getStat(this.liveBytes, ref2.key).addAndGet(-credit);
            }
            Ref ptr = this.clockHand;
            ref2.next = ptr.next;
            ptr.next = ref2;
            this.clockHand = ref2;
        }
        finally {
            this.clockLock.unlock();
        }
    }

    void put(DfsBlock v) {
        this.put(v.stream, v.start, v.size(), v);
    }

    <T> Ref<T> putRef(DfsStreamKey key2, long size, T v) {
        return this.put(key2, 0L, (int)Math.min(size, Integer.MAX_VALUE), v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> Ref<T> put(DfsStreamKey key2, long pos, int size, T v) {
        int slot = this.slot(key2, pos);
        HashEntry e1 = this.table.get(slot);
        Ref<T> ref2 = this.scanRef(e1, key2, pos);
        if (ref2 != null) {
            return ref2;
        }
        this.reserveSpace(size, key2);
        ReentrantLock regionLock = this.lockFor(key2, pos);
        regionLock.lock();
        try {
            HashEntry n;
            HashEntry e2 = this.table.get(slot);
            if (e2 != e1 && (ref2 = this.scanRef(e2, key2, pos)) != null) {
                this.creditSpace(size, key2);
                Ref<T> ref3 = ref2;
                return ref3;
            }
            ref2 = new Ref<T>(key2, pos, size, v);
            ref2.hot = true;
            while (!this.table.compareAndSet(slot, e2, n = new HashEntry(DfsBlockCache.clean(e2), ref2))) {
                e2 = this.table.get(slot);
            }
            this.addToClock(ref2, 0);
        }
        finally {
            regionLock.unlock();
        }
        return ref2;
    }

    boolean contains(DfsStreamKey key2, long position) {
        return this.scan(this.table.get(this.slot(key2, position)), key2, position) != null;
    }

    <T> T get(DfsStreamKey key2, long position) {
        T val2 = this.scan(this.table.get(this.slot(key2, position)), key2, position);
        if (val2 == null) {
            DfsBlockCache.getStat(this.statMiss, key2).incrementAndGet();
        } else {
            DfsBlockCache.getStat(this.statHit, key2).incrementAndGet();
        }
        return val2;
    }

    private <T> T scan(HashEntry n, DfsStreamKey key2, long position) {
        Ref<T> r = this.scanRef(n, key2, position);
        return r != null ? (T)r.get() : null;
    }

    <T> Ref<T> getRef(DfsStreamKey key2) {
        Ref<T> r = this.scanRef(this.table.get(this.slot(key2, 0L)), key2, 0L);
        if (r != null) {
            DfsBlockCache.getStat(this.statHit, key2).incrementAndGet();
        } else {
            DfsBlockCache.getStat(this.statMiss, key2).incrementAndGet();
        }
        return r;
    }

    private <T> Ref<T> scanRef(HashEntry n, DfsStreamKey key2, long position) {
        while (n != null) {
            Ref r = n.ref;
            if (r.position == position && r.key.equals(key2)) {
                return r.get() != null ? r : null;
            }
            n = n.next;
        }
        return null;
    }

    private int slot(DfsStreamKey key2, long position) {
        return (this.hash(key2.hash, position) >>> 1) % this.tableSize;
    }

    private ReentrantLock lockFor(DfsStreamKey key2, long position) {
        return this.loadLocks[(this.hash(key2.hash, position) >>> 1) % this.loadLocks.length];
    }

    private static AtomicLong[] newCounters() {
        AtomicLong[] ret = new AtomicLong[PackExt.values().length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new AtomicLong();
        }
        return ret;
    }

    private static AtomicLong getStat(AtomicReference<AtomicLong[]> stats, DfsStreamKey key2) {
        AtomicLong[] vals2;
        AtomicLong[] expect;
        int pos = key2.packExtPos;
        do {
            if (pos < (vals2 = stats.get()).length) {
                return vals2[pos];
            }
            expect = vals2;
            vals2 = new AtomicLong[Math.max(pos + 1, PackExt.values().length)];
            System.arraycopy(expect, 0, vals2, 0, expect.length);
            for (int i = expect.length; i < vals2.length; ++i) {
                vals2[i] = new AtomicLong();
            }
        } while (!stats.compareAndSet(expect, vals2));
        return vals2[pos];
    }

    private static long[] getStatVals(AtomicReference<AtomicLong[]> stat) {
        AtomicLong[] stats = stat.get();
        long[] cnt = new long[stats.length];
        for (int i = 0; i < stats.length; ++i) {
            cnt[i] = stats[i].get();
        }
        return cnt;
    }

    private static HashEntry clean(HashEntry top) {
        while (top != null && top.ref.next == null) {
            top = top.next;
        }
        if (top == null) {
            return null;
        }
        HashEntry n = DfsBlockCache.clean(top.next);
        return n == top.next ? top : new HashEntry(n, top.ref);
    }

    static {
        DfsBlockCache.reconfigure(new DfsBlockCacheConfig());
    }

    private static final class HashEntry {
        final HashEntry next;
        final Ref ref;

        HashEntry(HashEntry n, Ref r) {
            this.next = n;
            this.ref = r;
        }
    }

    static final class Ref<T> {
        final DfsStreamKey key;
        final long position;
        final int size;
        volatile T value;
        Ref next;
        volatile boolean hot;

        Ref(DfsStreamKey key2, long position, int size, T v) {
            this.key = key2;
            this.position = position;
            this.size = size;
            this.value = v;
        }

        T get() {
            T v = this.value;
            if (v != null) {
                this.hot = true;
            }
            return v;
        }

        boolean has() {
            return this.value != null;
        }
    }
}

