/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.graph.vertex;

import ghidra.app.plugin.core.functiongraph.graph.FunctionGraph;
import ghidra.app.plugin.core.functiongraph.graph.vertex.AddressHasher;
import ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex;
import ghidra.app.plugin.core.functiongraph.graph.vertex.GroupHistoryInfo;
import ghidra.app.plugin.core.functiongraph.graph.vertex.GroupedFunctionGraphVertex;
import ghidra.app.plugin.core.functiongraph.graph.vertex.GroupedVertexInfo;
import ghidra.app.plugin.core.functiongraph.mvc.FGController;
import ghidra.app.plugin.core.functiongraph.mvc.FGData;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Content;
import org.jdom.Element;

public class GroupVertexSerializer {
    private static final String GROUP_VERTICES_ELEMENT_NAME = "GROUP_VERTICES";
    private static final String REGROUP_VERTICES_ELEMENT_NAME = "REGROUP_VERTICES";

    private GroupVertexSerializer() {
    }

    public static Element getXMLForRegroupableVertices(FunctionGraph functionGraph) {
        Element element = new Element(REGROUP_VERTICES_ELEMENT_NAME);
        Collection<GroupHistoryInfo> groupHistory = functionGraph.getGroupHistory();
        for (GroupHistoryInfo info : groupHistory) {
            element.addContent((Content)info.toXML(functionGraph));
        }
        return element;
    }

    public static Element getXMLForGroupedVertices(FunctionGraph functionGraph) {
        Element element = new Element(GROUP_VERTICES_ELEMENT_NAME);
        FunctionGraph graph = functionGraph;
        Collection vertices = graph.getVertices();
        for (FGVertex vertex : vertices) {
            if (!(vertex instanceof GroupedFunctionGraphVertex)) continue;
            GroupedVertexInfo info = new GroupedVertexInfo((GroupedFunctionGraphVertex)vertex, functionGraph);
            element.addContent((Content)info.toXML());
        }
        return element;
    }

    public static Collection<GroupHistoryInfo> recreateGroupHistory(FGController controller, Element element) {
        HashSet<GroupHistoryInfo> set = new HashSet<GroupHistoryInfo>();
        List children = element.getChildren("GROUP_HISTORY");
        for (Element child : children) {
            set.add(new GroupHistoryInfo(controller, child));
        }
        return set;
    }

    public static void recreateGroupedVertices(FGController controller, Element element) {
        FunctionGraph functionGraph;
        FGData functionGraphData = controller.getFunctionGraphData();
        FunctionGraph graph = functionGraph = functionGraphData.getFunctionGraph();
        Collection vertices = graph.getVertices();
        for (FGVertex vertex : vertices) {
            if (!(vertex instanceof GroupedFunctionGraphVertex)) continue;
            return;
        }
        List children = element.getChildren("GROUPED_VERTEX_INFO");
        Map<AddressHasher, FGVertex> vertexMap = GroupVertexSerializer.hashVerticesByStartAndEndAddress(functionGraph);
        for (Element groupedVertexElement : children) {
            GroupedVertexInfo info = new GroupedVertexInfo(groupedVertexElement);
            GroupedFunctionGraphVertex vertex = (GroupedFunctionGraphVertex)info.getVertex(controller, vertexMap);
            Point2D location = info.getVertexLocation();
            GroupVertexSerializer.installGroupVertex(controller, vertex, location);
        }
    }

    private static void installGroupVertex(FGController controller, GroupedFunctionGraphVertex vertex, Point2D location) {
        if (vertex == null) {
            return;
        }
        controller.installGroupVertex(vertex, location);
    }

    private static Map<AddressHasher, FGVertex> hashVerticesByStartAndEndAddress(FunctionGraph functionGraph) {
        HashMap<AddressHasher, FGVertex> map = new HashMap<AddressHasher, FGVertex>();
        Set<FGVertex> vertices = functionGraph.getUngroupedVertices();
        for (FGVertex vertex : vertices) {
            AddressSetView addresses = vertex.getAddresses();
            Address minAddress = addresses.getMinAddress();
            Address maxAddress = addresses.getMaxAddress();
            map.put(new AddressHasher(minAddress, maxAddress), vertex);
        }
        return map;
    }
}

