/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.protocol.ghidra;

import ghidra.framework.client.NotConnectedException;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.protocol.ghidra.GhidraProtocolConnector;
import ghidra.framework.protocol.ghidra.RepositoryInfo;
import ghidra.framework.protocol.ghidra.TransientProjectData;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.datastruct.WeakValueHashMap;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.Set;

public class TransientProjectManager {
    private Map<RepositoryInfo, TransientProjectData> repositoryMap = new WeakValueHashMap();
    private static TransientProjectManager transientProjectManager = null;

    public static synchronized TransientProjectManager getTransientProjectManager() {
        if (transientProjectManager == null) {
            transientProjectManager = new TransientProjectManager();
        }
        return transientProjectManager;
    }

    public synchronized int getActiveProjectCount() {
        return this.repositoryMap.size();
    }

    private TransientProjectManager() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.dispose(), "TransientProjectManager Shutdown Hook"));
    }

    public synchronized void dispose() {
        TransientProjectData[] projectDataArray;
        for (TransientProjectData projectData : projectDataArray = this.repositoryMap.values().toArray(new TransientProjectData[this.repositoryMap.size()])) {
            projectData.forcedDispose();
        }
        this.repositoryMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized TransientProjectData getTransientProject(GhidraProtocolConnector protocolConnector, boolean readOnly) throws IOException {
        System.gc();
        String repoName = protocolConnector.getRepositoryName();
        if (repoName == null) {
            throw new IllegalArgumentException("specified protocol connector does not correspond to a repository");
        }
        RepositoryInfo repositoryInfo = new RepositoryInfo(protocolConnector.getRepositoryRootGhidraURL(), repoName, readOnly);
        TransientProjectData projectData = this.repositoryMap.get(repositoryInfo);
        if (projectData == null || !projectData.stopCleanupTimer()) {
            if (protocolConnector.connect(readOnly) != 200) {
                return null;
            }
            RepositoryAdapter repositoryAdapter = protocolConnector.getRepositoryAdapter();
            if (repositoryAdapter == null || !repositoryAdapter.isConnected()) {
                throw new NotConnectedException("protocol connector not connected to repository");
            }
            projectData = this.createTransientProject(repositoryAdapter, repositoryInfo);
            if (projectData != null) {
                this.repositoryMap.put(repositoryInfo, projectData);
            }
        } else {
            Msg.debug((Object)this, (Object)("Reusing existing TransientProjectData: " + projectData.repositoryInfo));
            try {
                RepositoryAdapter repository = projectData.getRepository();
                repository.connect();
                protocolConnector.connect(repository);
            }
            finally {
                projectData.startCleanupTimer();
            }
        }
        Msg.debug((Object)this, (Object)("Number of active TransientProjectData instances: " + this.repositoryMap.size()));
        return projectData;
    }

    synchronized void cleanupProjectData(RepositoryInfo repositoryInfo, TransientProjectData projectData) {
        if (this.repositoryMap.get(repositoryInfo) != projectData) {
            return;
        }
        this.repositoryMap.remove(repositoryInfo);
        if (SystemUtilities.isInTestingMode()) {
            Msg.debug((Object)this, (Object)("Number of active TransientProjectData instances: " + this.repositoryMap.size()));
            Set<Map.Entry<RepositoryInfo, TransientProjectData>> entrySet = this.repositoryMap.entrySet();
            for (Map.Entry<RepositoryInfo, TransientProjectData> entry : entrySet) {
                Msg.debug((Object)this, (Object)("  " + entry.getKey() + " -> " + entry.getValue()));
            }
        }
    }

    private TransientProjectData createTransientProject(RepositoryAdapter repository, RepositoryInfo repositoryInfo) throws IOException {
        File tmp = File.createTempFile("ghidraPrj", "");
        tmp.delete();
        TransientProjectStorageLocator tmpProjectLocation = new TransientProjectStorageLocator(tmp.getParentFile().getAbsolutePath(), tmp.getName(), repositoryInfo);
        return new TransientProjectData(this, tmpProjectLocation, repositoryInfo, repository);
    }

    private static class TransientProjectStorageLocator
    extends ProjectLocator {
        private final RepositoryInfo repositoryInfo;

        TransientProjectStorageLocator(String path, String name, RepositoryInfo repositoryInfo) {
            super(path, name);
            this.repositoryInfo = repositoryInfo;
        }

        @Override
        public URL getURL() {
            return this.repositoryInfo.repositoryURL;
        }

        @Override
        public String getName() {
            return this.repositoryInfo.repositoryURL.toExternalForm();
        }

        @Override
        public boolean isTransient() {
            return true;
        }

        @Override
        public String toString() {
            return this.repositoryInfo.repositoryURL.toExternalForm();
        }
    }
}

