/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.types.hfsplus;

import java.io.PrintStream;
import org.catacombae.csjc.DynamicStruct;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.hfsexplorer.Util;
import org.catacombae.hfsexplorer.types.hfsplus.HFSCatalogNodeID;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusCatalogLeafRecordData;
import org.catacombae.hfsexplorer.types.hfsplus.HFSUniStr255;

public class HFSPlusCatalogThread
extends HFSPlusCatalogLeafRecordData
implements DynamicStruct {
    private final byte[] recordType = new byte[2];
    private final byte[] reserved = new byte[2];
    private final HFSCatalogNodeID parentID;
    private final HFSUniStr255 nodeName;

    public HFSPlusCatalogThread(byte[] data, int offset) {
        System.arraycopy(data, offset + 0, this.recordType, 0, 2);
        System.arraycopy(data, offset + 2, this.reserved, 0, 2);
        this.parentID = new HFSCatalogNodeID(data, offset + 4);
        this.nodeName = new HFSUniStr255(data, offset + 8);
    }

    public byte[] getBytes() {
        byte[] result = new byte[this.length()];
        int offset = 0;
        System.arraycopy(this.recordType, 0, result, offset, this.recordType.length);
        System.arraycopy(this.reserved, 0, result, offset += this.recordType.length, this.reserved.length);
        byte[] tempData = this.parentID.getBytes();
        System.arraycopy(tempData, 0, result, offset += this.reserved.length, tempData.length);
        offset += tempData.length;
        tempData = this.nodeName.getBytes();
        System.arraycopy(tempData, 0, result, offset, tempData.length);
        offset += tempData.length;
        return result;
    }

    public int length() {
        HFSPlusCatalogThread hFSPlusCatalogThread = this;
        return 4 + hFSPlusCatalogThread.parentID.length() + this.nodeName.length();
    }

    public int occupiedSize() {
        return this.length();
    }

    public int maxSize() {
        return 520;
    }

    public short getRecordType() {
        return Util.readShortBE((byte[])this.recordType);
    }

    public short getReserved() {
        return Util.readShortBE((byte[])this.reserved);
    }

    public HFSCatalogNodeID getParentID() {
        return this.parentID;
    }

    public HFSUniStr255 getNodeName() {
        return this.nodeName;
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " recordType: " + this.getRecordType());
        ps.println(prefix + " reserved: " + this.getReserved());
        ps.println(prefix + " parentID: ");
        this.getParentID().print(ps, prefix + "  ");
        ps.println(prefix + " nodeName: ");
        this.getNodeName().print(ps, prefix + "  ");
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "HFSPlusCatalogThread:");
        this.printFields(ps, prefix);
    }

    public Dictionary getStructElements() {
        StructElements.DictionaryBuilder db = new StructElements.DictionaryBuilder(HFSPlusCatalogThread.class.getSimpleName());
        db.addUIntBE("recordType", this.recordType);
        db.addUIntBE("reserved", this.reserved);
        db.add("parentID", this.parentID.getStructElements());
        db.add("nodeName", this.nodeName.getStructElements());
        return db.getResult();
    }
}

