/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.formats;

import ghidra.app.plugin.core.analysis.AnalysisWorker;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.bin.format.coff.archive.CoffArchiveConstants;
import ghidra.app.util.bin.format.coff.archive.CoffArchiveHeader;
import ghidra.app.util.bin.format.coff.archive.CoffArchiveMemberHeader;
import ghidra.app.util.bin.format.coff.archive.FirstLinkerMember;
import ghidra.app.util.bin.format.coff.archive.LongNamesMember;
import ghidra.app.util.bin.format.coff.archive.SecondLinkerMember;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.cmd.BinaryAnalysisCommand;
import ghidra.program.flatapi.FlatProgramAPI;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Group;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.NotEmptyException;
import ghidra.util.task.TaskMonitor;

public class CoffArchiveBinaryAnalysisCommand
extends FlatProgramAPI
implements BinaryAnalysisCommand,
AnalysisWorker {
    private MessageLog messages = new MessageLog();

    @Override
    public boolean analysisWorkerCallback(Program program, Object workerContext, TaskMonitor monitor) throws Exception, CancelledException {
        MemoryByteProvider provider = new MemoryByteProvider(this.currentProgram.getMemory(), this.currentProgram.getAddressFactory().getDefaultAddressSpace());
        if (!CoffArchiveHeader.isMatch(provider)) {
            return false;
        }
        CoffArchiveHeader header = CoffArchiveHeader.read(provider, monitor);
        this.applyDataTypes(provider, header);
        this.removeEmptyFragments();
        return true;
    }

    @Override
    public String getWorkerName() {
        return this.getName();
    }

    @Override
    public boolean applyTo(Program program, TaskMonitor monitor) throws Exception {
        this.set(program, monitor);
        AutoAnalysisManager aam = AutoAnalysisManager.getAnalysisManager(this.currentProgram);
        return aam.scheduleWorker(this, null, false, monitor);
    }

    @Override
    public boolean canApply(Program program) {
        try {
            Memory memory = program.getMemory();
            byte[] magicBytes = new byte[CoffArchiveConstants.MAGIC_LEN];
            memory.getBytes(program.getAddressFactory().getDefaultAddressSpace().getAddress(0L), magicBytes);
            String magic = new String(magicBytes);
            return "!<arch>\n".equals(magic);
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public MessageLog getMessages() {
        return this.messages;
    }

    @Override
    public String getName() {
        return "COFF Archive Header Annotation";
    }

    private void removeEmptyFragments() throws NotEmptyException {
        String[] treeNames;
        this.monitor.setMessage("Removing empty fragments...");
        block0: for (String treeName : treeNames = this.currentProgram.getListing().getTreeNames()) {
            Group[] children;
            if (this.monitor.isCancelled()) break;
            ProgramModule rootModule = this.currentProgram.getListing().getRootModule(treeName);
            for (Group child : children = rootModule.getChildren()) {
                ProgramFragment fragment;
                if (this.monitor.isCancelled()) continue block0;
                if (!(child instanceof ProgramFragment) || !(fragment = (ProgramFragment)child).isEmpty()) continue;
                rootModule.removeChild(fragment.getName());
            }
        }
    }

    private void applyDataTypes(ByteProvider provider, CoffArchiveHeader header) throws Exception {
        this.markupArchiveHeader(header);
        this.markupArchiveMemberHeader(provider, header);
        this.markupFirstLinkerMember(header);
        this.markupSecondLinkerMember(header);
        this.markupLongNamesMember(header);
    }

    private void markupLongNamesMember(CoffArchiveHeader header) throws Exception {
        LongNamesMember longNamesMember = header.getLongNameMember();
        if (longNamesMember == null) {
            return;
        }
        DataType dt = longNamesMember.toDataType();
        Address start = this.toAddr(longNamesMember.getFileOffset());
        this.createData(start, dt);
        this.createFragment(dt.getName(), start, dt.getLength());
    }

    private void markupSecondLinkerMember(CoffArchiveHeader header) throws Exception {
        SecondLinkerMember secondLinkerMember = header.getSecondLinkerMember();
        if (secondLinkerMember == null) {
            return;
        }
        DataType dt = secondLinkerMember.toDataType();
        Address start = this.toAddr(secondLinkerMember.getFileOffset());
        this.createData(start, dt);
        this.createFragment(dt.getName(), start, dt.getLength());
    }

    private void markupFirstLinkerMember(CoffArchiveHeader header) throws Exception {
        FirstLinkerMember firstLinkerMember = header.getFirstLinkerMember();
        if (firstLinkerMember == null) {
            return;
        }
        DataType dt = firstLinkerMember.toDataType();
        Address start = this.toAddr(firstLinkerMember.getFileOffset());
        this.createData(start, dt);
        this.createFragment(dt.getName(), start, dt.getLength());
    }

    private void markupArchiveMemberHeader(ByteProvider provider, CoffArchiveHeader header) throws Exception {
        for (CoffArchiveMemberHeader archiveMemberHeader : header.getArchiveMemberHeaders()) {
            if (this.monitor.isCancelled()) break;
            DataType dt = archiveMemberHeader.toDataType();
            Address start = this.toAddr(archiveMemberHeader.getFileOffset());
            Address end = start.add((long)dt.getLength());
            this.createData(start, dt);
            this.createFragment("ArchiveMemberHeader", start, dt.getLength());
            if (!archiveMemberHeader.isCOFF()) continue;
            String name = SymbolUtilities.replaceInvalidChars((String)archiveMemberHeader.getName(), (boolean)true);
            Address payloadAddress = end;
            this.createFragment(name, payloadAddress, archiveMemberHeader.getSize());
            this.createLabel(payloadAddress, name, true);
        }
    }

    private void markupArchiveHeader(CoffArchiveHeader header) throws Exception {
        DataType dt = header.toDataType();
        this.createData(this.toAddr(0), dt);
        this.createFragment("ArchiveHeader", this.toAddr(0), dt.getLength());
    }
}

