/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.rich;

import ghidra.docking.settings.Settings;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeImpl;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.mem.MemBuffer;
import ghidra.util.InvalidNameException;
import ghidra.util.exception.DuplicateNameException;

class RichObjectCountDataType
extends DataTypeImpl {
    private final int count;

    public RichObjectCountDataType(int count) {
        this(count, null);
    }

    public RichObjectCountDataType(int count, DataTypeManager dtm) {
        super(new CategoryPath("/PE"), "RichObjectCount", dtm);
        this.count = count;
    }

    public boolean isDynamicallySized() {
        return false;
    }

    public DataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new RichObjectCountDataType(this.count, dtm);
    }

    public DataType copy(DataTypeManager dtm) {
        return this.clone(dtm);
    }

    public void setCategoryPath(CategoryPath path) throws DuplicateNameException {
    }

    public void setName(String name) throws InvalidNameException {
    }

    public void setNameAndCategory(CategoryPath path, String name) throws InvalidNameException, DuplicateNameException {
    }

    public String getMnemonic(Settings settings) {
        return "xorddw";
    }

    public int getLength() {
        return 4;
    }

    public String getDescription() {
        return null;
    }

    public Object getValue(MemBuffer buf, Settings settings, int length) {
        return this.count;
    }

    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        return "" + this.count;
    }

    public boolean isEquivalent(DataType dt) {
        if (dt == this) {
            return true;
        }
        if (dt == null) {
            return false;
        }
        return ((Object)((Object)this)).getClass() == dt.getClass();
    }

    public void dataTypeSizeChanged(DataType dt) {
    }

    public void dataTypeDeleted(DataType dt) {
    }

    public void dataTypeReplaced(DataType oldDt, DataType newDt) {
    }

    public void dataTypeNameChanged(DataType dt, String oldName) {
    }

    public boolean dependsOn(DataType dt) {
        return false;
    }
}

