/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.xml;

import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.LanguageID;

public class ProgramInfo {
    public String family;
    public String processorName;
    public LanguageID languageID;
    public CompilerSpecID compilerSpecID;
    public String programName;
    public String timestamp;
    public String user;
    private String tool;
    private String normalizedExternalToolName;
    public String version;
    public String addressModel;
    public String endian;
    public String exePath;
    public String exeFormat;
    public String imageBase;

    public String toString() {
        return "processor=" + this.processorName + "\nfamily=" + this.family + "\ncompiler=" + this.compilerSpecID + "\naddress model=" + this.addressModel + "\nendian=" + this.endian + "\nprogram=" + this.programName;
    }

    public boolean shouldProcessStack() {
        return true;
    }

    boolean isIdaPro() {
        return "IDA-PRO".equalsIgnoreCase(this.normalizedExternalToolName);
    }

    boolean isGhidra() {
        return "GHIDRA".equalsIgnoreCase(this.normalizedExternalToolName);
    }

    private String translateCompiler(String compiler) {
        if (this.isIdaPro()) {
            return this.translateIDACompilerName(compiler);
        }
        return compiler;
    }

    public void setCompilerSpecID(String compiler) {
        this.compilerSpecID = null;
        if (compiler != null) {
            CompilerSpecID cspec;
            String translated = this.translateCompiler(compiler);
            this.compilerSpecID = cspec = new CompilerSpecID(translated);
        }
    }

    private String translateIDACompilerName(String compiler) {
        if ("Visual C++".equals(compiler)) {
            return "windows";
        }
        return compiler;
    }

    public String getTool() {
        return this.tool;
    }

    public void setTool(String tool) {
        this.tool = tool;
        this.normalizedExternalToolName = tool;
        if (this.tool != null && this.tool.toUpperCase().startsWith("IDA-PRO")) {
            this.normalizedExternalToolName = "IDA-PRO";
        } else if (this.tool != null && this.tool.toUpperCase().startsWith("GHIDRA")) {
            this.normalizedExternalToolName = null;
        }
    }

    public String getNormalizedExternalToolName() {
        return this.normalizedExternalToolName;
    }
}

