/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.config;

import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.config.ISMLockingConfig;
import org.apache.jackrabbit.core.config.PersistenceManagerConfig;
import org.apache.jackrabbit.core.config.SearchConfig;
import org.apache.jackrabbit.core.config.WorkspaceSecurityConfig;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemFactory;

public class WorkspaceConfig
implements FileSystemFactory {
    private final String home;
    private final String name;
    private final boolean clustered;
    private FileSystemFactory fsf;
    private PersistenceManagerConfig pmc;
    private SearchConfig sc;
    private ISMLockingConfig ismLockingConfig;
    private final WorkspaceSecurityConfig workspaceSecurityConfig;

    public WorkspaceConfig(String home, String name, boolean clustered, FileSystemFactory fsf, PersistenceManagerConfig pmc, SearchConfig sc, ISMLockingConfig ismLockingConfig, WorkspaceSecurityConfig workspaceSecurityConfig) {
        this.home = home;
        this.name = name;
        this.clustered = clustered;
        this.fsf = fsf;
        this.pmc = pmc;
        this.sc = sc;
        this.ismLockingConfig = ismLockingConfig != null ? ismLockingConfig : ISMLockingConfig.createDefaultConfig();
        this.workspaceSecurityConfig = workspaceSecurityConfig;
    }

    public String getHomeDir() {
        return this.home;
    }

    public String getName() {
        return this.name;
    }

    public boolean isClustered() {
        return this.clustered;
    }

    public ISMLockingConfig getISMLockingConfig() {
        return this.ismLockingConfig;
    }

    public FileSystem getFileSystem() throws RepositoryException {
        return this.fsf.getFileSystem();
    }

    public PersistenceManagerConfig getPersistenceManagerConfig() {
        return this.pmc;
    }

    public SearchConfig getSearchConfig() {
        return this.sc;
    }

    public WorkspaceSecurityConfig getSecurityConfig() {
        return this.workspaceSecurityConfig;
    }
}

