/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.DBFileListener;
import db.DBHandle;
import db.buffers.BufferFileManager;
import db.buffers.LocalManagedBufferFile;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Database {
    static final Logger log = LogManager.getLogger(Database.class);
    protected static final String DATABASE_FILE_PREFIX = "db.";
    protected static final String VERSION_FILE_PREFIX = "ver.";
    protected static final String CHANGE_FILE_PREFIX = "change.";
    protected static final String CUMULATIVE_CHANGE_FILENAME = "change.data.gbf";
    protected static final String CUMULATIVE_MODMAP_FILENAME = "change.map.gbf";
    protected int minVersion;
    protected int currentVersion;
    protected long lastModified;
    protected boolean isVersioned = false;
    protected boolean isCheckOutCopy = false;
    protected boolean updateAllowed = true;
    protected BufferFileManager bfMgr;
    protected File dbDir;
    protected DBFileListener dbFileListener;
    protected boolean dbDirCreated = false;
    protected Object syncObject = this;

    protected Database(File dbDir, boolean isVersioned, boolean create) throws IOException {
        this.dbDir = dbDir;
        this.isVersioned = isVersioned;
        if (create && !dbDir.exists()) {
            if (!dbDir.mkdirs()) {
                throw new IOException("Failed to create Database directory: " + dbDir);
            }
            this.dbDirCreated = true;
        } else {
            this.checkDbDir();
        }
    }

    protected Database(File dbDir, DBFileListener dbFileListener, boolean create) throws IOException {
        this(dbDir, false, create);
        this.bfMgr = new DBBufferFileManager();
        this.dbFileListener = dbFileListener;
        this.scanFiles(false);
        if (create && this.currentVersion != 0) {
            throw new IOException("Database already exists");
        }
    }

    protected Database(File dbDir) throws IOException {
        this(dbDir, false, false);
        this.bfMgr = new DBBufferFileManager();
        this.scanFiles(false);
    }

    public void setSynchronizationObject(Object syncObject) {
        this.syncObject = syncObject;
    }

    public long lastModified() {
        return this.lastModified;
    }

    protected static final boolean deleteDir(File dir) {
        File[] flist = dir.listFiles();
        if (flist == null) {
            return false;
        }
        for (int i = 0; i < flist.length; ++i) {
            if (!(flist[i].isDirectory() ? !Database.deleteDir(flist[i]) : !flist[i].delete())) continue;
            return false;
        }
        return dir.delete();
    }

    public int getCurrentVersion() {
        return this.currentVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBHandle open(TaskMonitor monitor) throws IOException, CancelledException {
        Object object = this.syncObject;
        synchronized (object) {
            return new DBHandle(new LocalManagedBufferFile(this.bfMgr, false, -1, -1L));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBHandle openForUpdate(TaskMonitor monitor) throws IOException, CancelledException {
        if (!this.updateAllowed) {
            throw new IOException("Update use not permitted");
        }
        Object object = this.syncObject;
        synchronized (object) {
            return new DBHandle(new LocalManagedBufferFile(this.bfMgr, true, -1, -1L));
        }
    }

    public long length() throws IOException {
        return this.bfMgr.getBufferFile(this.getCurrentVersion()).length();
    }

    private void checkDbDir() throws IOException {
        String[] fileList = this.dbDir.list();
        if (fileList == null) {
            throw new IOException("Database directory not found: " + this.dbDir);
        }
        boolean versionFileFound = false;
        for (int i = 0; i < fileList.length; ++i) {
            String fname = fileList[i];
            if (!fname.endsWith(".gbf") || fname.startsWith(DATABASE_FILE_PREFIX)) continue;
            if (fname.equals(CUMULATIVE_CHANGE_FILENAME)) {
                this.isCheckOutCopy = true;
                continue;
            }
            if (!fname.startsWith(VERSION_FILE_PREFIX)) continue;
            versionFileFound = true;
        }
        if (!this.isVersioned && versionFileFound) {
            this.updateAllowed = false;
        }
        if (this.isVersioned && this.isCheckOutCopy) {
            throw new IOException("Versioned Database also appears to be a checkout copy");
        }
    }

    public void refresh() throws FileNotFoundException {
        this.scanFiles(false);
        if (this.currentVersion == 0) {
            throw new FileNotFoundException("Database files not found");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scanFiles(boolean repair) throws FileNotFoundException {
        Object object = this.syncObject;
        synchronized (object) {
            ArrayList<String> bufFiles = new ArrayList<String>();
            ArrayList<String> verFiles = new ArrayList<String>();
            ArrayList<String> changeFiles = new ArrayList<String>();
            String[] fileList = this.dbDir.list();
            if (fileList == null) {
                throw new FileNotFoundException(this.dbDir + " not found");
            }
            for (int i = 0; i < fileList.length; ++i) {
                String fname = fileList[i];
                if (!fname.endsWith(".gbf")) continue;
                if (fname.startsWith(DATABASE_FILE_PREFIX)) {
                    bufFiles.add(fname);
                    continue;
                }
                if (fname.startsWith(VERSION_FILE_PREFIX)) {
                    verFiles.add(fname);
                    continue;
                }
                if (!fname.startsWith(CHANGE_FILE_PREFIX)) continue;
                changeFiles.add(fname);
            }
            int[] bufVersions = this.getFileVersions(bufFiles);
            this.minVersion = this.currentVersion = bufVersions.length == 0 ? 0 : bufVersions[bufVersions.length - 1];
            this.lastModified = this.bfMgr.getBufferFile(this.currentVersion).lastModified();
            if (repair) {
                for (int i = 0; i < bufVersions.length - 1; ++i) {
                    this.bfMgr.getBufferFile(bufVersions[i]).delete();
                }
            }
            if (this.isVersioned) {
                int i;
                int[] versions = this.getFileVersions(verFiles);
                boolean filesOrphaned = false;
                for (int i2 = versions.length - 1; i2 >= 0; --i2) {
                    if (versions[i2] >= this.minVersion) {
                        if (!repair) continue;
                        File f = this.bfMgr.getVersionFile(versions[i2]);
                        log.warn(this.dbDir + ": removing unexpected version file: " + f);
                        f.delete();
                        continue;
                    }
                    if (versions[i2] == this.minVersion - 1) {
                        --this.minVersion;
                        continue;
                    }
                    log.warn(this.dbDir + ": missing version file " + (this.minVersion - 1));
                    filesOrphaned = true;
                    break;
                }
                int[] changes = this.getFileVersions(changeFiles);
                int minChangeVer = this.currentVersion;
                for (i = changes.length - 1; i >= 0; --i) {
                    if (changes[i] >= minChangeVer) {
                        if (!repair) continue;
                        File f = this.bfMgr.getChangeDataFile(changes[i]);
                        log.warn(this.dbDir + ": removing unexpected change file: " + f);
                        f.delete();
                        continue;
                    }
                    if (changes[i] == minChangeVer - 1) {
                        --minChangeVer;
                        continue;
                    }
                    log.warn(this.dbDir + ": missing change file " + (this.minVersion - 1));
                    filesOrphaned = true;
                    break;
                }
                if (minChangeVer > this.minVersion) {
                    log.warn(this.dbDir + ": missing change files prior to " + minChangeVer);
                    this.minVersion = minChangeVer;
                    filesOrphaned = true;
                }
                if (repair && filesOrphaned) {
                    log.warn(this.dbDir + ": versions prior to " + this.minVersion + " have been orphaned and will be removed");
                    for (i = 0; i < versions.length && versions[i] < this.minVersion; ++i) {
                        this.bfMgr.getVersionFile(versions[i]).delete();
                    }
                    for (i = 0; i < changes.length && changes[i] < this.minVersion; ++i) {
                        this.bfMgr.getChangeDataFile(changes[i]).delete();
                    }
                }
            }
        }
    }

    private int[] getFileVersions(ArrayList<String> fileList) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (String fname : fileList) {
            int ix1 = fname.indexOf(46);
            int ix2 = fname.indexOf(46, ix1 + 1);
            if (ix1 < 0 || ix2 < ix1) {
                log.error(this.dbDir + ": bad file name: " + fname);
                continue;
            }
            String v = fname.substring(ix1 + 1, ix2);
            try {
                list.add(new Integer(v));
            }
            catch (NumberFormatException e) {
                log.error(this.dbDir + ": bad file name: " + fname);
            }
        }
        int[] versions = new int[list.size()];
        Iterator versionsIter = list.iterator();
        int ix = 0;
        while (versionsIter.hasNext()) {
            versions[ix++] = (Integer)versionsIter.next();
        }
        Arrays.sort(versions);
        return versions;
    }

    protected class DBBufferFileManager
    implements BufferFileManager {
        protected DBBufferFileManager() {
        }

        @Override
        public int getCurrentVersion() {
            return Database.this.currentVersion;
        }

        @Override
        public File getBufferFile(int version) {
            return new File(Database.this.dbDir, Database.DATABASE_FILE_PREFIX + version + ".gbf");
        }

        @Override
        public File getVersionFile(int version) {
            return null;
        }

        @Override
        public File getChangeMapFile() {
            if (Database.this.isCheckOutCopy) {
                return new File(Database.this.dbDir, Database.CUMULATIVE_MODMAP_FILENAME);
            }
            return null;
        }

        @Override
        public File getChangeDataFile(int version) {
            if (Database.this.isCheckOutCopy) {
                return new File(Database.this.dbDir, Database.CUMULATIVE_CHANGE_FILENAME);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void versionCreated(int version, String comment, long checkinId) throws FileNotFoundException {
            Object object = Database.this.syncObject;
            synchronized (object) {
                if (Database.this.currentVersion != version - 1) {
                    log.error(Database.this.dbDir + ": unexpected version created (" + version + "), expected version " + (Database.this.currentVersion + 1));
                    if (version > Database.this.currentVersion || version < Database.this.minVersion) {
                        this.getBufferFile(version).delete();
                    }
                    return;
                }
                Database.this.scanFiles(true);
                if (Database.this.currentVersion == 0) {
                    throw new FileNotFoundException("Database files not found");
                }
                if (version != Database.this.currentVersion) {
                    log.error(Database.this.dbDir + ": Unexpected version found (" + Database.this.currentVersion + "), expected " + version);
                } else if (Database.this.dbFileListener != null) {
                    Database.this.dbFileListener.versionCreated(Database.this, version);
                }
            }
        }

        @Override
        public void updateEnded(long checkinId) {
        }
    }
}

