/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib;

import org.jf.dexlib.Convertible;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Item;
import org.jf.dexlib.ItemType;
import org.jf.dexlib.ProtoIdItem;
import org.jf.dexlib.ReadContext;
import org.jf.dexlib.StringIdItem;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.Input;

public class MethodIdItem
extends Item<MethodIdItem>
implements Convertible<MethodIdItem> {
    private int hashCode = 0;
    private TypeIdItem classType;
    private ProtoIdItem methodPrototype;
    private StringIdItem methodName;
    private String cachedMethodString = null;
    private String cachedShortMethodString = null;

    protected MethodIdItem(DexFile dexFile) {
        super(dexFile);
    }

    private MethodIdItem(DexFile dexFile, TypeIdItem classType, ProtoIdItem methodPrototype, StringIdItem methodName) {
        this(dexFile);
        this.classType = classType;
        this.methodPrototype = methodPrototype;
        this.methodName = methodName;
    }

    public static MethodIdItem internMethodIdItem(DexFile dexFile, TypeIdItem classType, ProtoIdItem methodPrototype, StringIdItem methodName) {
        MethodIdItem methodIdItem = new MethodIdItem(dexFile, classType, methodPrototype, methodName);
        return dexFile.MethodIdsSection.intern(methodIdItem);
    }

    public static MethodIdItem lookupMethodIdItem(DexFile dexFile, TypeIdItem classType, ProtoIdItem methodPrototype, StringIdItem methodName) {
        MethodIdItem methodIdItem = new MethodIdItem(dexFile, classType, methodPrototype, methodName);
        return dexFile.MethodIdsSection.getInternedItem(methodIdItem);
    }

    @Override
    protected void readItem(Input in, ReadContext readContext) {
        this.classType = this.dexFile.TypeIdsSection.getItemByIndex(in.readShort());
        this.methodPrototype = this.dexFile.ProtoIdsSection.getItemByIndex(in.readShort());
        this.methodName = this.dexFile.StringIdsSection.getItemByIndex(in.readInt());
    }

    @Override
    protected int placeItem(int offset) {
        return offset + 8;
    }

    @Override
    protected void writeItem(AnnotatedOutput out) {
        int classIndex;
        if (out.annotates()) {
            out.annotate(2, "class_type: " + this.classType.getTypeDescriptor());
            out.annotate(2, "method_prototype: " + this.methodPrototype.getPrototypeString());
            out.annotate(4, "method_name: " + this.methodName.getStringValue());
        }
        if ((classIndex = this.classType.getIndex()) > 65535) {
            throw new RuntimeException(String.format("Error writing method_id_item for %s. The type index of defining class %s is too large", this.getMethodString(), this.classType.getTypeDescriptor()));
        }
        out.writeShort(classIndex);
        int prototypeIndex = this.methodPrototype.getIndex();
        if (prototypeIndex > 65535) {
            throw new RuntimeException(String.format("Error writing method_id_item for %0. The prototype index of method prototype %s is too large", this.getMethodString(), this.methodPrototype.getPrototypeString()));
        }
        out.writeShort(prototypeIndex);
        out.writeInt(this.methodName.getIndex());
    }

    @Override
    public ItemType getItemType() {
        return ItemType.TYPE_METHOD_ID_ITEM;
    }

    @Override
    public String getConciseIdentity() {
        return "method_id_item: " + this.getMethodString();
    }

    @Override
    public int compareTo(MethodIdItem o) {
        int result = this.classType.compareTo(o.classType);
        if (result != 0) {
            return result;
        }
        result = this.methodName.compareTo(o.methodName);
        if (result != 0) {
            return result;
        }
        return this.methodPrototype.compareTo(o.methodPrototype);
    }

    public String getMethodString() {
        if (this.cachedMethodString == null) {
            String classType = this.classType.getTypeDescriptor();
            String methodName = this.methodName.getStringValue();
            String prototypeString = this.methodPrototype.getPrototypeString();
            StringBuilder sb = new StringBuilder(classType.length() + methodName.length() + prototypeString.length() + 2);
            sb.append(classType);
            sb.append("->");
            sb.append(methodName);
            sb.append(prototypeString);
            this.cachedMethodString = sb.toString();
        }
        return this.cachedMethodString;
    }

    public String getShortMethodString() {
        if (this.cachedShortMethodString == null) {
            String methodName = this.methodName.getStringValue();
            String prototypeString = this.methodPrototype.getPrototypeString();
            StringBuilder sb = new StringBuilder(methodName.length() + prototypeString.length());
            sb.append(methodName);
            sb.append(prototypeString);
            this.cachedShortMethodString = sb.toString();
        }
        return this.cachedShortMethodString;
    }

    public ProtoIdItem getPrototype() {
        return this.methodPrototype;
    }

    public StringIdItem getMethodName() {
        return this.methodName;
    }

    public TypeIdItem getContainingClass() {
        return this.classType;
    }

    private void calcHashCode() {
        this.hashCode = this.classType.hashCode();
        this.hashCode = 31 * this.hashCode + this.methodPrototype.hashCode();
        this.hashCode = 31 * this.hashCode + this.methodName.hashCode();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.calcHashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        MethodIdItem other = (MethodIdItem)o;
        return this.classType == other.classType && this.methodPrototype == other.methodPrototype && this.methodName == other.methodName;
    }

    @Override
    public MethodIdItem convert() {
        return this;
    }
}

