/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.data.rtti;

import ghidra.app.cmd.data.AbstractCreateDataBackgroundCmd;
import ghidra.app.cmd.data.CreateTypeDescriptorBackgroundCmd;
import ghidra.app.cmd.data.EHDataTypeUtilities;
import ghidra.app.cmd.data.TypeDescriptorModel;
import ghidra.app.cmd.data.rtti.CreateRtti3BackgroundCmd;
import ghidra.app.cmd.data.rtti.CreateVfTableBackgroundCmd;
import ghidra.app.cmd.data.rtti.Rtti4Model;
import ghidra.app.cmd.data.rtti.RttiUtil;
import ghidra.app.cmd.data.rtti.VfTableModel;
import ghidra.app.util.datatype.microsoft.DataApplyOptions;
import ghidra.app.util.datatype.microsoft.DataValidationOptions;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.util.ProgramMemoryUtil;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.List;
import java.util.Set;

public class CreateRtti4BackgroundCmd
extends AbstractCreateDataBackgroundCmd<Rtti4Model> {
    private static final String RTTI_4_NAME = "RTTI Complete Object Locator";
    private List<MemoryBlock> vfTableBlocks;

    public CreateRtti4BackgroundCmd(Address address, List<MemoryBlock> vfTableBlocks, DataValidationOptions validationOptions, DataApplyOptions applyOptions) {
        super("RTTICompleteObjectLocator", address, 1, validationOptions, applyOptions);
        this.vfTableBlocks = vfTableBlocks;
    }

    @Override
    protected Rtti4Model createModel(Program program) {
        if (this.model == null || program != ((Rtti4Model)this.model).getProgram()) {
            this.model = new Rtti4Model(program, this.address, this.validationOptions);
        }
        return (Rtti4Model)this.model;
    }

    @Override
    protected boolean createAssociatedData() throws CancelledException {
        boolean createRtti3Success;
        boolean createRtti0Success;
        this.monitor.checkCanceled();
        try {
            createRtti0Success = this.createRtti0();
        }
        catch (InvalidDataTypeException e) {
            createRtti0Success = false;
            this.handleErrorMessage(((Rtti4Model)this.model).getProgram(), ((Rtti4Model)this.model).getAddress(), e.getMessage());
        }
        try {
            createRtti3Success = this.createRtti3();
        }
        catch (InvalidDataTypeException e) {
            createRtti3Success = false;
            this.handleErrorMessage(((Rtti4Model)this.model).getProgram(), ((Rtti4Model)this.model).getAddress(), e.getMessage());
        }
        boolean createVfTableSuccess = this.createVfTable();
        return createRtti0Success && createRtti3Success && createVfTableSuccess;
    }

    private boolean createRtti0() throws CancelledException, InvalidDataTypeException {
        this.monitor.checkCanceled();
        CreateTypeDescriptorBackgroundCmd cmd = new CreateTypeDescriptorBackgroundCmd(((Rtti4Model)this.model).getRtti0Model(), this.applyOptions);
        return cmd.applyTo((DomainObject)((Rtti4Model)this.model).getProgram(), this.monitor);
    }

    private boolean createRtti3() throws CancelledException, InvalidDataTypeException {
        this.monitor.checkCanceled();
        CreateRtti3BackgroundCmd cmd = new CreateRtti3BackgroundCmd(((Rtti4Model)this.model).getRtti3Model(), this.applyOptions);
        return cmd.applyTo((DomainObject)((Rtti4Model)this.model).getProgram(), this.monitor);
    }

    private boolean createVfTable() throws CancelledException {
        int defaultPointerSize;
        this.monitor.checkCanceled();
        Program program = ((Rtti4Model)this.model).getProgram();
        Address rtti4Address = this.address;
        int alignment = defaultPointerSize = program.getDefaultPointerSize();
        Set directRtti4Refs = ProgramMemoryUtil.findDirectReferences((Program)program, this.vfTableBlocks, (int)alignment, (Address)rtti4Address, (TaskMonitor)this.monitor);
        VfTableModel validVfTableModel = null;
        for (Address possibleVfMetaAddr : directRtti4Refs) {
            this.monitor.checkCanceled();
            Address possibleVfTableAddr = possibleVfMetaAddr.add((long)defaultPointerSize);
            try {
                VfTableModel vfTableModel = new VfTableModel(program, possibleVfTableAddr, this.validationOptions);
                vfTableModel.validate();
                if (validVfTableModel != null) {
                    String message = "More than one possible vfTable found for RTTICompleteObjectLocator @ " + rtti4Address;
                    this.handleErrorMessage(program, rtti4Address, message);
                    return false;
                }
                validVfTableModel = vfTableModel;
            }
            catch (InvalidDataTypeException e) {}
        }
        if (validVfTableModel == null) {
            String message = "No vfTable found for RTTICompleteObjectLocator @ " + rtti4Address;
            this.handleErrorMessage(program, rtti4Address, message);
            return false;
        }
        this.monitor.checkCanceled();
        CreateVfTableBackgroundCmd cmd = new CreateVfTableBackgroundCmd(validVfTableModel, this.applyOptions);
        return cmd.applyTo((DomainObject)program, this.monitor);
    }

    @Override
    protected boolean createMarkup() throws CancelledException, InvalidDataTypeException {
        this.monitor.checkCanceled();
        Program program = ((Rtti4Model)this.model).getProgram();
        TypeDescriptorModel rtti0Model = ((Rtti4Model)this.model).getRtti0Model();
        this.monitor.checkCanceled();
        if (rtti0Model != null) {
            EHDataTypeUtilities.createPlateCommentIfNeeded(program, "const " + RttiUtil.getDescriptorTypeNamespace(rtti0Model) + "::", RTTI_4_NAME, null, this.address, this.applyOptions);
            this.monitor.checkCanceled();
            if (this.applyOptions.shouldCreateLabel()) {
                RttiUtil.createSymbolFromDemangledType(program, this.address, rtti0Model, RTTI_4_NAME);
            }
        }
        return true;
    }
}

