/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.coff.relocation;

import ghidra.app.util.bin.format.coff.CoffFileHeader;
import ghidra.app.util.bin.format.coff.CoffRelocation;
import ghidra.app.util.bin.format.coff.relocation.CoffRelocationHandler;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.exception.NotFoundException;

public class X86_32_CoffRelocationHandler
extends CoffRelocationHandler {
    public static final short IMAGE_REL_I386_ABSOLUTE = 0;
    public static final short IMAGE_REL_I386_DIR16 = 1;
    public static final short IMAGE_REL_I386_REL16 = 2;
    public static final short IMAGE_REL_I386_DIR32 = 6;
    public static final short IMAGE_REL_I386_DIR32NB = 7;
    public static final short IMAGE_REL_I386_SEG12 = 9;
    public static final short IMAGE_REL_I386_SECTION = 10;
    public static final short IMAGE_REL_I386_SECREL = 11;
    public static final short IMAGE_REL_I386_TOKEN = 12;
    public static final short IMAGE_REL_I386_SECREL7 = 13;
    public static final short IMAGE_REL_I386_REL32 = 20;

    public boolean canRelocate(CoffFileHeader fileHeader) {
        return fileHeader.getMachine() == 332;
    }

    public void relocate(Program program, Address address, Symbol symbol, CoffRelocation relocation) throws MemoryAccessException, NotFoundException {
        int addend = program.getMemory().getInt(address);
        switch (relocation.getType()) {
            case 6: {
                program.getMemory().setInt(address, (int)symbol.getAddress().add((long)addend).getOffset());
                break;
            }
            case 7: {
                program.getMemory().setInt(address, (int)symbol.getAddress().add((long)addend).subtract(program.getImageBase()));
                break;
            }
            case 20: {
                program.getMemory().setInt(address, (int)symbol.getAddress().add((long)addend).subtract(address) - 4);
                break;
            }
            case 0: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            default: {
                throw new NotFoundException();
            }
        }
    }
}

