/*
 * Decompiled with CFR 0.152.
 */
package docking.wizard;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class WizardState<T>
implements Cloneable {
    private Map<T, Object> map = new HashMap<T, Object>();
    private Map<T, Set<T>> dependentMap = new HashMap<T, Set<T>>();

    protected Object clone() {
        WizardState<T> anakin = new WizardState<T>();
        anakin.map = new HashMap<T, Object>(this.map);
        Set<Map.Entry<T, Set<T>>> entrySet = this.dependentMap.entrySet();
        for (Map.Entry<T, Set<T>> entry : entrySet) {
            T key = entry.getKey();
            Set<T> value = entry.getValue();
            anakin.dependentMap.put(key, new HashSet<T>(value));
        }
        return anakin;
    }

    public Object get(T key) {
        return this.map.get(key);
    }

    public void put(T key, Object value) {
        if (this.map.containsKey(key)) {
            Object oldValue = this.map.get(key);
            if (oldValue == value) {
                return;
            }
            if (oldValue != null && oldValue.equals(value)) {
                return;
            }
        }
        this.map.put(key, value);
        this.clearDependents(key);
    }

    public void clear(T key) {
        Object removedValue = this.map.remove(key);
        if (removedValue != null) {
            this.clearDependents(key);
        }
    }

    public void addDependency(T dependent, T predecessor) {
        Set<T> dependents = this.dependentMap.get(predecessor);
        if (dependents == null) {
            dependents = new HashSet<T>();
            this.dependentMap.put(predecessor, dependents);
        }
        dependents.add(dependent);
    }

    private void clearDependents(T key) {
        Set<T> dependencies = this.dependentMap.get(key);
        if (dependencies != null) {
            for (T dependent : dependencies) {
                this.clear(dependent);
            }
        }
    }
}

