/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.app.plugin.core.datamgr.archive.SourceArchive;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataTypeImpl;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataUtilities;
import ghidra.util.InvalidNameException;
import ghidra.util.UniversalID;
import ghidra.util.exception.DuplicateNameException;

public abstract class GenericDataType
extends DataTypeImpl {
    protected boolean packed = false;

    protected GenericDataType(CategoryPath path, String name, DataTypeManager dataMgr) {
        super(path, name, dataMgr);
        if (!DataUtilities.isValidDataTypeName(name)) {
            throw new IllegalArgumentException("Invalid DataType name: " + name);
        }
    }

    protected GenericDataType(CategoryPath path, String name, UniversalID universalID, SourceArchive sourceArchive, long lastChangeTime, long lastChangeTimeInSourceArchive, DataTypeManager dataMgr) {
        super(path, name, universalID, sourceArchive, lastChangeTime, lastChangeTimeInSourceArchive, dataMgr);
        if (!DataUtilities.isValidDataTypeName(name)) {
            throw new IllegalArgumentException("Invalid DataType name: " + name);
        }
    }

    @Override
    public void setNameAndCategory(CategoryPath path, String name) throws InvalidNameException, DuplicateNameException {
        this.doSetName(name);
        this.doSetCategoryPath(path);
    }

    @Override
    public void setName(String name) throws InvalidNameException {
        this.doSetName(name);
    }

    private void doSetName(String newName) throws InvalidNameException {
        if (this.name.equals(newName)) {
            return;
        }
        this.checkValidName(newName);
        String oldName = this.name;
        this.name = newName;
        this.notifyNameChanged(oldName);
    }

    @Override
    public void setCategoryPath(CategoryPath path) {
        this.doSetCategoryPath(path);
    }

    private void doSetCategoryPath(CategoryPath path) {
        if (path == null) {
            path = CategoryPath.ROOT;
        }
        this.categoryPath = path;
    }
}

