/* ###
 * IP: GHIDRA
 * REVIEWED: YES
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Created on Jun 12, 2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package ghidra.app.decompiler;

import ghidra.program.model.data.*;
import ghidra.program.model.pcode.*;
import ghidra.xml.*;
/**
 * 
 *
 * A C code token representing a data type. This does not include qualifiers on the type
 * like '*' (pointer to) or '[]' (array of). There should be no whitespace in the name
 */
public class ClangTypeToken extends ClangToken {
	private DataType datatype;

	public ClangTypeToken(ClangNode par) {
		super(par);
		datatype = null;
	}
	
	@Override
    public boolean isVariableRef() {
		if (Parent() instanceof ClangVariableDecl) return true;
		return false;	
	}
	
	public DataType getDataType() {
		return datatype;
	}
	
	@Override
    public void restoreFromXML(XmlElement el,XmlElement end,PcodeFactory pfactory) {
		super.restoreFromXML(el,end,pfactory);
		datatype = pfactory.getDataTypeManager().findBaseType(getText(),el.getAttribute("id"));
	}
}
