/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsConditional;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt;
import org.jetbrains.kotlin.js.patterns.NamePredicate;
import org.jetbrains.kotlin.js.patterns.typePredicates.TypePredicatesKt;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TemporaryVariable;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.ArrayFIF;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.TopLevelFIF;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.checkers.PrimitiveNumericComparisonInfo;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;

public final class PatternTranslator
extends AbstractTranslator {
    @NotNull
    public static PatternTranslator newInstance(@NotNull TranslationContext context2) {
        if (context2 == null) {
            PatternTranslator.$$$reportNull$$$1(0);
        }
        if (context2 == null) {
            PatternTranslator.$$$reportNull$$$0(0);
        }
        return new PatternTranslator(context2);
    }

    private PatternTranslator(@NotNull TranslationContext context2) {
        if (context2 == null) {
            PatternTranslator.$$$reportNull$$$1(1);
        }
        if (context2 == null) {
            PatternTranslator.$$$reportNull$$$0(1);
        }
        super(context2);
    }

    public static boolean isCastExpression(@NotNull KtBinaryExpressionWithTypeRHS expression2) {
        if (expression2 == null) {
            PatternTranslator.$$$reportNull$$$1(2);
        }
        if (expression2 == null) {
            PatternTranslator.$$$reportNull$$$0(2);
        }
        return KtPsiUtil.isSafeCast(expression2) || KtPsiUtil.isUnsafeCast(expression2);
    }

    @NotNull
    public JsExpression translateCastExpression(@NotNull KtBinaryExpressionWithTypeRHS expression2) {
        JsExpression onFail;
        if (expression2 == null) {
            PatternTranslator.$$$reportNull$$$1(3);
        }
        if (expression2 == null) {
            PatternTranslator.$$$reportNull$$$0(3);
        }
        assert (PatternTranslator.isCastExpression(expression2)) : "Expected cast expression, got " + expression2;
        KtExpression left = expression2.getLeft();
        JsExpression expressionToCast = Translation.translateAsExpression(left, this.context());
        KtTypeReference typeReference = expression2.getRight();
        assert (typeReference != null) : "Cast expression must have type reference";
        SimpleType anyType = this.context().getCurrentModule().getBuiltIns().getAnyType();
        expressionToCast = TranslationUtils.coerce(this.context(), expressionToCast, anyType);
        TemporaryVariable temporary = this.context().declareTemporary(expressionToCast, expression2);
        JsExpression isCheck = this.translateIsCheck(temporary.assignmentExpression(), typeReference);
        if (isCheck == null) {
            JsExpression jsExpression = expressionToCast;
            if (jsExpression == null) {
                PatternTranslator.$$$reportNull$$$0(4);
            }
            if (jsExpression == null) {
                PatternTranslator.$$$reportNull$$$1(4);
            }
            return jsExpression;
        }
        if (KtPsiUtil.isSafeCast(expression2)) {
            onFail = new JsNullLiteral();
        } else {
            JsExpression throwCCEFunRef = this.context().getReferenceToIntrinsic("throwCCE");
            onFail = new JsInvocation(throwCCEFunRef, new JsExpression[0]);
        }
        JsConditional result2 = new JsConditional(isCheck, temporary.reference(), onFail);
        KotlinType targetType = BindingUtils.getTypeByReference(this.bindingContext(), typeReference);
        if (KtPsiUtil.isSafeCast(expression2)) {
            targetType = targetType.unwrap().makeNullableAsSpecified(true);
        }
        JsExpression jsExpression = TranslationUtils.coerce(this.context(), result2, targetType);
        if (jsExpression == null) {
            PatternTranslator.$$$reportNull$$$0(5);
        }
        if (jsExpression == null) {
            PatternTranslator.$$$reportNull$$$1(5);
        }
        return jsExpression;
    }

    @NotNull
    public JsExpression translateIsExpression(@NotNull KtIsExpression expression2) {
        if (expression2 == null) {
            PatternTranslator.$$$reportNull$$$1(6);
        }
        if (expression2 == null) {
            PatternTranslator.$$$reportNull$$$0(6);
        }
        KtExpression left = expression2.getLeftHandSide();
        JsExpression expressionToCheck = Translation.translateAsExpression(left, this.context());
        SimpleType anyType = this.context().getCurrentModule().getBuiltIns().getAnyType();
        expressionToCheck = TranslationUtils.coerce(this.context(), expressionToCheck, anyType);
        KtTypeReference typeReference = expression2.getTypeReference();
        assert (typeReference != null);
        JsExpression result2 = this.translateIsCheck(expressionToCheck, typeReference);
        if (result2 == null) {
            return new JsBooleanLiteral(!expression2.isNegated());
        }
        if (expression2.isNegated()) {
            JsPrefixOperation jsPrefixOperation = JsAstUtils.not(result2);
            if (jsPrefixOperation == null) {
                PatternTranslator.$$$reportNull$$$0(7);
            }
            if (jsPrefixOperation == null) {
                PatternTranslator.$$$reportNull$$$1(7);
            }
            return jsPrefixOperation;
        }
        JsExpression jsExpression = result2;
        if (jsExpression == null) {
            PatternTranslator.$$$reportNull$$$0(8);
        }
        if (jsExpression == null) {
            PatternTranslator.$$$reportNull$$$1(8);
        }
        return jsExpression;
    }

    @Nullable
    public JsExpression translateIsCheck(@NotNull JsExpression subject, @NotNull KtTypeReference targetTypeReference) {
        KotlinType targetType;
        JsExpression checkFunReference;
        if (subject == null) {
            PatternTranslator.$$$reportNull$$$1(9);
        }
        if (targetTypeReference == null) {
            PatternTranslator.$$$reportNull$$$1(10);
        }
        if (subject == null) {
            PatternTranslator.$$$reportNull$$$0(9);
        }
        if (targetTypeReference == null) {
            PatternTranslator.$$$reportNull$$$0(10);
        }
        if ((checkFunReference = this.doGetIsTypeCheckCallable(targetType = BindingUtils.getTypeByReference(this.bindingContext(), targetTypeReference))) == null) {
            return null;
        }
        boolean isReifiedType = TypeUtils.isReifiedTypeParameter(targetType);
        if (!isReifiedType && TypeUtils.isNullableType(targetType) || isReifiedType && KtPsiUtil.findChildByType(targetTypeReference, KtNodeTypes.NULLABLE_TYPE) != null) {
            checkFunReference = this.namer().orNull(checkFunReference);
        }
        return new JsInvocation(checkFunReference, subject);
    }

    @NotNull
    public JsExpression getIsTypeCheckCallable(@NotNull KotlinType type2) {
        if (type2 == null) {
            PatternTranslator.$$$reportNull$$$1(11);
        }
        if (type2 == null) {
            PatternTranslator.$$$reportNull$$$0(11);
        }
        JsExpression callable = this.doGetIsTypeCheckCallable(type2);
        assert (callable != null) : "This method should be called only to translate reified type parameters. `callable` should never be null for reified type parameters. Actual type: " + type2;
        if (!TypeUtils.isReifiedTypeParameter(type2) && TypeUtils.isNullableType(type2)) {
            JsExpression jsExpression = this.namer().orNull(callable);
            if (jsExpression == null) {
                PatternTranslator.$$$reportNull$$$0(12);
            }
            if (jsExpression == null) {
                PatternTranslator.$$$reportNull$$$1(12);
            }
            return jsExpression;
        }
        JsExpression jsExpression = callable;
        if (jsExpression == null) {
            PatternTranslator.$$$reportNull$$$0(13);
        }
        if (jsExpression == null) {
            PatternTranslator.$$$reportNull$$$1(13);
        }
        return jsExpression;
    }

    @Nullable
    private JsExpression doGetIsTypeCheckCallable(@NotNull KotlinType type2) {
        ClassifierDescriptor targetDescriptor;
        if (type2 == null) {
            PatternTranslator.$$$reportNull$$$1(14);
        }
        if (type2 == null) {
            PatternTranslator.$$$reportNull$$$0(14);
        }
        if ((targetDescriptor = type2.getConstructor().getDeclarationDescriptor()) != null && AnnotationsUtils.isNativeInterface(targetDescriptor)) {
            return type2.isMarkedNullable() ? null : this.namer().isInstanceOf(JsAstUtils.pureFqn("Object", null));
        }
        JsExpression builtinCheck = this.getIsTypeCheckCallableForBuiltin(type2);
        if (builtinCheck != null) {
            return builtinCheck;
        }
        builtinCheck = this.getIsTypeCheckCallableForPrimitiveBuiltin(type2);
        if (builtinCheck != null) {
            return builtinCheck;
        }
        TypeParameterDescriptor typeParameterDescriptor = TypeUtils.getTypeParameterDescriptorOrNull(type2);
        if (typeParameterDescriptor != null) {
            if (typeParameterDescriptor.isReified()) {
                return this.getIsTypeCheckCallableForReifiedType(typeParameterDescriptor);
            }
            JsExpression result2 = null;
            for (KotlinType upperBound : typeParameterDescriptor.getUpperBounds()) {
                JsExpression next = this.doGetIsTypeCheckCallable(upperBound);
                if (next == null) continue;
                result2 = result2 != null ? this.namer().andPredicate(result2, next) : next;
            }
            return result2;
        }
        ClassDescriptor referencedClass = DescriptorUtils.getClassDescriptorForType(type2);
        JsExpression typeName = ReferenceTranslator.translateAsTypeReference(referencedClass, this.context());
        return this.namer().isInstanceOf(typeName);
    }

    @Nullable
    private JsExpression getIsTypeCheckCallableForBuiltin(@NotNull KotlinType type2) {
        if (type2 == null) {
            PatternTranslator.$$$reportNull$$$1(15);
        }
        if (type2 == null) {
            PatternTranslator.$$$reportNull$$$0(15);
        }
        if ((KotlinBuiltIns.isNotNullOrNullableFunctionSupertype(type2) || FunctionTypesKt.isFunctionTypeOrSubtype(type2)) && !ReflectionTypes.isNumberedKPropertyOrKMutablePropertyType(type2)) {
            return this.namer().isTypeOf(new JsStringLiteral("function"));
        }
        if (KotlinBuiltIns.isArray(type2)) {
            if (ArrayFIF.typedArraysEnabled(this.context().getConfig())) {
                return this.namer().isArray();
            }
            return Namer.IS_ARRAY_FUN_REF;
        }
        if (TypePredicatesKt.getCHAR_SEQUENCE().test(type2)) {
            return this.namer().isCharSequence();
        }
        if (TypePredicatesKt.getCOMPARABLE().test(type2)) {
            return this.namer().isComparable();
        }
        return null;
    }

    @Nullable
    private JsExpression getIsTypeCheckCallableForPrimitiveBuiltin(@NotNull KotlinType type2) {
        Name typeName;
        if (type2 == null) {
            PatternTranslator.$$$reportNull$$$1(16);
        }
        if (type2 == null) {
            PatternTranslator.$$$reportNull$$$0(16);
        }
        if (NamePredicate.STRING.test(typeName = DescriptorUtilsKt.getNameIfStandardType(type2))) {
            return this.namer().isTypeOf(new JsStringLiteral("string"));
        }
        if (NamePredicate.BOOLEAN.test(typeName)) {
            return this.namer().isTypeOf(new JsStringLiteral("boolean"));
        }
        if (NamePredicate.LONG.test(typeName)) {
            return this.namer().isInstanceOf(Namer.kotlinLong());
        }
        if (NamePredicate.NUMBER.test(typeName)) {
            return this.namer().kotlin("isNumber");
        }
        if (NamePredicate.CHAR.test(typeName)) {
            return this.namer().kotlin("isChar");
        }
        if (NamePredicate.PRIMITIVE_NUMBERS_MAPPED_TO_PRIMITIVE_JS.test(typeName)) {
            return this.namer().isTypeOf(new JsStringLiteral("number"));
        }
        if (ArrayFIF.typedArraysEnabled(this.context().getConfig()) && KotlinBuiltIns.isPrimitiveArray(type2)) {
            PrimitiveType arrayType = KotlinBuiltIns.getPrimitiveArrayElementType(type2);
            assert (arrayType != null);
            return this.namer().isPrimitiveArray(arrayType);
        }
        return null;
    }

    @NotNull
    private JsExpression getIsTypeCheckCallableForReifiedType(@NotNull TypeParameterDescriptor typeParameter) {
        if (typeParameter == null) {
            PatternTranslator.$$$reportNull$$$1(17);
        }
        if (typeParameter == null) {
            PatternTranslator.$$$reportNull$$$0(17);
        }
        assert (typeParameter.isReified()) : "Expected reified type, actual: " + typeParameter;
        DeclarationDescriptor containingDeclaration = typeParameter.getContainingDeclaration();
        assert (containingDeclaration instanceof CallableDescriptor) : "Expected type parameter " + typeParameter + " to be contained in CallableDescriptor, actual: " + containingDeclaration.getClass();
        JsExpression alias = this.context().getAliasForDescriptor(typeParameter);
        assert (alias != null) : "No alias found for reified type parameter: " + typeParameter;
        JsExpression jsExpression = alias;
        if (jsExpression == null) {
            PatternTranslator.$$$reportNull$$$0(18);
        }
        if (jsExpression == null) {
            PatternTranslator.$$$reportNull$$$1(18);
        }
        return jsExpression;
    }

    @NotNull
    public JsExpression translateExpressionPattern(@NotNull KotlinType subjectType, @NotNull JsExpression expressionToMatch, @NotNull KtExpression patternExpression) {
        KotlinType patternType;
        KotlinType actualSubjectType;
        PrimitiveNumericComparisonInfo ieeeInfo;
        if (subjectType == null) {
            PatternTranslator.$$$reportNull$$$1(19);
        }
        if (expressionToMatch == null) {
            PatternTranslator.$$$reportNull$$$1(20);
        }
        if (patternExpression == null) {
            PatternTranslator.$$$reportNull$$$1(21);
        }
        if (subjectType == null) {
            PatternTranslator.$$$reportNull$$$0(19);
        }
        if (expressionToMatch == null) {
            PatternTranslator.$$$reportNull$$$0(20);
        }
        if (patternExpression == null) {
            PatternTranslator.$$$reportNull$$$0(21);
        }
        if ((ieeeInfo = UtilsKt.getPrimitiveNumericComparisonInfo(this.context(), patternExpression)) != null) {
            actualSubjectType = ieeeInfo.getLeftType();
            patternType = ieeeInfo.getRightType();
        } else {
            actualSubjectType = UtilsKt.refineType(subjectType);
            patternType = UtilsKt.getPrecisePrimitiveTypeNotNull(this.context(), patternExpression);
        }
        EqualityType matchEquality = PatternTranslator.equalityType(actualSubjectType);
        EqualityType patternEquality = PatternTranslator.equalityType(patternType);
        JsExpression expressionToMatchAgainst = TranslationUtils.coerce(this.context(), this.translateExpressionForExpressionPattern(patternExpression), actualSubjectType);
        if (matchEquality == EqualityType.PRIMITIVE && patternEquality == EqualityType.PRIMITIVE) {
            JsBinaryOperation jsBinaryOperation = JsAstUtils.equality(expressionToMatch, expressionToMatchAgainst);
            if (jsBinaryOperation == null) {
                PatternTranslator.$$$reportNull$$$0(22);
            }
            if (jsBinaryOperation == null) {
                PatternTranslator.$$$reportNull$$$1(22);
            }
            return jsBinaryOperation;
        }
        if (expressionToMatchAgainst instanceof JsNullLiteral) {
            JsBinaryOperation jsBinaryOperation = TranslationUtils.nullCheck(actualSubjectType, expressionToMatch, this.context(), false);
            if (jsBinaryOperation == null) {
                PatternTranslator.$$$reportNull$$$0(23);
            }
            if (jsBinaryOperation == null) {
                PatternTranslator.$$$reportNull$$$1(23);
            }
            return jsBinaryOperation;
        }
        JsExpression jsExpression = TopLevelFIF.KOTLIN_EQUALS.apply(expressionToMatch, Collections.singletonList(expressionToMatchAgainst), this.context());
        if (jsExpression == null) {
            PatternTranslator.$$$reportNull$$$0(24);
        }
        if (jsExpression == null) {
            PatternTranslator.$$$reportNull$$$1(24);
        }
        return jsExpression;
    }

    @NotNull
    private static EqualityType equalityType(@NotNull KotlinType type2) {
        ClassifierDescriptor descriptor2;
        if (type2 == null) {
            PatternTranslator.$$$reportNull$$$1(25);
        }
        if (type2 == null) {
            PatternTranslator.$$$reportNull$$$0(25);
        }
        if (!((descriptor2 = type2.getConstructor().getDeclarationDescriptor()) instanceof ClassDescriptor)) {
            EqualityType equalityType = EqualityType.GENERAL;
            if (equalityType == null) {
                PatternTranslator.$$$reportNull$$$0(26);
            }
            if (equalityType == null) {
                PatternTranslator.$$$reportNull$$$1(26);
            }
            return equalityType;
        }
        PrimitiveType primitive = KotlinBuiltIns.getPrimitiveType(descriptor2);
        if (primitive == null) {
            EqualityType equalityType = EqualityType.GENERAL;
            if (equalityType == null) {
                PatternTranslator.$$$reportNull$$$0(27);
            }
            if (equalityType == null) {
                PatternTranslator.$$$reportNull$$$1(27);
            }
            return equalityType;
        }
        EqualityType equalityType = primitive == PrimitiveType.LONG ? EqualityType.LONG : EqualityType.PRIMITIVE;
        if (equalityType == null) {
            PatternTranslator.$$$reportNull$$$0(28);
        }
        if (equalityType == null) {
            PatternTranslator.$$$reportNull$$$1(28);
        }
        return equalityType;
    }

    @NotNull
    public JsExpression translateExpressionForExpressionPattern(@NotNull KtExpression patternExpression) {
        if (patternExpression == null) {
            PatternTranslator.$$$reportNull$$$1(29);
        }
        if (patternExpression == null) {
            PatternTranslator.$$$reportNull$$$0(29);
        }
        JsExpression jsExpression = Translation.translateAsExpression(patternExpression, this.context());
        if (jsExpression == null) {
            PatternTranslator.$$$reportNull$$$0(30);
        }
        if (jsExpression == null) {
            PatternTranslator.$$$reportNull$$$1(30);
        }
        return jsExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 30: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/expression/PatternTranslator";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subject";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetTypeReference";
                break;
            }
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameter";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subjectType";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionToMatch";
                break;
            }
            case 21: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/expression/PatternTranslator";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "translateCastExpression";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "translateIsExpression";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getIsTypeCheckCallable";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getIsTypeCheckCallableForReifiedType";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "translateExpressionPattern";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "equalityType";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "translateExpressionForExpressionPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "newInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isCastExpression";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "translateCastExpression";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 30: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "translateIsExpression";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "translateIsCheck";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getIsTypeCheckCallable";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doGetIsTypeCheckCallable";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getIsTypeCheckCallableForBuiltin";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getIsTypeCheckCallableForPrimitiveBuiltin";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getIsTypeCheckCallableForReifiedType";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "translateExpressionPattern";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "equalityType";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "translateExpressionForExpressionPattern";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 30: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static /* synthetic */ void $$$reportNull$$$1(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 30: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/expression/PatternTranslator";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subject";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetTypeReference";
                break;
            }
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameter";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subjectType";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionToMatch";
                break;
            }
            case 21: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/expression/PatternTranslator";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "translateCastExpression";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "translateIsExpression";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getIsTypeCheckCallable";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getIsTypeCheckCallableForReifiedType";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "translateExpressionPattern";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "equalityType";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "translateExpressionForExpressionPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "newInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isCastExpression";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "translateCastExpression";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 30: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "translateIsExpression";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "translateIsCheck";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getIsTypeCheckCallable";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doGetIsTypeCheckCallable";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getIsTypeCheckCallableForBuiltin";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getIsTypeCheckCallableForPrimitiveBuiltin";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getIsTypeCheckCallableForReifiedType";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "translateExpressionPattern";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "equalityType";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "translateExpressionForExpressionPattern";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 30: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum EqualityType {
        PRIMITIVE,
        LONG,
        GENERAL;

    }
}

