/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.cli.converter;

import java.io.File;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.cli.CommandLineConverter;
import org.gradle.cli.CommandLineParser;
import org.gradle.cli.ParsedCommandLine;
import org.gradle.initialization.BuildLayoutParameters;
import org.gradle.initialization.BuildLayoutParametersBuildOptions;
import org.gradle.initialization.LayoutCommandLineConverter;
import org.gradle.launcher.configuration.BuildLayoutResult;
import org.gradle.launcher.configuration.InitialProperties;

public class BuildLayoutConverter {
    private final CommandLineConverter<BuildLayoutParameters> buildLayoutConverter = new LayoutCommandLineConverter();

    public void configure(CommandLineParser parser) {
        this.buildLayoutConverter.configure(parser);
    }

    public BuildLayoutResult defaultValues() {
        return new Result(new BuildLayoutParameters());
    }

    public BuildLayoutResult convert(InitialProperties systemProperties, ParsedCommandLine commandLine, @Nullable File workingDir) {
        return this.convert(systemProperties, commandLine, workingDir, parameters -> {});
    }

    public BuildLayoutResult convert(InitialProperties systemProperties, ParsedCommandLine commandLine, @Nullable File workingDir, Consumer<BuildLayoutParameters> defaults) {
        BuildLayoutParameters layoutParameters = new BuildLayoutParameters();
        if (workingDir != null) {
            layoutParameters.setCurrentDir(workingDir);
        }
        defaults.accept(layoutParameters);
        Map<String, String> requestedSystemProperties = systemProperties.getRequestedSystemProperties();
        new BuildLayoutParametersBuildOptions().propertiesConverter().convert(requestedSystemProperties, (Object)layoutParameters);
        this.buildLayoutConverter.convert(commandLine, (Object)layoutParameters);
        return new Result(layoutParameters);
    }

    private static class Result
    implements BuildLayoutResult {
        private final BuildLayoutParameters buildLayout;

        public Result(BuildLayoutParameters buildLayout) {
            this.buildLayout = buildLayout;
        }

        @Override
        public void applyTo(BuildLayoutParameters buildLayout) {
            buildLayout.setCurrentDir(this.buildLayout.getCurrentDir());
            buildLayout.setProjectDir(this.buildLayout.getProjectDir());
            buildLayout.setSearchUpwards(this.buildLayout.getSearchUpwards());
            buildLayout.setGradleUserHomeDir(this.buildLayout.getGradleUserHomeDir());
            buildLayout.setGradleInstallationHomeDir(this.buildLayout.getGradleInstallationHomeDir());
        }

        @Override
        public void applyTo(StartParameterInternal startParameter) {
            startParameter.setProjectDir(this.buildLayout.getProjectDir());
            startParameter.setCurrentDir(this.buildLayout.getCurrentDir());
            startParameter.setSearchUpwardsWithoutDeprecationWarning(this.buildLayout.getSearchUpwards());
            startParameter.setGradleUserHomeDir(this.buildLayout.getGradleUserHomeDir());
        }

        @Override
        public File getGradleUserHomeDir() {
            return this.buildLayout.getGradleUserHomeDir();
        }
    }
}

