"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var __1 = require("../../..");
var get_last_click_1 = require("../../../../state/selectors/get_last_click");
var get_settings_specs_1 = require("../../../../state/selectors/get_settings_specs");
var utils_1 = require("../../../../state/utils");
var get_tooltip_values_highlighted_geoms_1 = require("./get_tooltip_values_highlighted_geoms");
function createOnElementClickCaller() {
    var prevClick = null;
    var selector = null;
    return function (state) {
        if (selector === null && state.chartType === __1.ChartTypes.XYAxis) {
            selector = re_reselect_1.default([get_last_click_1.getLastClickSelector, get_settings_specs_1.getSettingsSpecSelector, get_tooltip_values_highlighted_geoms_1.getHighlightedGeomsSelector], function (lastClick, settings, indexedGeometries) {
                if (!settings.onElementClick) {
                    return;
                }
                if (indexedGeometries.length > 0 && utils_1.isClicking(prevClick, lastClick)) {
                    if (settings && settings.onElementClick) {
                        var elements = indexedGeometries.map(function (_a) {
                            var value = _a.value, seriesIdentifier = _a.seriesIdentifier;
                            return [value, seriesIdentifier];
                        });
                        settings.onElementClick(elements);
                    }
                }
                prevClick = lastClick;
            })({
                keySelector: function (state) { return state.chartId; },
            });
        }
        if (selector) {
            selector(state);
        }
    };
}
exports.createOnElementClickCaller = createOnElementClickCaller;
//# sourceMappingURL=on_element_click_caller.js.map