/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkIndirectCommandsLayoutTokenNVX;

public class VkIndirectCommandsLayoutCreateInfoNVX
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PIPELINEBINDPOINT;
    public static final int FLAGS;
    public static final int TOKENCOUNT;
    public static final int PTOKENS;

    public VkIndirectCommandsLayoutCreateInfoNVX(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkIndirectCommandsLayoutCreateInfoNVX.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkIndirectCommandsLayoutCreateInfoNVX.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkIndirectCommandsLayoutCreateInfoNVX.npNext(this.address());
    }

    @NativeType(value="VkPipelineBindPoint")
    public int pipelineBindPoint() {
        return VkIndirectCommandsLayoutCreateInfoNVX.npipelineBindPoint(this.address());
    }

    @NativeType(value="VkIndirectCommandsLayoutUsageFlagsNVX")
    public int flags() {
        return VkIndirectCommandsLayoutCreateInfoNVX.nflags(this.address());
    }

    @NativeType(value="uint32_t")
    public int tokenCount() {
        return VkIndirectCommandsLayoutCreateInfoNVX.ntokenCount(this.address());
    }

    @NativeType(value="VkIndirectCommandsLayoutTokenNVX const *")
    public VkIndirectCommandsLayoutTokenNVX.Buffer pTokens() {
        return VkIndirectCommandsLayoutCreateInfoNVX.npTokens(this.address());
    }

    public VkIndirectCommandsLayoutCreateInfoNVX sType(@NativeType(value="VkStructureType") int value) {
        VkIndirectCommandsLayoutCreateInfoNVX.nsType(this.address(), value);
        return this;
    }

    public VkIndirectCommandsLayoutCreateInfoNVX pNext(@NativeType(value="void const *") long value) {
        VkIndirectCommandsLayoutCreateInfoNVX.npNext(this.address(), value);
        return this;
    }

    public VkIndirectCommandsLayoutCreateInfoNVX pipelineBindPoint(@NativeType(value="VkPipelineBindPoint") int value) {
        VkIndirectCommandsLayoutCreateInfoNVX.npipelineBindPoint(this.address(), value);
        return this;
    }

    public VkIndirectCommandsLayoutCreateInfoNVX flags(@NativeType(value="VkIndirectCommandsLayoutUsageFlagsNVX") int value) {
        VkIndirectCommandsLayoutCreateInfoNVX.nflags(this.address(), value);
        return this;
    }

    public VkIndirectCommandsLayoutCreateInfoNVX pTokens(@NativeType(value="VkIndirectCommandsLayoutTokenNVX const *") VkIndirectCommandsLayoutTokenNVX.Buffer value) {
        VkIndirectCommandsLayoutCreateInfoNVX.npTokens(this.address(), value);
        return this;
    }

    public VkIndirectCommandsLayoutCreateInfoNVX set(int sType, long pNext, int pipelineBindPoint, int flags, VkIndirectCommandsLayoutTokenNVX.Buffer pTokens) {
        this.sType(sType);
        this.pNext(pNext);
        this.pipelineBindPoint(pipelineBindPoint);
        this.flags(flags);
        this.pTokens(pTokens);
        return this;
    }

    public VkIndirectCommandsLayoutCreateInfoNVX set(VkIndirectCommandsLayoutCreateInfoNVX src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkIndirectCommandsLayoutCreateInfoNVX malloc() {
        return (VkIndirectCommandsLayoutCreateInfoNVX)VkIndirectCommandsLayoutCreateInfoNVX.wrap(VkIndirectCommandsLayoutCreateInfoNVX.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkIndirectCommandsLayoutCreateInfoNVX calloc() {
        return (VkIndirectCommandsLayoutCreateInfoNVX)VkIndirectCommandsLayoutCreateInfoNVX.wrap(VkIndirectCommandsLayoutCreateInfoNVX.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkIndirectCommandsLayoutCreateInfoNVX create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkIndirectCommandsLayoutCreateInfoNVX)VkIndirectCommandsLayoutCreateInfoNVX.wrap(VkIndirectCommandsLayoutCreateInfoNVX.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkIndirectCommandsLayoutCreateInfoNVX create(long address) {
        return (VkIndirectCommandsLayoutCreateInfoNVX)VkIndirectCommandsLayoutCreateInfoNVX.wrap(VkIndirectCommandsLayoutCreateInfoNVX.class, (long)address);
    }

    @Nullable
    public static VkIndirectCommandsLayoutCreateInfoNVX createSafe(long address) {
        return address == 0L ? null : (VkIndirectCommandsLayoutCreateInfoNVX)VkIndirectCommandsLayoutCreateInfoNVX.wrap(VkIndirectCommandsLayoutCreateInfoNVX.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkIndirectCommandsLayoutCreateInfoNVX.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkIndirectCommandsLayoutCreateInfoNVX.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkIndirectCommandsLayoutCreateInfoNVX.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkIndirectCommandsLayoutCreateInfoNVX.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkIndirectCommandsLayoutCreateInfoNVX.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkIndirectCommandsLayoutCreateInfoNVX.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkIndirectCommandsLayoutCreateInfoNVX.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkIndirectCommandsLayoutCreateInfoNVX mallocStack() {
        return VkIndirectCommandsLayoutCreateInfoNVX.mallocStack(MemoryStack.stackGet());
    }

    public static VkIndirectCommandsLayoutCreateInfoNVX callocStack() {
        return VkIndirectCommandsLayoutCreateInfoNVX.callocStack(MemoryStack.stackGet());
    }

    public static VkIndirectCommandsLayoutCreateInfoNVX mallocStack(MemoryStack stack) {
        return (VkIndirectCommandsLayoutCreateInfoNVX)VkIndirectCommandsLayoutCreateInfoNVX.wrap(VkIndirectCommandsLayoutCreateInfoNVX.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkIndirectCommandsLayoutCreateInfoNVX callocStack(MemoryStack stack) {
        return (VkIndirectCommandsLayoutCreateInfoNVX)VkIndirectCommandsLayoutCreateInfoNVX.wrap(VkIndirectCommandsLayoutCreateInfoNVX.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkIndirectCommandsLayoutCreateInfoNVX.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkIndirectCommandsLayoutCreateInfoNVX.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkIndirectCommandsLayoutCreateInfoNVX.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkIndirectCommandsLayoutCreateInfoNVX.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int npipelineBindPoint(long struct) {
        return UNSAFE.getInt(null, struct + (long)PIPELINEBINDPOINT);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static int ntokenCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)TOKENCOUNT);
    }

    public static VkIndirectCommandsLayoutTokenNVX.Buffer npTokens(long struct) {
        return VkIndirectCommandsLayoutTokenNVX.create(MemoryUtil.memGetAddress((long)(struct + (long)PTOKENS)), VkIndirectCommandsLayoutCreateInfoNVX.ntokenCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void npipelineBindPoint(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PIPELINEBINDPOINT, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void ntokenCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TOKENCOUNT, value);
    }

    public static void npTokens(long struct, VkIndirectCommandsLayoutTokenNVX.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PTOKENS), (long)value.address());
        VkIndirectCommandsLayoutCreateInfoNVX.ntokenCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PTOKENS)));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkIndirectCommandsLayoutCreateInfoNVX.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = VkIndirectCommandsLayoutCreateInfoNVX.__struct((Struct.Member[])new Struct.Member[]{VkIndirectCommandsLayoutCreateInfoNVX.__member((int)4), VkIndirectCommandsLayoutCreateInfoNVX.__member((int)POINTER_SIZE), VkIndirectCommandsLayoutCreateInfoNVX.__member((int)4), VkIndirectCommandsLayoutCreateInfoNVX.__member((int)4), VkIndirectCommandsLayoutCreateInfoNVX.__member((int)4), VkIndirectCommandsLayoutCreateInfoNVX.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PIPELINEBINDPOINT = layout.offsetof(2);
        FLAGS = layout.offsetof(3);
        TOKENCOUNT = layout.offsetof(4);
        PTOKENS = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkIndirectCommandsLayoutCreateInfoNVX, Buffer>
    implements NativeResource {
        private static final VkIndirectCommandsLayoutCreateInfoNVX ELEMENT_FACTORY = VkIndirectCommandsLayoutCreateInfoNVX.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkIndirectCommandsLayoutCreateInfoNVX getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkIndirectCommandsLayoutCreateInfoNVX.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkIndirectCommandsLayoutCreateInfoNVX.npNext(this.address());
        }

        @NativeType(value="VkPipelineBindPoint")
        public int pipelineBindPoint() {
            return VkIndirectCommandsLayoutCreateInfoNVX.npipelineBindPoint(this.address());
        }

        @NativeType(value="VkIndirectCommandsLayoutUsageFlagsNVX")
        public int flags() {
            return VkIndirectCommandsLayoutCreateInfoNVX.nflags(this.address());
        }

        @NativeType(value="uint32_t")
        public int tokenCount() {
            return VkIndirectCommandsLayoutCreateInfoNVX.ntokenCount(this.address());
        }

        @NativeType(value="VkIndirectCommandsLayoutTokenNVX const *")
        public VkIndirectCommandsLayoutTokenNVX.Buffer pTokens() {
            return VkIndirectCommandsLayoutCreateInfoNVX.npTokens(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkIndirectCommandsLayoutCreateInfoNVX.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkIndirectCommandsLayoutCreateInfoNVX.npNext(this.address(), value);
            return this;
        }

        public Buffer pipelineBindPoint(@NativeType(value="VkPipelineBindPoint") int value) {
            VkIndirectCommandsLayoutCreateInfoNVX.npipelineBindPoint(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkIndirectCommandsLayoutUsageFlagsNVX") int value) {
            VkIndirectCommandsLayoutCreateInfoNVX.nflags(this.address(), value);
            return this;
        }

        public Buffer pTokens(@NativeType(value="VkIndirectCommandsLayoutTokenNVX const *") VkIndirectCommandsLayoutTokenNVX.Buffer value) {
            VkIndirectCommandsLayoutCreateInfoNVX.npTokens(this.address(), value);
            return this;
        }
    }
}

