/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.assimp.AIMatrix4x4;
import org.lwjgl.assimp.AINode;
import org.lwjgl.assimp.AIString;
import org.lwjgl.assimp.AIVertexWeight;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiBone")
public class AIBone
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MNAME;
    public static final int MNUMWEIGHTS;
    public static final int MARMATURE;
    public static final int MNODE;
    public static final int MWEIGHTS;
    public static final int MOFFSETMATRIX;

    public AIBone(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), AIBone.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct aiString")
    public AIString mName() {
        return AIBone.nmName(this.address());
    }

    @NativeType(value="unsigned int")
    public int mNumWeights() {
        return AIBone.nmNumWeights(this.address());
    }

    @NativeType(value="struct aiNode *")
    public AINode mArmature() {
        return AIBone.nmArmature(this.address());
    }

    @NativeType(value="struct aiNode *")
    public AINode mNode() {
        return AIBone.nmNode(this.address());
    }

    @NativeType(value="struct aiVertexWeight *")
    public AIVertexWeight.Buffer mWeights() {
        return AIBone.nmWeights(this.address());
    }

    @NativeType(value="struct aiMatrix4x4")
    public AIMatrix4x4 mOffsetMatrix() {
        return AIBone.nmOffsetMatrix(this.address());
    }

    public AIBone mName(@NativeType(value="struct aiString") AIString value) {
        AIBone.nmName(this.address(), value);
        return this;
    }

    public AIBone mName(Consumer<AIString> consumer) {
        consumer.accept(this.mName());
        return this;
    }

    public AIBone mArmature(@NativeType(value="struct aiNode *") AINode value) {
        AIBone.nmArmature(this.address(), value);
        return this;
    }

    public AIBone mNode(@NativeType(value="struct aiNode *") AINode value) {
        AIBone.nmNode(this.address(), value);
        return this;
    }

    public AIBone mWeights(@NativeType(value="struct aiVertexWeight *") AIVertexWeight.Buffer value) {
        AIBone.nmWeights(this.address(), value);
        return this;
    }

    public AIBone mOffsetMatrix(@NativeType(value="struct aiMatrix4x4") AIMatrix4x4 value) {
        AIBone.nmOffsetMatrix(this.address(), value);
        return this;
    }

    public AIBone mOffsetMatrix(Consumer<AIMatrix4x4> consumer) {
        consumer.accept(this.mOffsetMatrix());
        return this;
    }

    public AIBone set(AIString mName, AINode mArmature, AINode mNode, AIVertexWeight.Buffer mWeights, AIMatrix4x4 mOffsetMatrix) {
        this.mName(mName);
        this.mArmature(mArmature);
        this.mNode(mNode);
        this.mWeights(mWeights);
        this.mOffsetMatrix(mOffsetMatrix);
        return this;
    }

    public AIBone set(AIBone src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static AIBone malloc() {
        return (AIBone)AIBone.wrap(AIBone.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static AIBone calloc() {
        return (AIBone)AIBone.wrap(AIBone.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static AIBone create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (AIBone)AIBone.wrap(AIBone.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static AIBone create(long address) {
        return (AIBone)AIBone.wrap(AIBone.class, (long)address);
    }

    @Nullable
    public static AIBone createSafe(long address) {
        return address == 0L ? null : (AIBone)AIBone.wrap(AIBone.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)AIBone.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)AIBone.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)AIBone.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AIBone.__create((int)capacity, (int)SIZEOF);
        return (Buffer)AIBone.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)AIBone.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)AIBone.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static AIBone mallocStack() {
        return AIBone.mallocStack(MemoryStack.stackGet());
    }

    public static AIBone callocStack() {
        return AIBone.callocStack(MemoryStack.stackGet());
    }

    public static AIBone mallocStack(MemoryStack stack) {
        return (AIBone)AIBone.wrap(AIBone.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIBone callocStack(MemoryStack stack) {
        return (AIBone)AIBone.wrap(AIBone.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return AIBone.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return AIBone.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)AIBone.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)AIBone.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static AIString nmName(long struct) {
        return AIString.create(struct + (long)MNAME);
    }

    public static int nmNumWeights(long struct) {
        return UNSAFE.getInt(null, struct + (long)MNUMWEIGHTS);
    }

    public static AINode nmArmature(long struct) {
        return AINode.create(MemoryUtil.memGetAddress((long)(struct + (long)MARMATURE)));
    }

    public static AINode nmNode(long struct) {
        return AINode.create(MemoryUtil.memGetAddress((long)(struct + (long)MNODE)));
    }

    public static AIVertexWeight.Buffer nmWeights(long struct) {
        return AIVertexWeight.create(MemoryUtil.memGetAddress((long)(struct + (long)MWEIGHTS)), AIBone.nmNumWeights(struct));
    }

    public static AIMatrix4x4 nmOffsetMatrix(long struct) {
        return AIMatrix4x4.create(struct + (long)MOFFSETMATRIX);
    }

    public static void nmName(long struct, AIString value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)MNAME), (long)AIString.SIZEOF);
    }

    public static void nmNumWeights(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MNUMWEIGHTS, value);
    }

    public static void nmArmature(long struct, AINode value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MARMATURE), (long)value.address());
    }

    public static void nmNode(long struct, AINode value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MNODE), (long)value.address());
    }

    public static void nmWeights(long struct, AIVertexWeight.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MWEIGHTS), (long)value.address());
        AIBone.nmNumWeights(struct, value.remaining());
    }

    public static void nmOffsetMatrix(long struct, AIMatrix4x4 value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)MOFFSETMATRIX), (long)AIMatrix4x4.SIZEOF);
    }

    public static void validate(long struct) {
        long mArmature = MemoryUtil.memGetAddress((long)(struct + (long)MARMATURE));
        Checks.check((long)mArmature);
        AINode.validate(mArmature);
        long mNode = MemoryUtil.memGetAddress((long)(struct + (long)MNODE));
        Checks.check((long)mNode);
        AINode.validate(mNode);
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)MWEIGHTS)));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            AIBone.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = AIBone.__struct((Struct.Member[])new Struct.Member[]{AIBone.__member((int)AIString.SIZEOF, (int)AIString.ALIGNOF), AIBone.__member((int)4), AIBone.__member((int)POINTER_SIZE), AIBone.__member((int)POINTER_SIZE), AIBone.__member((int)POINTER_SIZE), AIBone.__member((int)AIMatrix4x4.SIZEOF, (int)AIMatrix4x4.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MNAME = layout.offsetof(0);
        MNUMWEIGHTS = layout.offsetof(1);
        MARMATURE = layout.offsetof(2);
        MNODE = layout.offsetof(3);
        MWEIGHTS = layout.offsetof(4);
        MOFFSETMATRIX = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<AIBone, Buffer>
    implements NativeResource {
        private static final AIBone ELEMENT_FACTORY = AIBone.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected AIBone getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct aiString")
        public AIString mName() {
            return AIBone.nmName(this.address());
        }

        @NativeType(value="unsigned int")
        public int mNumWeights() {
            return AIBone.nmNumWeights(this.address());
        }

        @NativeType(value="struct aiNode *")
        public AINode mArmature() {
            return AIBone.nmArmature(this.address());
        }

        @NativeType(value="struct aiNode *")
        public AINode mNode() {
            return AIBone.nmNode(this.address());
        }

        @NativeType(value="struct aiVertexWeight *")
        public AIVertexWeight.Buffer mWeights() {
            return AIBone.nmWeights(this.address());
        }

        @NativeType(value="struct aiMatrix4x4")
        public AIMatrix4x4 mOffsetMatrix() {
            return AIBone.nmOffsetMatrix(this.address());
        }

        public Buffer mName(@NativeType(value="struct aiString") AIString value) {
            AIBone.nmName(this.address(), value);
            return this;
        }

        public Buffer mName(Consumer<AIString> consumer) {
            consumer.accept(this.mName());
            return this;
        }

        public Buffer mArmature(@NativeType(value="struct aiNode *") AINode value) {
            AIBone.nmArmature(this.address(), value);
            return this;
        }

        public Buffer mNode(@NativeType(value="struct aiNode *") AINode value) {
            AIBone.nmNode(this.address(), value);
            return this;
        }

        public Buffer mWeights(@NativeType(value="struct aiVertexWeight *") AIVertexWeight.Buffer value) {
            AIBone.nmWeights(this.address(), value);
            return this;
        }

        public Buffer mOffsetMatrix(@NativeType(value="struct aiMatrix4x4") AIMatrix4x4 value) {
            AIBone.nmOffsetMatrix(this.address(), value);
            return this;
        }

        public Buffer mOffsetMatrix(Consumer<AIMatrix4x4> consumer) {
            consumer.accept(this.mOffsetMatrix());
            return this;
        }
    }
}

