/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.llvm.LLVMOptRemarkDebugLoc;
import org.lwjgl.llvm.LLVMOptRemarkStringRef;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class LLVMOptRemarkArg
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int KEY;
    public static final int VALUE;
    public static final int DEBUGLOC;

    public LLVMOptRemarkArg(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), LLVMOptRemarkArg.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public LLVMOptRemarkStringRef Key() {
        return LLVMOptRemarkArg.nKey(this.address());
    }

    public LLVMOptRemarkStringRef Value() {
        return LLVMOptRemarkArg.nValue(this.address());
    }

    public LLVMOptRemarkDebugLoc DebugLoc() {
        return LLVMOptRemarkArg.nDebugLoc(this.address());
    }

    public static LLVMOptRemarkArg create(long address) {
        return (LLVMOptRemarkArg)LLVMOptRemarkArg.wrap(LLVMOptRemarkArg.class, (long)address);
    }

    @Nullable
    public static LLVMOptRemarkArg createSafe(long address) {
        return address == 0L ? null : (LLVMOptRemarkArg)LLVMOptRemarkArg.wrap(LLVMOptRemarkArg.class, (long)address);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)LLVMOptRemarkArg.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)LLVMOptRemarkArg.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static LLVMOptRemarkStringRef nKey(long struct) {
        return LLVMOptRemarkStringRef.create(struct + (long)KEY);
    }

    public static LLVMOptRemarkStringRef nValue(long struct) {
        return LLVMOptRemarkStringRef.create(struct + (long)VALUE);
    }

    public static LLVMOptRemarkDebugLoc nDebugLoc(long struct) {
        return LLVMOptRemarkDebugLoc.create(struct + (long)DEBUGLOC);
    }

    static {
        Struct.Layout layout = LLVMOptRemarkArg.__struct((Struct.Member[])new Struct.Member[]{LLVMOptRemarkArg.__member((int)LLVMOptRemarkStringRef.SIZEOF, (int)LLVMOptRemarkStringRef.ALIGNOF), LLVMOptRemarkArg.__member((int)LLVMOptRemarkStringRef.SIZEOF, (int)LLVMOptRemarkStringRef.ALIGNOF), LLVMOptRemarkArg.__member((int)LLVMOptRemarkDebugLoc.SIZEOF, (int)LLVMOptRemarkDebugLoc.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        KEY = layout.offsetof(0);
        VALUE = layout.offsetof(1);
        DEBUGLOC = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<LLVMOptRemarkArg, Buffer> {
        private static final LLVMOptRemarkArg ELEMENT_FACTORY = LLVMOptRemarkArg.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected LLVMOptRemarkArg getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public LLVMOptRemarkStringRef Key() {
            return LLVMOptRemarkArg.nKey(this.address());
        }

        public LLVMOptRemarkStringRef Value() {
            return LLVMOptRemarkArg.nValue(this.address());
        }

        public LLVMOptRemarkDebugLoc DebugLoc() {
            return LLVMOptRemarkArg.nDebugLoc(this.address());
        }
    }
}

