/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.Checksum;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.ObdDecoder;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;

public class L100ProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().text("ATL").expression(",[^,]+,").optional().number("(d{15}),").text("$GPRMC,").number("(dd)(dd)(dd)").number(".(ddd)").optional().expression(",([AV]),").number("(d+)(dd.d+),").expression("([NS]),").number("(d+)(dd.d+),").expression("([EW]),").number("(d+.?d*)?,").number("(d+.?d*)?,").number("(dd)(dd)(dd),").any().text("#").number("([01]+),").number("(d+.?d*|N.C),").expression("[^,]*,").expression("[^,]*,").number("(d+.?d*),").number("(d+.?d*),").number("(d+.?d*),").number("(d+),").number("(d+),").number("(d+),").number("(x+),").number("(x+)").any().text("ATL").compile();
    private static final Pattern PATTERN_OBD_LOCATION = new PatternBuilder().expression("[LH],").text("ATL,").number("(d{15}),").number("(d+),").number("(d+),").groupBegin().number("(dd)(dd)(dd),").number("(dd)(dd)(dd),").expression("([AV]),").number("(d+.d+);([NS]),").number("(d+.d+);([EW]),").number("(d+),").number("(d+),").number("(d+.d+),").number("(d+.d+),").number("(d+),").number("(d+),").number("(d+),").number("(d+),").number("(x+),").number("#(d)(d)(d)(d),").number("(d),").text("ATL,").groupEnd("?").compile();
    private static final Pattern PATTERN_OBD_DATA = new PatternBuilder().expression("[LH],").text("ATLOBD,").number("(d{15}),").number("d+,").number("d+,").number("(dd)(dd)(dd),").number("(dd)(dd)(dd),").expression("[^,]+,").expression("(.+)").compile();
    private static final Pattern PATTERN_NEW = new PatternBuilder().groupBegin().text("ATL,").expression("[LH],").number("(d{15}),").groupEnd("?").expression("([NPT]),").number("(dd)(dd)(dd),").number("(dd)(dd)(dd),").expression("([AV]),").number("(d+.d+),([NS]),").number("(d+.d+),([EW]),").number("(d+.?d*),").expression("(?:GPS|GSM|INV),").number("(d+),").number("(d+),").number("(d+),").number("(d+),").number("(d+)").compile();

    public L100ProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String sentence = (String)msg;
        if (sentence.startsWith("L") || sentence.startsWith("H")) {
            if (sentence.startsWith("ATLOBD", 2)) {
                return this.decodeObdData(channel, remoteAddress, sentence);
            }
            return this.decodeObdLocation(channel, remoteAddress, sentence);
        }
        if (!sentence.contains("$GPRMC")) {
            return this.decodeNew(channel, remoteAddress, sentence);
        }
        return this.decodeNormal(channel, remoteAddress, sentence);
    }

    private Object decodeNormal(Channel channel, SocketAddress remoteAddress, String sentence) {
        Parser parser = new Parser(PATTERN, sentence);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        DateBuilder dateBuilder = new DateBuilder().setTime(parser.nextInt(), parser.nextInt(), parser.nextInt(), parser.nextInt(0));
        position.setValid(parser.next().equals("A"));
        position.setLatitude(parser.nextCoordinate());
        position.setLongitude(parser.nextCoordinate());
        position.setSpeed(parser.nextDouble(0.0));
        position.setCourse(parser.nextDouble(0.0));
        dateBuilder.setDateReverse(parser.nextInt(), parser.nextInt(), parser.nextInt());
        position.setTime(dateBuilder.getDate());
        position.set("status", parser.next());
        position.set("adc1", parser.next());
        position.set("odometer", parser.nextDouble());
        position.set("temp1", parser.nextDouble());
        position.set("battery", parser.nextDouble());
        int rssi = parser.nextInt();
        if (rssi > 0) {
            position.setNetwork(new Network(CellTower.from(parser.nextInt(), parser.nextInt(), parser.nextHexInt(), parser.nextHexInt().intValue(), rssi)));
        }
        if (channel != null) {
            channel.writeAndFlush((Object)new NetworkMessage(String.valueOf('\u0001'), remoteAddress));
        }
        return position;
    }

    private Object decodeObdLocation(Channel channel, SocketAddress remoteAddress, String sentence) {
        Parser parser = new Parser(PATTERN_OBD_LOCATION, sentence);
        if (!parser.matches()) {
            return null;
        }
        String imei = parser.next();
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, imei);
        if (deviceSession == null) {
            return null;
        }
        int type = parser.nextInt();
        int index = parser.nextInt();
        if (type == 1) {
            if (channel != null) {
                String response = "@" + imei + ",00," + index + ",";
                response = response + "*" + (char)Checksum.xor(response);
                channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
            }
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.setTime(parser.nextDateTime(Parser.DateTimeFormat.HMS_DMY));
        position.setValid(parser.next().equals("A"));
        position.setLatitude(parser.nextCoordinate(Parser.CoordinateFormat.DEG_HEM));
        position.setLongitude(parser.nextCoordinate(Parser.CoordinateFormat.DEG_HEM));
        position.setSpeed(parser.nextInt().intValue());
        position.setCourse(parser.nextInt().intValue());
        position.set("odometer", parser.nextDouble() * 1000.0);
        position.set("battery", parser.nextDouble());
        int rssi = parser.nextInt();
        position.setNetwork(new Network(CellTower.from(parser.nextInt(), parser.nextInt(), parser.nextInt(), parser.nextHexInt().intValue(), rssi)));
        position.set("ignition", parser.nextInt() == 1);
        parser.next();
        switch (parser.nextInt()) {
            case 0: {
                position.set("alarm", "hardBraking");
                break;
            }
            case 2: {
                position.set("alarm", "hardAcceleration");
                break;
            }
            case 1: {
                position.set("alarm", "general");
                break;
            }
        }
        position.set("charge", parser.nextInt() == 1);
        if (parser.nextInt() == 1) {
            position.set("alarm", "overspeed");
        }
        return position;
    }

    private Object decodeObdData(Channel channel, SocketAddress remoteAddress, String sentence) {
        Parser parser = new Parser(PATTERN_OBD_DATA, sentence);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        this.getLastLocation(position, parser.nextDateTime(Parser.DateTimeFormat.HMS_DMY));
        for (String entry : parser.next().split(",")) {
            String[] values = entry.split(":");
            if (values.length != 2 || values[1].charAt(0) == 'X') continue;
            position.add(ObdDecoder.decodeData(Integer.parseInt(values[0].substring(2), 16), Integer.parseInt(values[1], 16), true));
        }
        return position;
    }

    private Object decodeNew(Channel channel, SocketAddress remoteAddress, String sentence) {
        Parser parser = new Parser(PATTERN_NEW, sentence);
        if (!parser.matches()) {
            return null;
        }
        String imei = parser.next();
        DeviceSession deviceSession = imei != null ? this.getDeviceSession(channel, remoteAddress, imei) : this.getDeviceSession(channel, remoteAddress, new String[0]);
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        switch (parser.next()) {
            case "P": {
                position.set("alarm", "sos");
                break;
            }
            case "T": {
                position.set("alarm", "tampering");
                break;
            }
        }
        position.setTime(parser.nextDateTime(Parser.DateTimeFormat.DMY_HMS));
        position.setValid(parser.next().equals("A"));
        position.setLatitude(parser.nextCoordinate(Parser.CoordinateFormat.DEG_HEM));
        position.setLongitude(parser.nextCoordinate(Parser.CoordinateFormat.DEG_HEM));
        position.setSpeed(parser.nextDouble());
        position.set("battery", (double)parser.nextInt().intValue() * 0.001);
        position.setNetwork(new Network(CellTower.from(parser.nextInt(), parser.nextInt(), parser.nextInt(), parser.nextHexInt().intValue())));
        return position;
    }
}

