/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.dict;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.dict.SearchKeyMapHandler;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.ocf.OCFPackage;
import com.adobe.epubcheck.opf.ContentChecker;
import com.adobe.epubcheck.opf.DocumentValidator;
import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.xml.XMLParser;
import com.adobe.epubcheck.xml.XMLValidators;
import com.google.common.base.Preconditions;

public class SearchKeyMapChecker
implements ContentChecker,
DocumentValidator {
    private final ValidationContext context;
    private final Report report;
    private final String path;

    public SearchKeyMapChecker(ValidationContext context) {
        Preconditions.checkState((boolean)"application/vnd.epub.search-key-map+xml".equals(context.mimeType));
        this.context = context;
        this.report = context.report;
        this.path = context.path;
    }

    @Override
    public void runChecks() {
        OCFPackage ocf = (OCFPackage)this.context.ocf.get();
        if (!ocf.hasEntry(this.path)) {
            this.report.message(MessageId.RSC_001, EPUBLocation.create(ocf.getName()), this.path);
        } else if (!ocf.canDecrypt(this.path)) {
            this.report.message(MessageId.RSC_004, EPUBLocation.create(ocf.getName()), this.path);
        } else if (!this.path.endsWith(".xml")) {
            this.report.message(MessageId.OPF_080, EPUBLocation.create(this.path), new Object[0]);
        } else {
            this.validate();
        }
    }

    @Override
    public boolean validate() {
        int fatalErrorsSoFar = this.report.getFatalErrorCount();
        int errorsSoFar = this.report.getErrorCount();
        int warningsSoFar = this.report.getWarningCount();
        XMLParser parser = new XMLParser(this.context);
        SearchKeyMapHandler handler = new SearchKeyMapHandler(this.context, parser);
        parser.addValidator(XMLValidators.SEARCH_KEY_MAP_RNC.get());
        parser.addXMLHandler(handler);
        parser.process();
        return fatalErrorsSoFar == this.report.getFatalErrorCount() && errorsSoFar == this.report.getErrorCount() && warningsSoFar == this.report.getWarningCount();
    }
}

