/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.Set;
import net.i2p.data.Hash;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.DatabaseLookupMessage;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.router.RouterIdentity;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.HandleDatabaseLookupMessageJob;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;

public class HandleFloodfillDatabaseLookupMessageJob
extends HandleDatabaseLookupMessageJob {
    public HandleFloodfillDatabaseLookupMessageJob(RouterContext ctx, DatabaseLookupMessage receivedMessage, RouterIdentity from, Hash fromHash) {
        super(ctx, receivedMessage, from, fromHash);
    }

    @Override
    protected boolean answerAllQueries() {
        if (!this.getContext().netDb().floodfillEnabled()) {
            return false;
        }
        return FloodfillNetworkDatabaseFacade.isFloodfill(this.getContext().router().getRouterInfo());
    }

    @Override
    protected void sendClosest(Hash key, Set<Hash> routerInfoSet, Hash toPeer, TunnelId replyTunnel) {
        super.sendClosest(key, routerInfoSet, toPeer, replyTunnel);
        if (!this.getContext().netDb().floodfillEnabled()) {
            DatabaseStoreMessage msg = new DatabaseStoreMessage(this.getContext());
            RouterInfo me = this.getContext().router().getRouterInfo();
            msg.setEntry(me);
            this.sendMessage(msg, toPeer, replyTunnel);
        }
    }
}

