/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wiki;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

class WikiProtocolSocketFactory
extends SSLSocketFactory {
    private SSLContext m_aSSLContext;

    WikiProtocolSocketFactory() {
    }

    private synchronized SSLContext GetNotSoSecureSSLContext() {
        if (this.m_aSSLContext != null) {
            return this.m_aSSLContext;
        }
        TrustManager[] trustManagerArray = new TrustManager[]{new X509TrustManager(){
            private X509TrustManager m_aOrgTrustManager;

            private X509TrustManager GetOrgTrustManager() {
                if (this.m_aOrgTrustManager == null) {
                    try {
                        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                        trustManagerFactory.init((KeyStore)null);
                        TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
                        if (trustManagerArray.length != 0 && trustManagerArray[0] != null) {
                            this.m_aOrgTrustManager = (X509TrustManager)trustManagerArray[0];
                        }
                    }
                    catch (Exception exception) {
                        throw new RuntimeException("No access to the default trust manager!", exception);
                    }
                }
                if (this.m_aOrgTrustManager == null) {
                    throw new RuntimeException("No access to the default trust manager!");
                }
                return this.m_aOrgTrustManager;
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return this.GetOrgTrustManager().getAcceptedIssuers();
            }

            @Override
            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
                this.GetOrgTrustManager().checkClientTrusted(x509CertificateArray, string);
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
                if (x509CertificateArray == null || x509CertificateArray.length == 0) {
                    this.GetOrgTrustManager().checkServerTrusted(x509CertificateArray, string);
                } else {
                    for (int i = 0; i < x509CertificateArray.length; ++i) {
                        x509CertificateArray[i].checkValidity();
                    }
                }
            }
        }};
        try {
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            if (sSLContext != null) {
                sSLContext.init(null, trustManagerArray, null);
                this.m_aSSLContext = sSLContext;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.m_aSSLContext == null) {
            throw new RuntimeException("failed to create SSLContext");
        }
        return this.m_aSSLContext;
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        return this.GetNotSoSecureSSLContext().getSocketFactory().createSocket(inetAddress, n);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        return this.GetNotSoSecureSSLContext().getSocketFactory().createSocket(inetAddress, n, inetAddress2, n2);
    }

    @Override
    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException, UnknownHostException {
        return this.GetNotSoSecureSSLContext().getSocketFactory().createSocket(string, n, inetAddress, n2);
    }

    @Override
    public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
        return this.GetNotSoSecureSSLContext().getSocketFactory().createSocket(string, n);
    }

    @Override
    public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException {
        return this.GetNotSoSecureSSLContext().getSocketFactory().createSocket(socket, string, n, bl);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.GetNotSoSecureSSLContext().getSocketFactory().getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.GetNotSoSecureSSLContext().getSocketFactory().getSupportedCipherSuites();
    }

    public boolean equals(Object object) {
        return object != null && object instanceof WikiProtocolSocketFactory;
    }

    public int hashCode() {
        return WikiProtocolSocketFactory.class.hashCode();
    }
}

