/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0.0lf - dvec2(-0.1lf, -1.2lf)) => dvec2(0.1lf, 1.2lf)
 * (0.0lf - dvec2(-0.42lf, 0.48lf)) => dvec2(0.42lf, -0.48lf)
 * (-1.3333333333333333lf - dvec2(-0.1lf, -1.2lf)) => dvec2(-1.2333333333333332lf, -0.1333333333333333lf)
 * (-1.3333333333333333lf - dvec2(-0.42lf, 0.48lf)) => dvec2(-0.9133333333333333lf, -1.8133333333333332lf)
 * (0.85lf - dvec2(-0.1lf, -1.2lf)) => dvec2(0.95lf, 2.05lf)
 * (0.85lf - dvec2(-0.42lf, 0.48lf)) => dvec2(1.27lf, 0.37lf)
 */
#version 400

void main()
{
  double[distance((0.0lf - dvec2(-0.1lf, -1.2lf)), dvec2(0.1lf, 1.2lf)) <= 1.2041594578792297e-05lf ? 1 : -1] array0;
  double[distance((0.0lf - dvec2(-0.42lf, 0.48lf)), dvec2(0.42lf, -0.48lf)) <= 6.378087487640791e-06lf ? 1 : -1] array1;
  double[distance((-1.3333333333333333lf - dvec2(-0.1lf, -1.2lf)), dvec2(-1.2333333333333332lf, -0.1333333333333333lf)) <= 1.2405196043952264e-05lf ? 1 : -1] array2;
  double[distance((-1.3333333333333333lf - dvec2(-0.42lf, 0.48lf)), dvec2(-0.9133333333333333lf, -1.8133333333333332lf)) <= 2.0303584795684617e-05lf ? 1 : -1] array3;
  double[distance((0.85lf - dvec2(-0.1lf, -1.2lf)), dvec2(0.95lf, 2.05lf)) <= 2.259424705539001e-05lf ? 1 : -1] array4;
  double[distance((0.85lf - dvec2(-0.42lf, 0.48lf)), dvec2(1.27lf, 0.37lf)) <= 1.322800060477773e-05lf ? 1 : -1] array5;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
