# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2021 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.nsx_policy.model.
#---------------------------------------------------------------------------

"""


"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata


class ALGTypeServiceEntry(VapiStruct):
    """
    An ServiceEntry that represents an ALG protocol

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "ALGTypeServiceEntry"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """
    ALG_ORACLE_TNS = "ORACLE_TNS"
    """


    """
    ALG_FTP = "FTP"
    """


    """
    ALG_SUN_RPC_TCP = "SUN_RPC_TCP"
    """


    """
    ALG_SUN_RPC_UDP = "SUN_RPC_UDP"
    """


    """
    ALG_MS_RPC_TCP = "MS_RPC_TCP"
    """


    """
    ALG_MS_RPC_UDP = "MS_RPC_UDP"
    """


    """
    ALG_NBNS_BROADCAST = "NBNS_BROADCAST"
    """


    """
    ALG_NBDG_BROADCAST = "NBDG_BROADCAST"
    """


    """
    ALG_TFTP = "TFTP"
    """


    """



    _canonical_to_pep_names = {
                            'alg': 'alg',
                            'destination_ports': 'destination_ports',
                            'source_ports': 'source_ports',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'relative_path': 'relative_path',
                            'unique_id': 'unique_id',
                            'children': 'children',
                            'marked_for_delete': 'marked_for_delete',
                            'overridden': 'overridden',
                            }

    def __init__(self,
                 alg=None,
                 destination_ports=None,
                 source_ports=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type='ALGTypeServiceEntry',
                 tags=None,
                 parent_path=None,
                 path=None,
                 relative_path=None,
                 unique_id=None,
                 children=None,
                 marked_for_delete=None,
                 overridden=None,
                ):
        """
        :type  alg: :class:`str` or ``None``
        :param alg: Possible values are: 
            
            * :attr:`ALGTypeServiceEntry.ALG_ORACLE_TNS`
            * :attr:`ALGTypeServiceEntry.ALG_FTP`
            * :attr:`ALGTypeServiceEntry.ALG_SUN_RPC_TCP`
            * :attr:`ALGTypeServiceEntry.ALG_SUN_RPC_UDP`
            * :attr:`ALGTypeServiceEntry.ALG_MS_RPC_TCP`
            * :attr:`ALGTypeServiceEntry.ALG_MS_RPC_UDP`
            * :attr:`ALGTypeServiceEntry.ALG_NBNS_BROADCAST`
            * :attr:`ALGTypeServiceEntry.ALG_NBDG_BROADCAST`
            * :attr:`ALGTypeServiceEntry.ALG_TFTP`
            
            The Application Layer Gateway (ALG) protocol. Please note, protocol
            NBNS_BROADCAST and NBDG_BROADCAST are deprecated. Please use UDP
            protocol and create L4 Port Set type of service instead.
        :type  destination_ports: :class:`list` of :class:`str` or ``None``
        :param destination_ports: The destination_port cannot be empty and must be a single value.
            format: port-or-range
        :type  source_ports: :class:`list` of :class:`str` or ``None``
        :param source_ports: 
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: Possible values are: 
            
            * :attr:`ServiceEntry.RESOURCE_TYPE_IPPROTOCOLSERVICEENTRY`
            * :attr:`ServiceEntry.RESOURCE_TYPE_IGMPTYPESERVICEENTRY`
            * :attr:`ServiceEntry.RESOURCE_TYPE_ICMPTYPESERVICEENTRY`
            * :attr:`ServiceEntry.RESOURCE_TYPE_ALGTYPESERVICEENTRY`
            * :attr:`ServiceEntry.RESOURCE_TYPE_L4PORTSETSERVICEENTRY`
            * :attr:`ServiceEntry.RESOURCE_TYPE_ETHERTYPESERVICEENTRY`
            * :attr:`ServiceEntry.RESOURCE_TYPE_NESTEDSERVICESERVICEENTRY`
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  unique_id: :class:`str` or ``None``
        :param unique_id: This is a UUID generated by the GM/LM to uniquely identify entites
            in a federated environment. For entities that are stretched across
            multiple sites, the same ID will be used on all the stretched
            sites.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  children: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param children: subtree for this type within policy tree containing nested
            elements.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ChildPolicyConfigResource`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`ChildPolicyConfigResource`.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: Intent objects are not directly deleted from the system when a
            delete is invoked on them. They are marked for deletion and only
            when all the realized entities for that intent object gets deleted,
            the intent object is deleted. Objects that are marked for deletion
            are not returned in GET call. One can use the search API to get
            these objects.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  overridden: :class:`bool` or ``None``
        :param overridden: Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.alg = alg
        self.destination_ports = destination_ports
        self.source_ports = source_ports
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.parent_path = parent_path
        self.path = path
        self.relative_path = relative_path
        self.unique_id = unique_id
        self.children = children
        self.marked_for_delete = marked_for_delete
        self.overridden = overridden
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ALGTypeServiceEntry._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALG_type_service_entry', {
        'alg': type.OptionalType(type.StringType()),
        'destination_ports': type.OptionalType(type.ListType(type.StringType())),
        'source_ports': type.OptionalType(type.ListType(type.StringType())),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'unique_id': type.OptionalType(type.StringType()),
        'children': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ChildPolicyConfigResource')]))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'overridden': type.OptionalType(type.BooleanType()),
    },
    ALGTypeServiceEntry,
    False,
    None))



class AbstractSpace(VapiStruct):
    """
    Represents the space in which the policy is being defined.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    CONNECTIVITY_STRATEGY_WHITELIST = "WHITELIST"
    """


    """
    CONNECTIVITY_STRATEGY_BLACKLIST = "BLACKLIST"
    """


    """
    CONNECTIVITY_STRATEGY_WHITELIST_ENABLE_LOGGING = "WHITELIST_ENABLE_LOGGING"
    """


    """
    CONNECTIVITY_STRATEGY_BLACKLIST_ENABLE_LOGGING = "BLACKLIST_ENABLE_LOGGING"
    """


    """
    CONNECTIVITY_STRATEGY_NONE = "NONE"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'relative_path': 'relative_path',
                            'unique_id': 'unique_id',
                            'children': 'children',
                            'marked_for_delete': 'marked_for_delete',
                            'overridden': 'overridden',
                            'connectivity_strategy': 'connectivity_strategy',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 parent_path=None,
                 path=None,
                 relative_path=None,
                 unique_id=None,
                 children=None,
                 marked_for_delete=None,
                 overridden=None,
                 connectivity_strategy=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  unique_id: :class:`str` or ``None``
        :param unique_id: This is a UUID generated by the GM/LM to uniquely identify entites
            in a federated environment. For entities that are stretched across
            multiple sites, the same ID will be used on all the stretched
            sites.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  children: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param children: subtree for this type within policy tree containing nested
            elements.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ChildPolicyConfigResource`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`ChildPolicyConfigResource`.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: Intent objects are not directly deleted from the system when a
            delete is invoked on them. They are marked for deletion and only
            when all the realized entities for that intent object gets deleted,
            the intent object is deleted. Objects that are marked for deletion
            are not returned in GET call. One can use the search API to get
            these objects.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  overridden: :class:`bool` or ``None``
        :param overridden: Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  connectivity_strategy: :class:`str` or ``None``
        :param connectivity_strategy: Possible values are: 
            
            * :attr:`AbstractSpace.CONNECTIVITY_STRATEGY_WHITELIST`
            * :attr:`AbstractSpace.CONNECTIVITY_STRATEGY_BLACKLIST`
            *
              :attr:`AbstractSpace.CONNECTIVITY_STRATEGY_WHITELIST_ENABLE_LOGGING`
            *
              :attr:`AbstractSpace.CONNECTIVITY_STRATEGY_BLACKLIST_ENABLE_LOGGING`
            * :attr:`AbstractSpace.CONNECTIVITY_STRATEGY_NONE`
            
            The connectivity strategy is deprecated. Use default layer3 rule,
            /infra/domains/default/security-policies/default-layer3-security-policy/rules/default-layer3-rule.
            This field indicates the default connectivity policy for the infra
            or tenant space WHITELIST - Adds a default drop rule. Administrator
            can then use \"allow\" rules (aka whitelist) to allow traffic
            between groups BLACKLIST - Adds a default allow rule. Admin can
            then use \"drop\" rules (aka blacklist) to block traffic between
            groups WHITELIST_ENABLE_LOGGING - Whitelising with logging enabled
            BLACKLIST_ENABLE_LOGGING - Blacklisting with logging enabled NONE -
            No default rules are added.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.parent_path = parent_path
        self.path = path
        self.relative_path = relative_path
        self.unique_id = unique_id
        self.children = children
        self.marked_for_delete = marked_for_delete
        self.overridden = overridden
        self.connectivity_strategy = connectivity_strategy
        VapiStruct.__init__(self)


AbstractSpace._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.abstract_space', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'unique_id': type.OptionalType(type.StringType()),
        'children': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ChildPolicyConfigResource')]))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'overridden': type.OptionalType(type.BooleanType()),
        'connectivity_strategy': type.OptionalType(type.StringType()),
    },
    AbstractSpace,
    False,
    None))



class AcceptableComponentVersion(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    COMPONENT_TYPE_HOST = "HOST"
    """


    """
    COMPONENT_TYPE_EDGE = "EDGE"
    """


    """
    COMPONENT_TYPE_CCP = "CCP"
    """


    """
    COMPONENT_TYPE_MP = "MP"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'acceptable_versions': 'acceptable_versions',
                            'component_type': 'component_type',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 acceptable_versions=None,
                 component_type=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  acceptable_versions: :class:`list` of :class:`str` or ``None``
        :param acceptable_versions: List of component versions
        :type  component_type: :class:`str` or ``None``
        :param component_type: Possible values are: 
            
            * :attr:`AcceptableComponentVersion.COMPONENT_TYPE_HOST`
            * :attr:`AcceptableComponentVersion.COMPONENT_TYPE_EDGE`
            * :attr:`AcceptableComponentVersion.COMPONENT_TYPE_CCP`
            * :attr:`AcceptableComponentVersion.COMPONENT_TYPE_MP`
            
             Node type
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.acceptable_versions = acceptable_versions
        self.component_type = component_type
        VapiStruct.__init__(self)


AcceptableComponentVersion._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.acceptable_component_version', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'acceptable_versions': type.OptionalType(type.ListType(type.StringType())),
        'component_type': type.OptionalType(type.StringType()),
    },
    AcceptableComponentVersion,
    False,
    None))



class AcceptableComponentVersionList(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'results': 'results',
                            }

    def __init__(self,
                 results=None,
                ):
        """
        :type  results: :class:`list` of :class:`AcceptableComponentVersion` or ``None``
        :param results: Acceptable version whitelist for different components
        """
        self.results = results
        VapiStruct.__init__(self)


AcceptableComponentVersionList._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.acceptable_component_version_list', {
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'AcceptableComponentVersion'))),
    },
    AcceptableComponentVersionList,
    False,
    None))



class Action(VapiStruct):
    """
    Reaction Action is the action to take when the stipulated criteria
    specified in the event exist over the source. Some example actions include:
    - Notify Admin (or VMC's SRE) via email. - Populate a specific label with
    the IPSec VPN Session. - Remove the IPSec VPN Session from a specific
    label.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "Action"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """
    RESOURCE_TYPE_PATCHRESOURCES = "PatchResources"
    """


    """
    RESOURCE_TYPE_SETFIELDS = "SetFields"
    """


    """



    _canonical_to_pep_names = {
                            'resource_type': 'resource_type',
                            }

    def __init__(self,
                 resource_type='Action',
                ):
        """
        :type  resource_type: :class:`str`
        :param resource_type: Possible values are: 
            
            * :attr:`Action.RESOURCE_TYPE_PATCHRESOURCES`
            * :attr:`Action.RESOURCE_TYPE_SETFIELDS`
            
             Reaction Action resource type.
        """
        self._resource_type = resource_type
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

Action._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.action', {
        'resource_type': type.StringType(),
    },
    Action,
    False,
    None))



class ActionableResource(VapiStruct):
    """
    Resources managed during restore process

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'ip_address': 'ip_address',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 ip_address=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  ip_address: :class:`str` or ``None``
        :param ip_address: A resource reference on which actions can be performed format:
            hostname-or-ip
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.ip_address = ip_address
        VapiStruct.__init__(self)


ActionableResource._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.actionable_resource', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'ip_address': type.OptionalType(type.StringType()),
    },
    ActionableResource,
    False,
    None))



class ActionableResourceListResult(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`ActionableResource` or ``None``
        :param results: List results
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


ActionableResourceListResult._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.actionable_resource_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ActionableResource'))),
    },
    ActionableResourceListResult,
    False,
    None))



class ActiveDirectoryIdentitySource(VapiStruct):
    """
    An identity source service that runs Microsoft Active Directory. The
    service allows selected user accounts defined in Active Directory to log
    into and access NSX-T.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "ActiveDirectoryIdentitySource"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'alternative_domain_names': 'alternative_domain_names',
                            'base_dn': 'base_dn',
                            'domain_name': 'domain_name',
                            'ldap_servers': 'ldap_servers',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type='ActiveDirectoryIdentitySource',
                 tags=None,
                 alternative_domain_names=None,
                 base_dn=None,
                 domain_name=None,
                 ldap_servers=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: Possible values are: 
            
            *
              :attr:`LdapIdentitySource.RESOURCE_TYPE_ACTIVEDIRECTORYIDENTITYSOURCE`
            * :attr:`LdapIdentitySource.RESOURCE_TYPE_OPENLDAPIDENTITYSOURCE`
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  alternative_domain_names: :class:`list` of :class:`str` or ``None``
        :param alternative_domain_names: After parsing the \"user\\\\@domain\", the domain portion is used
            to select the LDAP identity source to use. Additional domains
            listed here will also be directed to this LDAP identity source. In
            Active Directory these are sometimes referred to as Alternative UPN
            Suffixes.
        :type  base_dn: :class:`str` or ``None``
        :param base_dn: The subtree of the LDAP identity source to search when locating
            users and groups.
        :type  domain_name: :class:`str` or ``None``
        :param domain_name: The name of the authentication domain. When users log into NSX
            using an identity of the form \"user\\\\@domain\", NSX uses the
            domain portion to determine which LDAP identity source to use.
        :type  ldap_servers: :class:`list` of :class:`IdentitySourceLdapServer` or ``None``
        :param ldap_servers: The list of LDAP servers that provide LDAP service for this
            identity source. Currently, only one LDAP server is supported.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.alternative_domain_names = alternative_domain_names
        self.base_dn = base_dn
        self.domain_name = domain_name
        self.ldap_servers = ldap_servers
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ActiveDirectoryIdentitySource._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.active_directory_identity_source', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'alternative_domain_names': type.OptionalType(type.ListType(type.StringType())),
        'base_dn': type.OptionalType(type.StringType()),
        'domain_name': type.OptionalType(type.StringType()),
        'ldap_servers': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'IdentitySourceLdapServer'))),
    },
    ActiveDirectoryIdentitySource,
    False,
    None))



class AdvanceClusterRestoreInput(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'id': 'id',
                            'resources': 'resources',
                            }

    def __init__(self,
                 id=None,
                 resources=None,
                ):
        """
        :type  id: :class:`str` or ``None``
        :param id: Unique id of an instruction (as returned by the GET /restore/status
            call) for which input is to be provided
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  resources: :class:`list` of :class:`SelectableResourceReference` or ``None``
        :param resources: List of resources for which the instruction is applicable.
        """
        self.id = id
        self.resources = resources
        VapiStruct.__init__(self)


AdvanceClusterRestoreInput._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.advance_cluster_restore_input', {
        'id': type.OptionalType(type.StringType()),
        'resources': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'SelectableResourceReference'))),
    },
    AdvanceClusterRestoreInput,
    False,
    None))



class AdvanceClusterRestoreRequest(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'data': 'data',
                            }

    def __init__(self,
                 data=None,
                ):
        """
        :type  data: :class:`list` of :class:`AdvanceClusterRestoreInput` or ``None``
        :param data: List of instructions and their associated data
        """
        self.data = data
        VapiStruct.__init__(self)


AdvanceClusterRestoreRequest._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.advance_cluster_restore_request', {
        'data': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'AdvanceClusterRestoreInput'))),
    },
    AdvanceClusterRestoreRequest,
    False,
    None))



class AggregateDNSForwarderStatistics(VapiStruct):
    """
    Aggregate of DNS forwarder statistics across enforcement points.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'intent_path': 'intent_path',
                            'statistics_per_enforcement_point': 'statistics_per_enforcement_point',
                            }

    def __init__(self,
                 intent_path=None,
                 statistics_per_enforcement_point=None,
                ):
        """
        :type  intent_path: :class:`str` or ``None``
        :param intent_path: String path of the DNS forwarder intent.
        :type  statistics_per_enforcement_point: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param statistics_per_enforcement_point: List of DNS forwarder statistics per enforcement point.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`DNSForwarderStatisticsPerEnforcementPoint`. When methods
            return a value of this class as a return value, the attribute will
            contain all the attributes defined in
            :class:`DNSForwarderStatisticsPerEnforcementPoint`.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.intent_path = intent_path
        self.statistics_per_enforcement_point = statistics_per_enforcement_point
        VapiStruct.__init__(self)


AggregateDNSForwarderStatistics._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.aggregate_DNS_forwarder_statistics', {
        'intent_path': type.OptionalType(type.StringType()),
        'statistics_per_enforcement_point': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'DNSForwarderStatisticsPerEnforcementPoint')]))),
    },
    AggregateDNSForwarderStatistics,
    False,
    None))



class AggregateDNSForwarderStatus(VapiStruct):
    """
    Aggregate of DNS forwarder status across enforcement points.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'intent_path': 'intent_path',
                            'status_per_enforcement_point': 'status_per_enforcement_point',
                            }

    def __init__(self,
                 intent_path=None,
                 status_per_enforcement_point=None,
                ):
        """
        :type  intent_path: :class:`str` or ``None``
        :param intent_path: String path of the DNS forwarder intent.
        :type  status_per_enforcement_point: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param status_per_enforcement_point: List of DNS forwarder status per enforcement point.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`DNSForwarderStatusPerEnforcementPoint`. When methods return
            a value of this class as a return value, the attribute will contain
            all the attributes defined in
            :class:`DNSForwarderStatusPerEnforcementPoint`.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.intent_path = intent_path
        self.status_per_enforcement_point = status_per_enforcement_point
        VapiStruct.__init__(self)


AggregateDNSForwarderStatus._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.aggregate_DNS_forwarder_status', {
        'intent_path': type.OptionalType(type.StringType()),
        'status_per_enforcement_point': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'DNSForwarderStatusPerEnforcementPoint')]))),
    },
    AggregateDNSForwarderStatus,
    False,
    None))



class AggregateIPSecVpnSessionStatistics(VapiStruct):
    """
    Aggregate of IPSec VPN Session Statistics across Enforcement Points.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'intent_path': 'intent_path',
                            'results': 'results',
                            }

    def __init__(self,
                 intent_path=None,
                 results=None,
                ):
        """
        :type  intent_path: :class:`str` or ``None``
        :param intent_path: Intent path of object, forward slashes must be escaped using %2F.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param results: List of IPSec VPN Session Statistics per Enforcement Point.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`IPSecVpnSessionStatisticsPerEP`. When methods return a
            value of this class as a return value, the attribute will contain
            all the attributes defined in
            :class:`IPSecVpnSessionStatisticsPerEP`.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.intent_path = intent_path
        self.results = results
        VapiStruct.__init__(self)


AggregateIPSecVpnSessionStatistics._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.aggregate_IP_sec_vpn_session_statistics', {
        'intent_path': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'IPSecVpnSessionStatisticsPerEP')]))),
    },
    AggregateIPSecVpnSessionStatistics,
    False,
    None))



class AggregateIPSecVpnSessionStatus(VapiStruct):
    """
    Aggregate of IPSec VPN Session Status across Enforcement Points.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'intent_path': 'intent_path',
                            'results': 'results',
                            }

    def __init__(self,
                 intent_path=None,
                 results=None,
                ):
        """
        :type  intent_path: :class:`str` or ``None``
        :param intent_path: Intent path of object, forward slashes must be escaped using %2F.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param results: List of IPSec VPN Session Status per Enforcement Point.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`IPSecVpnSessionStatusPerEP`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`IPSecVpnSessionStatusPerEP`.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.intent_path = intent_path
        self.results = results
        VapiStruct.__init__(self)


AggregateIPSecVpnSessionStatus._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.aggregate_IP_sec_vpn_session_status', {
        'intent_path': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'IPSecVpnSessionStatusPerEP')]))),
    },
    AggregateIPSecVpnSessionStatus,
    False,
    None))



class AggregateL2VPNSessionPeerConfig(VapiStruct):
    """
    Aggregate of L2VPN Session peer config across Enforcement Points.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'intent_path': 'intent_path',
                            'results': 'results',
                            }

    def __init__(self,
                 intent_path=None,
                 results=None,
                ):
        """
        :type  intent_path: :class:`str` or ``None``
        :param intent_path: Intent path of object, forward slashes must be escaped using %2F.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param results: List of L2VPN Session peer config per Enforcement Point.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`L2VPNSessionPeerConfigPerEP`. When methods return a value
            of this class as a return value, the attribute will contain all the
            attributes defined in :class:`L2VPNSessionPeerConfigPerEP`.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.intent_path = intent_path
        self.results = results
        VapiStruct.__init__(self)


AggregateL2VPNSessionPeerConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.aggregate_l2_VPN_session_peer_config', {
        'intent_path': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'L2VPNSessionPeerConfigPerEP')]))),
    },
    AggregateL2VPNSessionPeerConfig,
    False,
    None))



class AggregateL2VPNSessionStatistics(VapiStruct):
    """
    Aggregate of L2VPN Session Statistics across Enforcement Points.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'intent_path': 'intent_path',
                            'results': 'results',
                            }

    def __init__(self,
                 intent_path=None,
                 results=None,
                ):
        """
        :type  intent_path: :class:`str` or ``None``
        :param intent_path: Intent path of object, forward slashes must be escaped using %2F.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param results: List of L2VPN Session Statistics per Enforcement Point.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`L2VPNSessionStatisticsPerEP`. When methods return a value
            of this class as a return value, the attribute will contain all the
            attributes defined in :class:`L2VPNSessionStatisticsPerEP`.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.intent_path = intent_path
        self.results = results
        VapiStruct.__init__(self)


AggregateL2VPNSessionStatistics._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.aggregate_l2_VPN_session_statistics', {
        'intent_path': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'L2VPNSessionStatisticsPerEP')]))),
    },
    AggregateL2VPNSessionStatistics,
    False,
    None))



class AggregateL2VPNSessionStatus(VapiStruct):
    """
    Aggregate of L2VPN Session Status across Enforcement Points.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'intent_path': 'intent_path',
                            'results': 'results',
                            }

    def __init__(self,
                 intent_path=None,
                 results=None,
                ):
        """
        :type  intent_path: :class:`str` or ``None``
        :param intent_path: Intent path of object, forward slashes must be escaped using %2F.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param results: List of L2VPN Session Status per Enforcement Point.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`L2VPNSessionStatusPerEP`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`L2VPNSessionStatusPerEP`.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.intent_path = intent_path
        self.results = results
        VapiStruct.__init__(self)


AggregateL2VPNSessionStatus._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.aggregate_l2_VPN_session_status', {
        'intent_path': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'L2VPNSessionStatusPerEP')]))),
    },
    AggregateL2VPNSessionStatus,
    False,
    None))



class AggregateL2VpnPeerConfig(VapiStruct):
    """
    Aggregate of L2Vpn peer config across Enforcement Points.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'l2vpn_path': 'l2vpn_path',
                            'l2vpn_peer_config_per_enforcement_point': 'l2vpn_peer_config_per_enforcement_point',
                            }

    def __init__(self,
                 l2vpn_path=None,
                 l2vpn_peer_config_per_enforcement_point=None,
                ):
        """
        :type  l2vpn_path: :class:`str` or ``None``
        :param l2vpn_path: Policy path referencing the L2Vpn.
        :type  l2vpn_peer_config_per_enforcement_point: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param l2vpn_peer_config_per_enforcement_point: List of L2Vpn peer config per Enforcement Point.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`L2VpnPeerConfigPerEnforcementPoint`. When methods return a
            value of this class as a return value, the attribute will contain
            all the attributes defined in
            :class:`L2VpnPeerConfigPerEnforcementPoint`.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.l2vpn_path = l2vpn_path
        self.l2vpn_peer_config_per_enforcement_point = l2vpn_peer_config_per_enforcement_point
        VapiStruct.__init__(self)


AggregateL2VpnPeerConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.aggregate_l2_vpn_peer_config', {
        'l2vpn_path': type.OptionalType(type.StringType()),
        'l2vpn_peer_config_per_enforcement_point': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'L2VpnPeerConfigPerEnforcementPoint')]))),
    },
    AggregateL2VpnPeerConfig,
    False,
    None))



class AggregateL2VpnSessionRemoteMac(VapiStruct):
    """
    Aggregate of L2Vpn session remote mac across enforcement points.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'intent_path': 'intent_path',
                            'l2vpn_session_remote_macs': 'l2vpn_session_remote_macs',
                            }

    def __init__(self,
                 intent_path=None,
                 l2vpn_session_remote_macs=None,
                ):
        """
        :type  intent_path: :class:`str` or ``None``
        :param intent_path: Intent path of object, forward slashes must be escaped using %2F.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  l2vpn_session_remote_macs: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param l2vpn_session_remote_macs: List of L2Vpn Session remote mac
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`L2VpnSessionRemoteMacPerEP`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`L2VpnSessionRemoteMacPerEP`.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.intent_path = intent_path
        self.l2vpn_session_remote_macs = l2vpn_session_remote_macs
        VapiStruct.__init__(self)


AggregateL2VpnSessionRemoteMac._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.aggregate_l2_vpn_session_remote_mac', {
        'intent_path': type.OptionalType(type.StringType()),
        'l2vpn_session_remote_macs': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'L2VpnSessionRemoteMacPerEP')]))),
    },
    AggregateL2VpnSessionRemoteMac,
    False,
    None))



class AggregateL2VpnStatistics(VapiStruct):
    """
    Aggregate of L2Vpn Statistics across Enforcement Points.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'intent_path': 'intent_path',
                            'l2vpn_statistics_per_enforcement_point': 'l2vpn_statistics_per_enforcement_point',
                            }

    def __init__(self,
                 intent_path=None,
                 l2vpn_statistics_per_enforcement_point=None,
                ):
        """
        :type  intent_path: :class:`str` or ``None``
        :param intent_path: Intent path of object, forward slashes must be escaped using %2F.
        :type  l2vpn_statistics_per_enforcement_point: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param l2vpn_statistics_per_enforcement_point: List of L2Vpn Statistics per Enforcement Point.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`L2VpnStatisticsPerEnforcementPoint`. When methods return a
            value of this class as a return value, the attribute will contain
            all the attributes defined in
            :class:`L2VpnStatisticsPerEnforcementPoint`.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.intent_path = intent_path
        self.l2vpn_statistics_per_enforcement_point = l2vpn_statistics_per_enforcement_point
        VapiStruct.__init__(self)


AggregateL2VpnStatistics._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.aggregate_l2_vpn_statistics', {
        'intent_path': type.OptionalType(type.StringType()),
        'l2vpn_statistics_per_enforcement_point': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'L2VpnStatisticsPerEnforcementPoint')]))),
    },
    AggregateL2VpnStatistics,
    False,
    None))



class AggregateL3VpnStatistics(VapiStruct):
    """
    Aggregate of L3Vpn Statistics across Enforcement Points.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'intent_path': 'intent_path',
                            'l3vpn_statistics_per_enforcement_point': 'l3vpn_statistics_per_enforcement_point',
                            }

    def __init__(self,
                 intent_path=None,
                 l3vpn_statistics_per_enforcement_point=None,
                ):
        """
        :type  intent_path: :class:`str` or ``None``
        :param intent_path: Intent path of object, forward slashes must be escaped using %2F.
        :type  l3vpn_statistics_per_enforcement_point: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param l3vpn_statistics_per_enforcement_point: List of L3Vpn Statistics per Enforcement Point.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`L3VpnStatisticsPerEnforcementPoint`. When methods return a
            value of this class as a return value, the attribute will contain
            all the attributes defined in
            :class:`L3VpnStatisticsPerEnforcementPoint`.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.intent_path = intent_path
        self.l3vpn_statistics_per_enforcement_point = l3vpn_statistics_per_enforcement_point
        VapiStruct.__init__(self)


AggregateL3VpnStatistics._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.aggregate_l3_vpn_statistics', {
        'intent_path': type.OptionalType(type.StringType()),
        'l3vpn_statistics_per_enforcement_point': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'L3VpnStatisticsPerEnforcementPoint')]))),
    },
    AggregateL3VpnStatistics,
    False,
    None))



class AggregateLBNodeUsageSummary(VapiStruct):
    """
    Aggregate of LBNodeUsageSummary across Enforcement Points.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'intent_path': 'intent_path',
                            'results': 'results',
                            }

    def __init__(self,
                 intent_path=None,
                 results=None,
                ):
        """
        :type  intent_path: :class:`str` or ``None``
        :param intent_path: Intent path of object, forward slashes must be escaped using %2F.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`LBNodeUsageSummary` or ``None``
        :param results: LBNodeUsageSummary list results.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.intent_path = intent_path
        self.results = results
        VapiStruct.__init__(self)


AggregateLBNodeUsageSummary._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.aggregate_LB_node_usage_summary', {
        'intent_path': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'LBNodeUsageSummary'))),
    },
    AggregateLBNodeUsageSummary,
    False,
    None))



class AggregateLBPoolStatistics(VapiStruct):
    """
    Paged Collection of LBPoolStatisticsPerEP

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'intent_path': 'intent_path',
                            'results': 'results',
                            }

    def __init__(self,
                 intent_path=None,
                 results=None,
                ):
        """
        :type  intent_path: :class:`str` or ``None``
        :param intent_path: Intent path of object, forward slashes must be escaped using %2F.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param results: LBPoolStatisticsPerEP list results.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`LBPoolStatisticsPerEP`. When methods return a value of this
            class as a return value, the attribute will contain all the
            attributes defined in :class:`LBPoolStatisticsPerEP`.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.intent_path = intent_path
        self.results = results
        VapiStruct.__init__(self)


AggregateLBPoolStatistics._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.aggregate_LB_pool_statistics', {
        'intent_path': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'LBPoolStatisticsPerEP')]))),
    },
    AggregateLBPoolStatistics,
    False,
    None))



class AggregateLBPoolStatus(VapiStruct):
    """
    Paged Collection of LBPoolStatusPerEP

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'intent_path': 'intent_path',
                            'results': 'results',
                            }

    def __init__(self,
                 intent_path=None,
                 results=None,
                ):
        """
        :type  intent_path: :class:`str` or ``None``
        :param intent_path: Intent path of object, forward slashes must be escaped using %2F.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param results: LBPoolStatusPerEP list results.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`LBPoolStatusPerEP`. When methods return a value of this
            class as a return value, the attribute will contain all the
            attributes defined in :class:`LBPoolStatusPerEP`.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.intent_path = intent_path
        self.results = results
        VapiStruct.__init__(self)


AggregateLBPoolStatus._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.aggregate_LB_pool_status', {
        'intent_path': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'LBPoolStatusPerEP')]))),
    },
    AggregateLBPoolStatus,
    False,
    None))



class AggregateLBServiceStatistics(VapiStruct):
    """
    Paged Collection of LBServiceStatisticsPerEP

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'intent_path': 'intent_path',
                            'results': 'results',
                            }

    def __init__(self,
                 intent_path=None,
                 results=None,
                ):
        """
        :type  intent_path: :class:`str` or ``None``
        :param intent_path: Intent path of object, forward slashes must be escaped using %2F.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param results: LBServiceStatisticsPerEP list results.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`LBServiceStatisticsPerEP`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`LBServiceStatisticsPerEP`.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.intent_path = intent_path
        self.results = results
        VapiStruct.__init__(self)


AggregateLBServiceStatistics._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.aggregate_LB_service_statistics', {
        'intent_path': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'LBServiceStatisticsPerEP')]))),
    },
    AggregateLBServiceStatistics,
    False,
    None))



class AggregateLBServiceStatus(VapiStruct):
    """
    Paged Collection of LBServiceStatusPerEP

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'intent_path': 'intent_path',
                            'results': 'results',
                            }

    def __init__(self,
                 intent_path=None,
                 results=None,
                ):
        """
        :type  intent_path: :class:`str` or ``None``
        :param intent_path: Intent path of object, forward slashes must be escaped using %2F.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param results: LBServiceStatusPerEP list results.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`LBServiceStatusPerEP`. When methods return a value of this
            class as a return value, the attribute will contain all the
            attributes defined in :class:`LBServiceStatusPerEP`.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.intent_path = intent_path
        self.results = results
        VapiStruct.__init__(self)


AggregateLBServiceStatus._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.aggregate_LB_service_status', {
        'intent_path': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'LBServiceStatusPerEP')]))),
    },
    AggregateLBServiceStatus,
    False,
    None))



class AggregateLBServiceUsage(VapiStruct):
    """
    Aggregate of LBServiceUsagePerEP across Enforcement Points.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'intent_path': 'intent_path',
                            'results': 'results',
                            }

    def __init__(self,
                 intent_path=None,
                 results=None,
                ):
        """
        :type  intent_path: :class:`str` or ``None``
        :param intent_path: Intent path of object, forward slashes must be escaped using %2F.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param results: LBServiceUsagePerEP list results.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`LBServiceUsagePerEP`. When methods return a value of this
            class as a return value, the attribute will contain all the
            attributes defined in :class:`LBServiceUsagePerEP`.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.intent_path = intent_path
        self.results = results
        VapiStruct.__init__(self)


AggregateLBServiceUsage._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.aggregate_LB_service_usage', {
        'intent_path': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'LBServiceUsagePerEP')]))),
    },
    AggregateLBServiceUsage,
    False,
    None))



class AggregateLBVirtualServerStatistics(VapiStruct):
    """
    Paged Collection of LBVirtualServerStatisticsPerEP

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'intent_path': 'intent_path',
                            'results': 'results',
                            }

    def __init__(self,
                 intent_path=None,
                 results=None,
                ):
        """
        :type  intent_path: :class:`str` or ``None``
        :param intent_path: Intent path of object, forward slashes must be escaped using %2F.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param results: LBVirtualServerStatisticsPerEP list results.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`LBVirtualServerStatisticsPerEP`. When methods return a
            value of this class as a return value, the attribute will contain
            all the attributes defined in
            :class:`LBVirtualServerStatisticsPerEP`.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.intent_path = intent_path
        self.results = results
        VapiStruct.__init__(self)


AggregateLBVirtualServerStatistics._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.aggregate_LB_virtual_server_statistics', {
        'intent_path': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'LBVirtualServerStatisticsPerEP')]))),
    },
    AggregateLBVirtualServerStatistics,
    False,
    None))



class AggregateLBVirtualServerStatus(VapiStruct):
    """
    Paged Collection of LBVirtualServerStatusPerEP

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'intent_path': 'intent_path',
                            'results': 'results',
                            }

    def __init__(self,
                 intent_path=None,
                 results=None,
                ):
        """
        :type  intent_path: :class:`str` or ``None``
        :param intent_path: Intent path of object, forward slashes must be escaped using %2F.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param results: LBVirtualServerStatusPerEP list results.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`LBVirtualServerStatusPerEP`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`LBVirtualServerStatusPerEP`.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.intent_path = intent_path
        self.results = results
        VapiStruct.__init__(self)


AggregateLBVirtualServerStatus._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.aggregate_LB_virtual_server_status', {
        'intent_path': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'LBVirtualServerStatusPerEP')]))),
    },
    AggregateLBVirtualServerStatus,
    False,
    None))



class AggregatePolicyDnsAnswer(VapiStruct):
    """
    Aggregate of DNS forwarder nslookup answer across enforcement points.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'dns_answer_per_enforcement_point': 'dns_answer_per_enforcement_point',
                            'intent_path': 'intent_path',
                            }

    def __init__(self,
                 dns_answer_per_enforcement_point=None,
                 intent_path=None,
                ):
        """
        :type  dns_answer_per_enforcement_point: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param dns_answer_per_enforcement_point: List of DNS forwarder nslookup answer per enforcement point.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`PolicyDnsAnswerPerEnforcementPoint`. When methods return a
            value of this class as a return value, the attribute will contain
            all the attributes defined in
            :class:`PolicyDnsAnswerPerEnforcementPoint`.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  intent_path: :class:`str` or ``None``
        :param intent_path: String path of the DNS forwarder intent.
        """
        self.dns_answer_per_enforcement_point = dns_answer_per_enforcement_point
        self.intent_path = intent_path
        VapiStruct.__init__(self)


AggregatePolicyDnsAnswer._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.aggregate_policy_dns_answer', {
        'dns_answer_per_enforcement_point': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'PolicyDnsAnswerPerEnforcementPoint')]))),
        'intent_path': type.OptionalType(type.StringType()),
    },
    AggregatePolicyDnsAnswer,
    False,
    None))



class AggregatePolicyRuntimeInfo(VapiStruct):
    """
    Aggregate of PolicyRuntimeInfoPerEP across Enforcement Points.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'intent_path': 'intent_path',
                            }

    def __init__(self,
                 intent_path=None,
                ):
        """
        :type  intent_path: :class:`str` or ``None``
        :param intent_path: Intent path of object, forward slashes must be escaped using %2F.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.intent_path = intent_path
        VapiStruct.__init__(self)


AggregatePolicyRuntimeInfo._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.aggregate_policy_runtime_info', {
        'intent_path': type.OptionalType(type.StringType()),
    },
    AggregatePolicyRuntimeInfo,
    False,
    None))



class AggregatedDataCounter(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'rx_bytes': 'rx_bytes',
                            'rx_packets': 'rx_packets',
                            'tx_bytes': 'tx_bytes',
                            'tx_packets': 'tx_packets',
                            }

    def __init__(self,
                 rx_bytes=None,
                 rx_packets=None,
                 tx_bytes=None,
                 tx_packets=None,
                ):
        """
        :type  rx_bytes: :class:`DataCounter` or ``None``
        :param rx_bytes: 
        :type  rx_packets: :class:`DataCounter` or ``None``
        :param rx_packets: 
        :type  tx_bytes: :class:`DataCounter` or ``None``
        :param tx_bytes: 
        :type  tx_packets: :class:`DataCounter` or ``None``
        :param tx_packets: 
        """
        self.rx_bytes = rx_bytes
        self.rx_packets = rx_packets
        self.tx_bytes = tx_bytes
        self.tx_packets = tx_packets
        VapiStruct.__init__(self)


AggregatedDataCounter._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.aggregated_data_counter', {
        'rx_bytes': type.OptionalType(type.ReferenceType(__name__, 'DataCounter')),
        'rx_packets': type.OptionalType(type.ReferenceType(__name__, 'DataCounter')),
        'tx_bytes': type.OptionalType(type.ReferenceType(__name__, 'DataCounter')),
        'tx_packets': type.OptionalType(type.ReferenceType(__name__, 'DataCounter')),
    },
    AggregatedDataCounter,
    False,
    None))



class AggregatedDataCounterEx(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'rx_bytes': 'rx_bytes',
                            'rx_packets': 'rx_packets',
                            'tx_bytes': 'tx_bytes',
                            'tx_packets': 'tx_packets',
                            'dropped_by_security_packets': 'dropped_by_security_packets',
                            'mac_learning': 'mac_learning',
                            }

    def __init__(self,
                 rx_bytes=None,
                 rx_packets=None,
                 tx_bytes=None,
                 tx_packets=None,
                 dropped_by_security_packets=None,
                 mac_learning=None,
                ):
        """
        :type  rx_bytes: :class:`DataCounter` or ``None``
        :param rx_bytes: 
        :type  rx_packets: :class:`DataCounter` or ``None``
        :param rx_packets: 
        :type  tx_bytes: :class:`DataCounter` or ``None``
        :param tx_bytes: 
        :type  tx_packets: :class:`DataCounter` or ``None``
        :param tx_packets: 
        :type  dropped_by_security_packets: :class:`PacketsDroppedBySecurity` or ``None``
        :param dropped_by_security_packets: 
        :type  mac_learning: :class:`MacLearningCounters` or ``None``
        :param mac_learning: 
        """
        self.rx_bytes = rx_bytes
        self.rx_packets = rx_packets
        self.tx_bytes = tx_bytes
        self.tx_packets = tx_packets
        self.dropped_by_security_packets = dropped_by_security_packets
        self.mac_learning = mac_learning
        VapiStruct.__init__(self)


AggregatedDataCounterEx._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.aggregated_data_counter_ex', {
        'rx_bytes': type.OptionalType(type.ReferenceType(__name__, 'DataCounter')),
        'rx_packets': type.OptionalType(type.ReferenceType(__name__, 'DataCounter')),
        'tx_bytes': type.OptionalType(type.ReferenceType(__name__, 'DataCounter')),
        'tx_packets': type.OptionalType(type.ReferenceType(__name__, 'DataCounter')),
        'dropped_by_security_packets': type.OptionalType(type.ReferenceType(__name__, 'PacketsDroppedBySecurity')),
        'mac_learning': type.OptionalType(type.ReferenceType(__name__, 'MacLearningCounters')),
    },
    AggregatedDataCounterEx,
    False,
    None))



class AggregatedLogicalRouterPortCounters(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'last_update_timestamp': 'last_update_timestamp',
                            'rx': 'rx',
                            'tx': 'tx',
                            }

    def __init__(self,
                 last_update_timestamp=None,
                 rx=None,
                 tx=None,
                ):
        """
        :type  last_update_timestamp: :class:`long` or ``None``
        :param last_update_timestamp: Timestamp when the data was last updated; unset if data source has
            never updated the data. format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  rx: :class:`LogicalRouterPortCounters` or ``None``
        :param rx: 
        :type  tx: :class:`LogicalRouterPortCounters` or ``None``
        :param tx: 
        """
        self.last_update_timestamp = last_update_timestamp
        self.rx = rx
        self.tx = tx
        VapiStruct.__init__(self)


AggregatedLogicalRouterPortCounters._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.aggregated_logical_router_port_counters', {
        'last_update_timestamp': type.OptionalType(type.IntegerType()),
        'rx': type.OptionalType(type.ReferenceType(__name__, 'LogicalRouterPortCounters')),
        'tx': type.OptionalType(type.ReferenceType(__name__, 'LogicalRouterPortCounters')),
    },
    AggregatedLogicalRouterPortCounters,
    False,
    None))



class ApiError(VapiStruct):
    """
    Detailed information about an API Error

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'details': 'details',
                            'error_code': 'error_code',
                            'error_data': 'error_data',
                            'error_message': 'error_message',
                            'module_name': 'module_name',
                            'related_errors': 'related_errors',
                            }

    def __init__(self,
                 details=None,
                 error_code=None,
                 error_data=None,
                 error_message=None,
                 module_name=None,
                 related_errors=None,
                ):
        """
        :type  details: :class:`str` or ``None``
        :param details: Further details about the error
        :type  error_code: :class:`long` or ``None``
        :param error_code: A numeric error code format: int64
        :type  error_data: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param error_data: Additional data about the error
        :type  error_message: :class:`str` or ``None``
        :param error_message: A description of the error
        :type  module_name: :class:`str` or ``None``
        :param module_name: The module name where the error occurred
        :type  related_errors: :class:`list` of :class:`RelatedApiError` or ``None``
        :param related_errors: Other errors related to this error
        """
        self.details = details
        self.error_code = error_code
        self.error_data = error_data
        self.error_message = error_message
        self.module_name = module_name
        self.related_errors = related_errors
        VapiStruct.__init__(self)


ApiError._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.api_error', {
        'details': type.OptionalType(type.StringType()),
        'error_code': type.OptionalType(type.IntegerType()),
        'error_data': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct)),
        'error_message': type.OptionalType(type.StringType()),
        'module_name': type.OptionalType(type.StringType()),
        'related_errors': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'RelatedApiError'))),
    },
    ApiError,
    False,
    None))



class ApiRequestBody(VapiStruct):
    """
    API Request Body is an Event Source that represents an API request body
    that is being reveived as part of an API. Supported Request Bodies are
    those received as part of a PATCH/PUT/POST request.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "ApiRequestBody"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """



    _canonical_to_pep_names = {
                            'resource_pointer': 'resource_pointer',
                            'resource_type': 'resource_type',
                            }

    def __init__(self,
                 resource_pointer=None,
                 resource_type='ApiRequestBody',
                ):
        """
        :type  resource_pointer: :class:`str` or ``None``
        :param resource_pointer: Regex path representing a regex expression on resources. This regex
            is used to identify the request body(ies) that is/are the source of
            the Event. For instance: specifying \"Lb\* |
            /infra/tier-0s/vmc/ipsec-vpn-services/default\" as a source means
            that ANY resource starting with Lb or ANY resource with
            \"/infra/tier-0s/vmc/ipsec-vpn-services/default\" as path would be
            the source of the event in question.
        :type  resource_type: :class:`str`
        :param resource_type: Possible values are: 
            
            * :attr:`Source.RESOURCE_TYPE_RESOURCEOPERATION`
            * :attr:`Source.RESOURCE_TYPE_APIREQUESTBODY`
            
             Event Source resource type.
        """
        self.resource_pointer = resource_pointer
        self._resource_type = resource_type
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ApiRequestBody._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.api_request_body', {
        'resource_pointer': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
    },
    ApiRequestBody,
    False,
    None))



class Application(VapiStruct):
    """
    Application is a collection of Tiers where every tier shares common
    Security and networking requirements. Application API exposes self service
    model of consumption.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'relative_path': 'relative_path',
                            'unique_id': 'unique_id',
                            'children': 'children',
                            'marked_for_delete': 'marked_for_delete',
                            'overridden': 'overridden',
                            'sites': 'sites',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 parent_path=None,
                 path=None,
                 relative_path=None,
                 unique_id=None,
                 children=None,
                 marked_for_delete=None,
                 overridden=None,
                 sites=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  unique_id: :class:`str` or ``None``
        :param unique_id: This is a UUID generated by the GM/LM to uniquely identify entites
            in a federated environment. For entities that are stretched across
            multiple sites, the same ID will be used on all the stretched
            sites.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  children: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param children: subtree for this type within policy tree containing nested
            elements.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ChildPolicyConfigResource`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`ChildPolicyConfigResource`.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: Intent objects are not directly deleted from the system when a
            delete is invoked on them. They are marked for deletion and only
            when all the realized entities for that intent object gets deleted,
            the intent object is deleted. Objects that are marked for deletion
            are not returned in GET call. One can use the search API to get
            these objects.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  overridden: :class:`bool` or ``None``
        :param overridden: Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sites: :class:`list` of :class:`str` or ``None``
        :param sites: Path of the sites
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.parent_path = parent_path
        self.path = path
        self.relative_path = relative_path
        self.unique_id = unique_id
        self.children = children
        self.marked_for_delete = marked_for_delete
        self.overridden = overridden
        self.sites = sites
        VapiStruct.__init__(self)


Application._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.application', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'unique_id': type.OptionalType(type.StringType()),
        'children': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ChildPolicyConfigResource')]))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'overridden': type.OptionalType(type.BooleanType()),
        'sites': type.OptionalType(type.ListType(type.StringType())),
    },
    Application,
    False,
    None))



class ApplicationService(VapiStruct):
    """
    Networking and Security policy for Application.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'relative_path': 'relative_path',
                            'unique_id': 'unique_id',
                            'children': 'children',
                            'marked_for_delete': 'marked_for_delete',
                            'overridden': 'overridden',
                            'attributes': 'attributes',
                            'service_template_id': 'service_template_id',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 parent_path=None,
                 path=None,
                 relative_path=None,
                 unique_id=None,
                 children=None,
                 marked_for_delete=None,
                 overridden=None,
                 attributes=None,
                 service_template_id=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  unique_id: :class:`str` or ``None``
        :param unique_id: This is a UUID generated by the GM/LM to uniquely identify entites
            in a federated environment. For entities that are stretched across
            multiple sites, the same ID will be used on all the stretched
            sites.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  children: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param children: subtree for this type within policy tree containing nested
            elements.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ChildPolicyConfigResource`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`ChildPolicyConfigResource`.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: Intent objects are not directly deleted from the system when a
            delete is invoked on them. They are marked for deletion and only
            when all the realized entities for that intent object gets deleted,
            the intent object is deleted. Objects that are marked for deletion
            are not returned in GET call. One can use the search API to get
            these objects.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  overridden: :class:`bool` or ``None``
        :param overridden: Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  attributes: :class:`list` of :class:`ApplicationServiceAttribute` or ``None``
        :param attributes: Property containing attributes for Policy Application Service.
        :type  service_template_id: :class:`str` or ``None``
        :param service_template_id: Application Service template id using which Application Service
            will be created. This will be available under the application
            service templates.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.parent_path = parent_path
        self.path = path
        self.relative_path = relative_path
        self.unique_id = unique_id
        self.children = children
        self.marked_for_delete = marked_for_delete
        self.overridden = overridden
        self.attributes = attributes
        self.service_template_id = service_template_id
        VapiStruct.__init__(self)


ApplicationService._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.application_service', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'unique_id': type.OptionalType(type.StringType()),
        'children': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ChildPolicyConfigResource')]))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'overridden': type.OptionalType(type.BooleanType()),
        'attributes': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ApplicationServiceAttribute'))),
        'service_template_id': type.OptionalType(type.StringType()),
    },
    ApplicationService,
    False,
    None))



class ApplicationServiceAttribute(VapiStruct):
    """
    Policy Application Service data holder

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'key_value': 'key_value',
                            }

    def __init__(self,
                 key_value=None,
                ):
        """
        :type  key_value: :class:`KeyValuePair` or ``None``
        :param key_value: Key value pair that will be used while deploying application
            service template.
        """
        self.key_value = key_value
        VapiStruct.__init__(self)


ApplicationServiceAttribute._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.application_service_attribute', {
        'key_value': type.OptionalType(type.ReferenceType(__name__, 'KeyValuePair')),
    },
    ApplicationServiceAttribute,
    False,
    None))



class ApplicationTier(VapiStruct):
    """
    A 'tier' is a set of workloads that share common networking and security
    services. Tiers provide a specific function for an application and are thus
    a collection of compute with their associated services.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    ACCESS_TYPE_PUBLIC = "Public"
    """


    """
    ACCESS_TYPE_PRIVATE = "Private"
    """


    """
    ACCESS_TYPE_SHARED = "Shared"
    """


    """
    SIZE_ONE = "ONE"
    """


    """
    SIZE_XXS = "XXS"
    """


    """
    SIZE_XS = "XS"
    """


    """
    SIZE_S = "S"
    """


    """
    SIZE_M = "M"
    """


    """
    SIZE_L = "L"
    """


    """
    SIZE_XL = "XL"
    """


    """
    SIZE_XXL = "XXL"
    """


    """
    SIZE_XXXL = "XXXL"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'relative_path': 'relative_path',
                            'unique_id': 'unique_id',
                            'children': 'children',
                            'marked_for_delete': 'marked_for_delete',
                            'overridden': 'overridden',
                            'access_type': 'access_type',
                            'ip_range': 'ip_range',
                            'size': 'size',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 parent_path=None,
                 path=None,
                 relative_path=None,
                 unique_id=None,
                 children=None,
                 marked_for_delete=None,
                 overridden=None,
                 access_type=None,
                 ip_range=None,
                 size=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  unique_id: :class:`str` or ``None``
        :param unique_id: This is a UUID generated by the GM/LM to uniquely identify entites
            in a federated environment. For entities that are stretched across
            multiple sites, the same ID will be used on all the stretched
            sites.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  children: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param children: subtree for this type within policy tree containing nested
            elements.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ChildPolicyConfigResource`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`ChildPolicyConfigResource`.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: Intent objects are not directly deleted from the system when a
            delete is invoked on them. They are marked for deletion and only
            when all the realized entities for that intent object gets deleted,
            the intent object is deleted. Objects that are marked for deletion
            are not returned in GET call. One can use the search API to get
            these objects.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  overridden: :class:`bool` or ``None``
        :param overridden: Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  access_type: :class:`str` or ``None``
        :param access_type: Possible values are: 
            
            * :attr:`ApplicationTier.ACCESS_TYPE_PUBLIC`
            * :attr:`ApplicationTier.ACCESS_TYPE_PRIVATE`
            * :attr:`ApplicationTier.ACCESS_TYPE_SHARED`
            
            There are three kinds of Access Types supported for an Application.
            Public - Tier is accessible from external networks and its IP is
            picked up from public IP addresses from VHC configuration unless
            specified explicitly by user. Private - Tier is accessbile only
            within the application and its IP is picked up from private IP
            addresses from VHC configuration unless specified explicitly by
            user. Shared - Tier is accessible within the scope of VHC and its
            IP is picked up from private IP addresses from VHC configuration
            unless specified explicitly by user.
        :type  ip_range: :class:`str` or ``None``
        :param ip_range: This represents the subnet that is associated with tier. If this is
            specified, size property is ignored. format: ip-cidr-block
        :type  size: :class:`str` or ``None``
        :param size: Possible values are: 
            
            * :attr:`ApplicationTier.SIZE_ONE`
            * :attr:`ApplicationTier.SIZE_XXS`
            * :attr:`ApplicationTier.SIZE_XS`
            * :attr:`ApplicationTier.SIZE_S`
            * :attr:`ApplicationTier.SIZE_M`
            * :attr:`ApplicationTier.SIZE_L`
            * :attr:`ApplicationTier.SIZE_XL`
            * :attr:`ApplicationTier.SIZE_XXL`
            * :attr:`ApplicationTier.SIZE_XXXL`
            
            ONE - 1 XXS - 8 XS - 16 S - 32 M - 64 L - 128 XL - 256 XXL - 512
            XXXL - 1024
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.parent_path = parent_path
        self.path = path
        self.relative_path = relative_path
        self.unique_id = unique_id
        self.children = children
        self.marked_for_delete = marked_for_delete
        self.overridden = overridden
        self.access_type = access_type
        self.ip_range = ip_range
        self.size = size
        VapiStruct.__init__(self)


ApplicationTier._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.application_tier', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'unique_id': type.OptionalType(type.StringType()),
        'children': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ChildPolicyConfigResource')]))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'overridden': type.OptionalType(type.BooleanType()),
        'access_type': type.OptionalType(type.StringType()),
        'ip_range': type.OptionalType(type.StringType()),
        'size': type.OptionalType(type.StringType()),
    },
    ApplicationTier,
    False,
    None))



class ArpHeader(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    OP_CODE_REQUEST = "ARP_REQUEST"
    """


    """
    OP_CODE_REPLY = "ARP_REPLY"
    """


    """



    _canonical_to_pep_names = {
                            'dst_ip': 'dst_ip',
                            'op_code': 'op_code',
                            'src_ip': 'src_ip',
                            }

    def __init__(self,
                 dst_ip=None,
                 op_code=None,
                 src_ip=None,
                ):
        """
        :type  dst_ip: :class:`str` or ``None``
        :param dst_ip: The destination IP address format: ipv4
        :type  op_code: :class:`str` or ``None``
        :param op_code: Possible values are: 
            
            * :attr:`ArpHeader.OP_CODE_REQUEST`
            * :attr:`ArpHeader.OP_CODE_REPLY`
            
             This field specifies the nature of the Arp message being sent.
        :type  src_ip: :class:`str` or ``None``
        :param src_ip: This field specifies the IP address of the sender. If omitted, the
            src_ip is set to 0.0.0.0. format: ipv4
        """
        self.dst_ip = dst_ip
        self.op_code = op_code
        self.src_ip = src_ip
        VapiStruct.__init__(self)


ArpHeader._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.arp_header', {
        'dst_ip': type.OptionalType(type.StringType()),
        'op_code': type.OptionalType(type.StringType()),
        'src_ip': type.OptionalType(type.StringType()),
    },
    ArpHeader,
    False,
    None))



class ArpSnoopingConfig(VapiStruct):
    """
    Contains ARP snooping related configuration.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'arp_binding_limit': 'arp_binding_limit',
                            'arp_snooping_enabled': 'arp_snooping_enabled',
                            }

    def __init__(self,
                 arp_binding_limit=None,
                 arp_snooping_enabled=None,
                ):
        """
        :type  arp_binding_limit: :class:`long` or ``None``
        :param arp_binding_limit: Number of arp snooped IP addresses Indicates the number of arp
            snooped IP addresses to be remembered per LogicalPort. Decreasing
            this value, will retain the latest bindings from the existing list
            of address bindings. Increasing this value will retain existing
            bindings and also learn any new address bindings discovered on the
            port until the new limit is reached. format: int32
        :type  arp_snooping_enabled: :class:`bool` or ``None``
        :param arp_snooping_enabled: Indicates whether ARP snooping is enabled
        """
        self.arp_binding_limit = arp_binding_limit
        self.arp_snooping_enabled = arp_snooping_enabled
        VapiStruct.__init__(self)


ArpSnoopingConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.arp_snooping_config', {
        'arp_binding_limit': type.OptionalType(type.IntegerType()),
        'arp_snooping_enabled': type.OptionalType(type.BooleanType()),
    },
    ArpSnoopingConfig,
    False,
    None))



class Attribute(VapiStruct):
    """
    Attribute specific to a partner. There attributes are passed on to the
    partner appliance and is opaque to the NSX Manager. The Attributes used by
    the partner applicance.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    ATTRIBUTE_TYPE_IP_ADDRESS = "IP_ADDRESS"
    """


    """
    ATTRIBUTE_TYPE_PORT = "PORT"
    """


    """
    ATTRIBUTE_TYPE_PASSWORD = "PASSWORD"
    """


    """
    ATTRIBUTE_TYPE_STRING = "STRING"
    """


    """
    ATTRIBUTE_TYPE_LONG = "LONG"
    """


    """
    ATTRIBUTE_TYPE_BOOLEAN = "BOOLEAN"
    """


    """



    _canonical_to_pep_names = {
                            'attribute_type': 'attribute_type',
                            'display_name': 'display_name',
                            'key': 'key',
                            'read_only': 'read_only',
                            'value': 'value',
                            }

    def __init__(self,
                 attribute_type=None,
                 display_name=None,
                 key=None,
                 read_only=None,
                 value=None,
                ):
        """
        :type  attribute_type: :class:`str` or ``None``
        :param attribute_type: Possible values are: 
            
            * :attr:`Attribute.ATTRIBUTE_TYPE_IP_ADDRESS`
            * :attr:`Attribute.ATTRIBUTE_TYPE_PORT`
            * :attr:`Attribute.ATTRIBUTE_TYPE_PASSWORD`
            * :attr:`Attribute.ATTRIBUTE_TYPE_STRING`
            * :attr:`Attribute.ATTRIBUTE_TYPE_LONG`
            * :attr:`Attribute.ATTRIBUTE_TYPE_BOOLEAN`
            
             Attribute Type can be of any of the allowed enum type.
        :type  display_name: :class:`str` or ``None``
        :param display_name: Attribute display name string value.
        :type  key: :class:`str` or ``None``
        :param key: Attribute key string value.
        :type  read_only: :class:`bool` or ``None``
        :param read_only: Read only Attribute cannot be overdidden by service
            instance/deployment.
        :type  value: :class:`str` or ``None``
        :param value: Attribute value string value.
        """
        self.attribute_type = attribute_type
        self.display_name = display_name
        self.key = key
        self.read_only = read_only
        self.value = value
        VapiStruct.__init__(self)


Attribute._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.attribute', {
        'attribute_type': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'key': type.OptionalType(type.StringType()),
        'read_only': type.OptionalType(type.BooleanType()),
        'value': type.OptionalType(type.StringType()),
    },
    Attribute,
    False,
    None))



class AttributeVal(VapiStruct):
    """
    Contains type specific properties of generic realized entity

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    DATA_TYPE_STRING = "STRING"
    """


    """
    DATA_TYPE_DATE = "DATE"
    """


    """
    DATA_TYPE_INTEGER = "INTEGER"
    """


    """
    DATA_TYPE_BOOLEAN = "BOOLEAN"
    """


    """



    _canonical_to_pep_names = {
                            'data_type': 'data_type',
                            'key': 'key',
                            'multivalue': 'multivalue',
                            'values': 'values',
                            }

    def __init__(self,
                 data_type=None,
                 key=None,
                 multivalue=None,
                 values=None,
                ):
        """
        :type  data_type: :class:`str` or ``None``
        :param data_type: Possible values are: 
            
            * :attr:`AttributeVal.DATA_TYPE_STRING`
            * :attr:`AttributeVal.DATA_TYPE_DATE`
            * :attr:`AttributeVal.DATA_TYPE_INTEGER`
            * :attr:`AttributeVal.DATA_TYPE_BOOLEAN`
            
             Datatype of the property
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  key: :class:`str` or ``None``
        :param key: Attribute key
        :type  multivalue: :class:`bool` or ``None``
        :param multivalue: If attribute has a single value or collection of values
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  values: :class:`list` of :class:`str` or ``None``
        :param values: List of attribute values
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.data_type = data_type
        self.key = key
        self.multivalue = multivalue
        self.values = values
        VapiStruct.__init__(self)


AttributeVal._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.attribute_val', {
        'data_type': type.OptionalType(type.StringType()),
        'key': type.OptionalType(type.StringType()),
        'multivalue': type.OptionalType(type.BooleanType()),
        'values': type.OptionalType(type.ListType(type.StringType())),
    },
    AttributeVal,
    False,
    None))



class Axes(VapiStruct):
    """
    Represents X and Y axes of a graph. For a multi-graph, the same axes are
    shared by all the graphs.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'x_label': 'x_label',
                            'y_label': 'y_label',
                            }

    def __init__(self,
                 x_label=None,
                 y_label=None,
                ):
        """
        :type  x_label: :class:`Label` or ``None``
        :param x_label: Label for X axis of a graph
        :type  y_label: :class:`Label` or ``None``
        :param y_label: Label for Y axis of a graph
        """
        self.x_label = x_label
        self.y_label = y_label
        VapiStruct.__init__(self)


Axes._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.axes', {
        'x_label': type.OptionalType(type.ReferenceType(__name__, 'Label')),
        'y_label': type.OptionalType(type.ReferenceType(__name__, 'Label')),
    },
    Axes,
    False,
    None))



class BackupConfiguration(VapiStruct):
    """
    Configuration for taking manual/automated backup

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'after_inventory_update_interval': 'after_inventory_update_interval',
                            'backup_enabled': 'backup_enabled',
                            'backup_schedule': 'backup_schedule',
                            'inventory_summary_interval': 'inventory_summary_interval',
                            'passphrase': 'passphrase',
                            'remote_file_server': 'remote_file_server',
                            }

    def __init__(self,
                 after_inventory_update_interval=None,
                 backup_enabled=None,
                 backup_schedule=None,
                 inventory_summary_interval=None,
                 passphrase=None,
                 remote_file_server=None,
                ):
        """
        :type  after_inventory_update_interval: :class:`long` or ``None``
        :param after_inventory_update_interval: A number of seconds after a last backup, that needs to pass, before
            a topology change will trigger a generation of a new cluster/node
            backups. If parameter is not provided, then changes in a topology
            will not trigger a generation of cluster/node backups. format:
            int64
        :type  backup_enabled: :class:`bool` or ``None``
        :param backup_enabled: true if automated backup is enabled
        :type  backup_schedule: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param backup_schedule: Set when backups should be taken - on a weekly schedule or at
            regular intervals.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`BackupSchedule`. When methods return a value of this class
            as a return value, the attribute will contain all the attributes
            defined in :class:`BackupSchedule`.
        :type  inventory_summary_interval: :class:`long` or ``None``
        :param inventory_summary_interval: The minimum number of seconds between each upload of the inventory
            summary to backup server. format: int64
        :type  passphrase: :class:`str` or ``None``
        :param passphrase: Passphrase used to encrypt backup files. The passphrase specified
            must be at least 8 characters in length and must contain at least
            one lowercase, one uppercase, one numeric character and one special
            character (any other non-space character).
        :type  remote_file_server: :class:`RemoteFileServer` or ``None``
        :param remote_file_server: The server to which backups will be sent.
        """
        self.after_inventory_update_interval = after_inventory_update_interval
        self.backup_enabled = backup_enabled
        self.backup_schedule = backup_schedule
        self.inventory_summary_interval = inventory_summary_interval
        self.passphrase = passphrase
        self.remote_file_server = remote_file_server
        VapiStruct.__init__(self)


BackupConfiguration._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.backup_configuration', {
        'after_inventory_update_interval': type.OptionalType(type.IntegerType()),
        'backup_enabled': type.OptionalType(type.BooleanType()),
        'backup_schedule': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'BackupSchedule')])),
        'inventory_summary_interval': type.OptionalType(type.IntegerType()),
        'passphrase': type.OptionalType(type.StringType()),
        'remote_file_server': type.OptionalType(type.ReferenceType(__name__, 'RemoteFileServer')),
    },
    BackupConfiguration,
    False,
    None))



class BackupOperationHistory(VapiStruct):
    """
    Past backup operation details

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'cluster_backup_statuses': 'cluster_backup_statuses',
                            'inventory_backup_statuses': 'inventory_backup_statuses',
                            'node_backup_statuses': 'node_backup_statuses',
                            }

    def __init__(self,
                 cluster_backup_statuses=None,
                 inventory_backup_statuses=None,
                 node_backup_statuses=None,
                ):
        """
        :type  cluster_backup_statuses: :class:`list` of :class:`BackupOperationStatus` or ``None``
        :param cluster_backup_statuses: Statuses of previous cluser backups
        :type  inventory_backup_statuses: :class:`list` of :class:`BackupOperationStatus` or ``None``
        :param inventory_backup_statuses: Statuses of previous inventory backups
        :type  node_backup_statuses: :class:`list` of :class:`BackupOperationStatus` or ``None``
        :param node_backup_statuses: Statuses of previous node backups
        """
        self.cluster_backup_statuses = cluster_backup_statuses
        self.inventory_backup_statuses = inventory_backup_statuses
        self.node_backup_statuses = node_backup_statuses
        VapiStruct.__init__(self)


BackupOperationHistory._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.backup_operation_history', {
        'cluster_backup_statuses': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'BackupOperationStatus'))),
        'inventory_backup_statuses': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'BackupOperationStatus'))),
        'node_backup_statuses': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'BackupOperationStatus'))),
    },
    BackupOperationHistory,
    False,
    None))



class BackupOperationStatus(VapiStruct):
    """
    Backup operation status

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    ERROR_CODE_NOT_RUN_ON_MASTER = "BACKUP_NOT_RUN_ON_MASTER"
    """


    """
    ERROR_CODE_SERVER_UNREACHABLE = "BACKUP_SERVER_UNREACHABLE"
    """


    """
    ERROR_CODE_AUTHENTICATION_FAILURE = "BACKUP_AUTHENTICATION_FAILURE"
    """


    """
    ERROR_CODE_PERMISSION_ERROR = "BACKUP_PERMISSION_ERROR"
    """


    """
    ERROR_CODE_TIMEOUT = "BACKUP_TIMEOUT"
    """


    """
    ERROR_CODE_BAD_FINGERPRINT = "BACKUP_BAD_FINGERPRINT"
    """


    """
    ERROR_CODE_GENERIC_ERROR = "BACKUP_GENERIC_ERROR"
    """


    """



    _canonical_to_pep_names = {
                            'backup_id': 'backup_id',
                            'end_time': 'end_time',
                            'error_code': 'error_code',
                            'error_message': 'error_message',
                            'start_time': 'start_time',
                            'success': 'success',
                            }

    def __init__(self,
                 backup_id=None,
                 end_time=None,
                 error_code=None,
                 error_message=None,
                 start_time=None,
                 success=None,
                ):
        """
        :type  backup_id: :class:`str` or ``None``
        :param backup_id: Unique identifier of a backup
        :type  end_time: :class:`long` or ``None``
        :param end_time: Time when operation was ended format: int64
        :type  error_code: :class:`str` or ``None``
        :param error_code: Possible values are: 
            
            * :attr:`BackupOperationStatus.ERROR_CODE_NOT_RUN_ON_MASTER`
            * :attr:`BackupOperationStatus.ERROR_CODE_SERVER_UNREACHABLE`
            * :attr:`BackupOperationStatus.ERROR_CODE_AUTHENTICATION_FAILURE`
            * :attr:`BackupOperationStatus.ERROR_CODE_PERMISSION_ERROR`
            * :attr:`BackupOperationStatus.ERROR_CODE_TIMEOUT`
            * :attr:`BackupOperationStatus.ERROR_CODE_BAD_FINGERPRINT`
            * :attr:`BackupOperationStatus.ERROR_CODE_GENERIC_ERROR`
            
             Error code
        :type  error_message: :class:`str` or ``None``
        :param error_message: Error code details
        :type  start_time: :class:`long` or ``None``
        :param start_time: Time when operation was started format: int64
        :type  success: :class:`bool` or ``None``
        :param success: True if backup is successfully completed, else false
        """
        self.backup_id = backup_id
        self.end_time = end_time
        self.error_code = error_code
        self.error_message = error_message
        self.start_time = start_time
        self.success = success
        VapiStruct.__init__(self)


BackupOperationStatus._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.backup_operation_status', {
        'backup_id': type.OptionalType(type.StringType()),
        'end_time': type.OptionalType(type.IntegerType()),
        'error_code': type.OptionalType(type.StringType()),
        'error_message': type.OptionalType(type.StringType()),
        'start_time': type.OptionalType(type.IntegerType()),
        'success': type.OptionalType(type.BooleanType()),
    },
    BackupOperationStatus,
    False,
    None))



class BackupOverview(VapiStruct):
    """
    Data for a single backup/restore card

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            'backup_config': 'backup_config',
                            'backup_operation_history': 'backup_operation_history',
                            'current_backup_operation_status': 'current_backup_operation_status',
                            'restore_status': 'restore_status',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                 backup_config=None,
                 backup_operation_history=None,
                 current_backup_operation_status=None,
                 restore_status=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`ClusterBackupInfo` or ``None``
        :param results: List of timestamps of backed-up cluster files
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  backup_config: :class:`BackupConfiguration` or ``None``
        :param backup_config: Configuration to generate a manual/automated backup
        :type  backup_operation_history: :class:`BackupOperationHistory` or ``None``
        :param backup_operation_history: Status of the last backup execution per component
        :type  current_backup_operation_status: :class:`CurrentBackupOperationStatus` or ``None``
        :param current_backup_operation_status: Backup status decribes type, phase, success/failure and time of a |
            latest backup execution
        :type  restore_status: :class:`ClusterRestoreStatus` or ``None``
        :param restore_status: Status of restore process executing/executed on appliance
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        self.backup_config = backup_config
        self.backup_operation_history = backup_operation_history
        self.current_backup_operation_status = current_backup_operation_status
        self.restore_status = restore_status
        VapiStruct.__init__(self)


BackupOverview._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.backup_overview', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ClusterBackupInfo'))),
        'backup_config': type.OptionalType(type.ReferenceType(__name__, 'BackupConfiguration')),
        'backup_operation_history': type.OptionalType(type.ReferenceType(__name__, 'BackupOperationHistory')),
        'current_backup_operation_status': type.OptionalType(type.ReferenceType(__name__, 'CurrentBackupOperationStatus')),
        'restore_status': type.OptionalType(type.ReferenceType(__name__, 'ClusterRestoreStatus')),
    },
    BackupOverview,
    False,
    None))



class BackupSchedule(VapiStruct):
    """
    Abstract base type for Weekly or Interval Backup Schedule

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "BackupSchedule"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """
    RESOURCE_TYPE_WEEKLYBACKUPSCHEDULE = "WeeklyBackupSchedule"
    """


    """
    RESOURCE_TYPE_INTERVALBACKUPSCHEDULE = "IntervalBackupSchedule"
    """


    """



    _canonical_to_pep_names = {
                            'resource_type': 'resource_type',
                            }

    def __init__(self,
                 resource_type='BackupSchedule',
                ):
        """
        :type  resource_type: :class:`str`
        :param resource_type: Possible values are: 
            
            * :attr:`BackupSchedule.RESOURCE_TYPE_WEEKLYBACKUPSCHEDULE`
            * :attr:`BackupSchedule.RESOURCE_TYPE_INTERVALBACKUPSCHEDULE`
            
             Schedule type
        """
        self._resource_type = resource_type
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

BackupSchedule._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.backup_schedule', {
        'resource_type': type.StringType(),
    },
    BackupSchedule,
    False,
    None))



class BaseConsolidatedStatusPerEnforcementPoint(VapiStruct):
    """
    Consolidated Realized Status Per Enforcement Point.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "BaseConsolidatedStatusPerEnforcementPoint"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """



    _canonical_to_pep_names = {
                            'alarm': 'alarm',
                            'enforcement_point_path': 'enforcement_point_path',
                            'consolidated_status': 'consolidated_status',
                            'enforcement_point_id': 'enforcement_point_id',
                            'resource_type': 'resource_type',
                            'site_path': 'site_path',
                            }

    def __init__(self,
                 alarm=None,
                 enforcement_point_path=None,
                 consolidated_status=None,
                 enforcement_point_id=None,
                 resource_type='BaseConsolidatedStatusPerEnforcementPoint',
                 site_path=None,
                ):
        """
        :type  alarm: :class:`PolicyRuntimeAlarm` or ``None``
        :param alarm: Alarm information details.
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: Policy Path referencing the enforcement point where the info is
            fetched.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  consolidated_status: :class:`ConsolidatedStatus` or ``None``
        :param consolidated_status: Consolidated Realized Status of an Intent object per enforcement
            point.
        :type  enforcement_point_id: :class:`str` or ``None``
        :param enforcement_point_id: Enforcement Point Id.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  site_path: :class:`str` or ``None``
        :param site_path: The site where this enforcement point resides.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.alarm = alarm
        self.enforcement_point_path = enforcement_point_path
        self.consolidated_status = consolidated_status
        self.enforcement_point_id = enforcement_point_id
        self._resource_type = resource_type
        self.site_path = site_path
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

BaseConsolidatedStatusPerEnforcementPoint._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.base_consolidated_status_per_enforcement_point', {
        'alarm': type.OptionalType(type.ReferenceType(__name__, 'PolicyRuntimeAlarm')),
        'enforcement_point_path': type.OptionalType(type.StringType()),
        'consolidated_status': type.OptionalType(type.ReferenceType(__name__, 'ConsolidatedStatus')),
        'enforcement_point_id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'site_path': type.OptionalType(type.StringType()),
    },
    BaseConsolidatedStatusPerEnforcementPoint,
    False,
    None))



class BaseEndpoint(VapiStruct):
    """
    Represents an endpoint which will be used as subject in rule. It is a
    polymorphic type object which can be either of the types - 1. Virtual 2.
    Logical We have 2 separate objects representing these 2 types.
    VirtualEndPoint for Virtual type and ServiceInstanceEndpoint for Logical.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "BaseEndpoint"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """
    RESOURCE_TYPE_VIRTUALENDPOINT = "VirtualEndpoint"
    """


    """
    RESOURCE_TYPE_SERVICEINSTANCEENDPOINT = "ServiceInstanceEndpoint"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'relative_path': 'relative_path',
                            'unique_id': 'unique_id',
                            'children': 'children',
                            'marked_for_delete': 'marked_for_delete',
                            'overridden': 'overridden',
                            'target_ips': 'target_ips',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type='BaseEndpoint',
                 tags=None,
                 parent_path=None,
                 path=None,
                 relative_path=None,
                 unique_id=None,
                 children=None,
                 marked_for_delete=None,
                 overridden=None,
                 target_ips=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: Possible values are: 
            
            * :attr:`BaseEndpoint.RESOURCE_TYPE_VIRTUALENDPOINT`
            * :attr:`BaseEndpoint.RESOURCE_TYPE_SERVICEINSTANCEENDPOINT`
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  unique_id: :class:`str` or ``None``
        :param unique_id: This is a UUID generated by the GM/LM to uniquely identify entites
            in a federated environment. For entities that are stretched across
            multiple sites, the same ID will be used on all the stretched
            sites.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  children: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param children: subtree for this type within policy tree containing nested
            elements.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ChildPolicyConfigResource`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`ChildPolicyConfigResource`.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: Intent objects are not directly deleted from the system when a
            delete is invoked on them. They are marked for deletion and only
            when all the realized entities for that intent object gets deleted,
            the intent object is deleted. Objects that are marked for deletion
            are not returned in GET call. One can use the search API to get
            these objects.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  overridden: :class:`bool` or ``None``
        :param overridden: Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  target_ips: :class:`list` of :class:`IPInfo` or ``None``
        :param target_ips: IPs where either inbound or outbound traffic is to be redirected.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.parent_path = parent_path
        self.path = path
        self.relative_path = relative_path
        self.unique_id = unique_id
        self.children = children
        self.marked_for_delete = marked_for_delete
        self.overridden = overridden
        self.target_ips = target_ips
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

BaseEndpoint._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.base_endpoint', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'unique_id': type.OptionalType(type.StringType()),
        'children': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ChildPolicyConfigResource')]))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'overridden': type.OptionalType(type.BooleanType()),
        'target_ips': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'IPInfo'))),
    },
    BaseEndpoint,
    False,
    None))



class BasePolicyServiceInstance(VapiStruct):
    """
    Represents an instance of partner Service and its configuration.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    DEPLOYMENT_MODE_STAND_ALONE = "STAND_ALONE"
    """


    """
    DEPLOYMENT_MODE_ACTIVE_STANDBY = "ACTIVE_STANDBY"
    """


    """
    TRANSPORT_TYPE_L2_BRIDGE = "L2_BRIDGE"
    """


    """
    TRANSPORT_TYPE_L3_ROUTED = "L3_ROUTED"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'relative_path': 'relative_path',
                            'unique_id': 'unique_id',
                            'children': 'children',
                            'marked_for_delete': 'marked_for_delete',
                            'overridden': 'overridden',
                            'deployment_mode': 'deployment_mode',
                            'partner_service_name': 'partner_service_name',
                            'transport_type': 'transport_type',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 parent_path=None,
                 path=None,
                 relative_path=None,
                 unique_id=None,
                 children=None,
                 marked_for_delete=None,
                 overridden=None,
                 deployment_mode=None,
                 partner_service_name=None,
                 transport_type=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  unique_id: :class:`str` or ``None``
        :param unique_id: This is a UUID generated by the GM/LM to uniquely identify entites
            in a federated environment. For entities that are stretched across
            multiple sites, the same ID will be used on all the stretched
            sites.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  children: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param children: subtree for this type within policy tree containing nested
            elements.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ChildPolicyConfigResource`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`ChildPolicyConfigResource`.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: Intent objects are not directly deleted from the system when a
            delete is invoked on them. They are marked for deletion and only
            when all the realized entities for that intent object gets deleted,
            the intent object is deleted. Objects that are marked for deletion
            are not returned in GET call. One can use the search API to get
            these objects.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  overridden: :class:`bool` or ``None``
        :param overridden: Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  deployment_mode: :class:`str` or ``None``
        :param deployment_mode: Possible values are: 
            
            * :attr:`BasePolicyServiceInstance.DEPLOYMENT_MODE_STAND_ALONE`
            * :attr:`BasePolicyServiceInstance.DEPLOYMENT_MODE_ACTIVE_STANDBY`
            
            Deployment mode specifies how the partner appliance will be
            deployed i.e. in HA or standalone mode.
        :type  partner_service_name: :class:`str` or ``None``
        :param partner_service_name: Unique name of Partner Service in the Marketplace
        :type  transport_type: :class:`str` or ``None``
        :param transport_type: Possible values are: 
            
            * :attr:`BasePolicyServiceInstance.TRANSPORT_TYPE_L2_BRIDGE`
            * :attr:`BasePolicyServiceInstance.TRANSPORT_TYPE_L3_ROUTED`
            
             Transport to be used while deploying Service-VM.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.parent_path = parent_path
        self.path = path
        self.relative_path = relative_path
        self.unique_id = unique_id
        self.children = children
        self.marked_for_delete = marked_for_delete
        self.overridden = overridden
        self.deployment_mode = deployment_mode
        self.partner_service_name = partner_service_name
        self.transport_type = transport_type
        VapiStruct.__init__(self)


BasePolicyServiceInstance._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.base_policy_service_instance', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'unique_id': type.OptionalType(type.StringType()),
        'children': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ChildPolicyConfigResource')]))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'overridden': type.OptionalType(type.BooleanType()),
        'deployment_mode': type.OptionalType(type.StringType()),
        'partner_service_name': type.OptionalType(type.StringType()),
        'transport_type': type.OptionalType(type.StringType()),
    },
    BasePolicyServiceInstance,
    False,
    None))



class BaseRule(VapiStruct):
    """
    A rule indicates the action to be performed for various types of traffic
    flowing between workload groups.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    DIRECTION_IN = "IN"
    """


    """
    DIRECTION_OUT = "OUT"
    """


    """
    DIRECTION_IN_OUT = "IN_OUT"
    """


    """
    IP_PROTOCOL_IPV4 = "IPV4"
    """


    """
    IP_PROTOCOL_IPV6 = "IPV6"
    """


    """
    IP_PROTOCOL_IPV4_IPV6 = "IPV4_IPV6"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'relative_path': 'relative_path',
                            'unique_id': 'unique_id',
                            'children': 'children',
                            'marked_for_delete': 'marked_for_delete',
                            'overridden': 'overridden',
                            'destination_groups': 'destination_groups',
                            'destinations_excluded': 'destinations_excluded',
                            'direction': 'direction',
                            'disabled': 'disabled',
                            'ip_protocol': 'ip_protocol',
                            'is_default': 'is_default',
                            'logged': 'logged',
                            'notes': 'notes',
                            'profiles': 'profiles',
                            'rule_id': 'rule_id',
                            'scope': 'scope',
                            'sequence_number': 'sequence_number',
                            'service_entries': 'service_entries',
                            'services': 'services',
                            'source_groups': 'source_groups',
                            'sources_excluded': 'sources_excluded',
                            'tag': 'tag',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 parent_path=None,
                 path=None,
                 relative_path=None,
                 unique_id=None,
                 children=None,
                 marked_for_delete=None,
                 overridden=None,
                 destination_groups=None,
                 destinations_excluded=None,
                 direction=None,
                 disabled=None,
                 ip_protocol=None,
                 is_default=None,
                 logged=None,
                 notes=None,
                 profiles=None,
                 rule_id=None,
                 scope=None,
                 sequence_number=None,
                 service_entries=None,
                 services=None,
                 source_groups=None,
                 sources_excluded=None,
                 tag=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  unique_id: :class:`str` or ``None``
        :param unique_id: This is a UUID generated by the GM/LM to uniquely identify entites
            in a federated environment. For entities that are stretched across
            multiple sites, the same ID will be used on all the stretched
            sites.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  children: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param children: subtree for this type within policy tree containing nested
            elements.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ChildPolicyConfigResource`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`ChildPolicyConfigResource`.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: Intent objects are not directly deleted from the system when a
            delete is invoked on them. They are marked for deletion and only
            when all the realized entities for that intent object gets deleted,
            the intent object is deleted. Objects that are marked for deletion
            are not returned in GET call. One can use the search API to get
            these objects.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  overridden: :class:`bool` or ``None``
        :param overridden: Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  destination_groups: :class:`list` of :class:`str` or ``None``
        :param destination_groups: We need paths as duplicate names may exist for groups under
            different domains. Along with paths we support IP Address of type
            IPv4 and IPv6. IP Address can be in one of the format(CIDR, IP
            Address, Range of IP Address). In order to specify all groups, use
            the constant \"ANY\". This is case insensitive. If \"ANY\" is used,
            it should be the ONLY element in the group array. Error will be
            thrown if ANY is used in conjunction with other values.
        :type  destinations_excluded: :class:`bool` or ``None``
        :param destinations_excluded: If set to true, the rule gets applied on all the groups that are
            NOT part of the destination groups. If false, the rule applies to
            the destination groups
        :type  direction: :class:`str` or ``None``
        :param direction: Possible values are: 
            
            * :attr:`BaseRule.DIRECTION_IN`
            * :attr:`BaseRule.DIRECTION_OUT`
            * :attr:`BaseRule.DIRECTION_IN_OUT`
            
             Define direction of traffic.
        :type  disabled: :class:`bool` or ``None``
        :param disabled: Flag to disable the rule. Default is enabled.
        :type  ip_protocol: :class:`str` or ``None``
        :param ip_protocol: Possible values are: 
            
            * :attr:`BaseRule.IP_PROTOCOL_IPV4`
            * :attr:`BaseRule.IP_PROTOCOL_IPV6`
            * :attr:`BaseRule.IP_PROTOCOL_IPV4_IPV6`
            
            Type of IP packet that should be matched while enforcing the rule.
            The value is set to IPV4_IPV6 for Layer3 rule if not specified. For
            Layer2/Ether rule the value must be null.
        :type  is_default: :class:`bool` or ``None``
        :param is_default: A flag to indicate whether rule is a default rule.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  logged: :class:`bool` or ``None``
        :param logged: Flag to enable packet logging. Default is disabled.
        :type  notes: :class:`str` or ``None``
        :param notes: Text for additional notes on changes.
        :type  profiles: :class:`list` of :class:`str` or ``None``
        :param profiles: Holds the list of layer 7 service profile paths. These profiles
            accept attributes and sub-attributes of various network services
            (e.g. L4 AppId, encryption algorithm, domain name, etc) as key
            value pairs.
        :type  rule_id: :class:`long` or ``None``
        :param rule_id: This is a unique 4 byte positive number that is assigned by the
            system. This rule id is passed all the way down to the data path.
            The first 1GB (1000 to 2^30) will be shared by GM and LM with zebra
            style striped number space. For E.g 1000 to (1Million -1) by LM,
            (1M - 2M-1) by GM and so on. format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  scope: :class:`list` of :class:`str` or ``None``
        :param scope: The list of policy paths where the rule is applied
            LR/Edge/T0/T1/LRP etc. Note that a given rule can be applied on
            multiple LRs/LRPs.
        :type  sequence_number: :class:`long` or ``None``
        :param sequence_number: This field is used to resolve conflicts between multiple Rules
            under Security or Gateway Policy for a Domain If no sequence number
            is specified in the payload, a value of 0 is assigned by default.
            If there are multiple rules with the same sequence number then
            their order is not deterministic. If a specific order of rules is
            desired, then one has to specify unique sequence numbers or use the
            POST request on the rule entity with a query parameter
            action=revise to let the framework assign a sequence number format:
            int32
        :type  service_entries: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param service_entries: In order to specify raw services this can be used, along with
            services which contains path to services. This can be empty or
            null.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ServiceEntry`. When methods return a value of this class as
            a return value, the attribute will contain all the attributes
            defined in :class:`ServiceEntry`.
        :type  services: :class:`list` of :class:`str` or ``None``
        :param services: In order to specify all services, use the constant \"ANY\". This is
            case insensitive. If \"ANY\" is used, it should be the ONLY element
            in the services array. Error will be thrown if ANY is used in
            conjunction with other values.
        :type  source_groups: :class:`list` of :class:`str` or ``None``
        :param source_groups: We need paths as duplicate names may exist for groups under
            different domains. Along with paths we support IP Address of type
            IPv4 and IPv6. IP Address can be in one of the format(CIDR, IP
            Address, Range of IP Address). In order to specify all groups, use
            the constant \"ANY\". This is case insensitive. If \"ANY\" is used,
            it should be the ONLY element in the group array. Error will be
            thrown if ANY is used in conjunction with other values.
        :type  sources_excluded: :class:`bool` or ``None``
        :param sources_excluded: If set to true, the rule gets applied on all the groups that are
            NOT part of the source groups. If false, the rule applies to the
            source groups
        :type  tag: :class:`str` or ``None``
        :param tag: User level field which will be printed in CLI and packet logs.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.parent_path = parent_path
        self.path = path
        self.relative_path = relative_path
        self.unique_id = unique_id
        self.children = children
        self.marked_for_delete = marked_for_delete
        self.overridden = overridden
        self.destination_groups = destination_groups
        self.destinations_excluded = destinations_excluded
        self.direction = direction
        self.disabled = disabled
        self.ip_protocol = ip_protocol
        self.is_default = is_default
        self.logged = logged
        self.notes = notes
        self.profiles = profiles
        self.rule_id = rule_id
        self.scope = scope
        self.sequence_number = sequence_number
        self.service_entries = service_entries
        self.services = services
        self.source_groups = source_groups
        self.sources_excluded = sources_excluded
        self.tag = tag
        VapiStruct.__init__(self)


BaseRule._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.base_rule', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'unique_id': type.OptionalType(type.StringType()),
        'children': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ChildPolicyConfigResource')]))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'overridden': type.OptionalType(type.BooleanType()),
        'destination_groups': type.OptionalType(type.ListType(type.StringType())),
        'destinations_excluded': type.OptionalType(type.BooleanType()),
        'direction': type.OptionalType(type.StringType()),
        'disabled': type.OptionalType(type.BooleanType()),
        'ip_protocol': type.OptionalType(type.StringType()),
        'is_default': type.OptionalType(type.BooleanType()),
        'logged': type.OptionalType(type.BooleanType()),
        'notes': type.OptionalType(type.StringType()),
        'profiles': type.OptionalType(type.ListType(type.StringType())),
        'rule_id': type.OptionalType(type.IntegerType()),
        'scope': type.OptionalType(type.ListType(type.StringType())),
        'sequence_number': type.OptionalType(type.IntegerType()),
        'service_entries': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ServiceEntry')]))),
        'services': type.OptionalType(type.ListType(type.StringType())),
        'source_groups': type.OptionalType(type.ListType(type.StringType())),
        'sources_excluded': type.OptionalType(type.BooleanType()),
        'tag': type.OptionalType(type.StringType()),
    },
    BaseRule,
    False,
    None))



class BaseRuleListResult(VapiStruct):
    """
    Paged Collection of Rules

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        VapiStruct.__init__(self)


BaseRuleListResult._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.base_rule_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
    },
    BaseRuleListResult,
    False,
    None))



class BaseTier0Interface(VapiStruct):
    """
    Tier-0 interface configuration for external connectivity.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'relative_path': 'relative_path',
                            'unique_id': 'unique_id',
                            'children': 'children',
                            'marked_for_delete': 'marked_for_delete',
                            'overridden': 'overridden',
                            'subnets': 'subnets',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 parent_path=None,
                 path=None,
                 relative_path=None,
                 unique_id=None,
                 children=None,
                 marked_for_delete=None,
                 overridden=None,
                 subnets=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  unique_id: :class:`str` or ``None``
        :param unique_id: This is a UUID generated by the GM/LM to uniquely identify entites
            in a federated environment. For entities that are stretched across
            multiple sites, the same ID will be used on all the stretched
            sites.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  children: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param children: subtree for this type within policy tree containing nested
            elements.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ChildPolicyConfigResource`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`ChildPolicyConfigResource`.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: Intent objects are not directly deleted from the system when a
            delete is invoked on them. They are marked for deletion and only
            when all the realized entities for that intent object gets deleted,
            the intent object is deleted. Objects that are marked for deletion
            are not returned in GET call. One can use the search API to get
            these objects.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  overridden: :class:`bool` or ``None``
        :param overridden: Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  subnets: :class:`list` of :class:`InterfaceSubnet` or ``None``
        :param subnets: Specify IP address and network prefix for interface.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.parent_path = parent_path
        self.path = path
        self.relative_path = relative_path
        self.unique_id = unique_id
        self.children = children
        self.marked_for_delete = marked_for_delete
        self.overridden = overridden
        self.subnets = subnets
        VapiStruct.__init__(self)


BaseTier0Interface._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.base_tier0_interface', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'unique_id': type.OptionalType(type.StringType()),
        'children': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ChildPolicyConfigResource')]))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'overridden': type.OptionalType(type.BooleanType()),
        'subnets': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'InterfaceSubnet'))),
    },
    BaseTier0Interface,
    False,
    None))



class BatchRequest(VapiStruct):
    """
    A set of operations to be performed in a single batch

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'continue_on_error': 'continue_on_error',
                            'requests': 'requests',
                            }

    def __init__(self,
                 continue_on_error=None,
                 requests=None,
                ):
        """
        :type  continue_on_error: :class:`bool` or ``None``
        :param continue_on_error: Flag to decide if we will continue processing subsequent requests
            in case of current error for atomic = false.
        :type  requests: :class:`list` of :class:`BatchRequestItem` or ``None``
        :param requests: 
        """
        self.continue_on_error = continue_on_error
        self.requests = requests
        VapiStruct.__init__(self)


BatchRequest._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.batch_request', {
        'continue_on_error': type.OptionalType(type.BooleanType()),
        'requests': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'BatchRequestItem'))),
    },
    BatchRequest,
    False,
    None))



class BatchRequestItem(VapiStruct):
    """
    A single request within a batch of operations

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    METHOD_GET = "GET"
    """


    """
    METHOD_POST = "POST"
    """


    """
    METHOD_PUT = "PUT"
    """


    """
    METHOD_DELETE = "DELETE"
    """


    """
    METHOD_PATCH = "PATCH"
    """


    """



    _canonical_to_pep_names = {
                            'body': 'body',
                            'method': 'method',
                            'uri': 'uri',
                            }

    def __init__(self,
                 body=None,
                 method=None,
                 uri=None,
                ):
        """
        :type  body: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param body: 
        :type  method: :class:`str` or ``None``
        :param method: Possible values are: 
            
            * :attr:`BatchRequestItem.METHOD_GET`
            * :attr:`BatchRequestItem.METHOD_POST`
            * :attr:`BatchRequestItem.METHOD_PUT`
            * :attr:`BatchRequestItem.METHOD_DELETE`
            * :attr:`BatchRequestItem.METHOD_PATCH`
            
             http method type
        :type  uri: :class:`str` or ``None``
        :param uri: relative uri (path and args), of the call including resource id (if
            this is a POST/DELETE), exclude hostname and port and prefix,
            exploded form of parameters
        """
        self.body = body
        self.method = method
        self.uri = uri
        VapiStruct.__init__(self)


BatchRequestItem._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.batch_request_item', {
        'body': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct)),
        'method': type.OptionalType(type.StringType()),
        'uri': type.OptionalType(type.StringType()),
    },
    BatchRequestItem,
    False,
    None))



class BatchResponse(VapiStruct):
    """
    The reponse to a batch operation

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'has_errors': 'has_errors',
                            'results': 'results',
                            'rolled_back': 'rolled_back',
                            }

    def __init__(self,
                 has_errors=None,
                 results=None,
                 rolled_back=None,
                ):
        """
        :type  has_errors: :class:`bool` or ``None``
        :param has_errors: Indicates if any of the APIs failed
        :type  results: :class:`list` of :class:`BatchResponseItem` or ``None``
        :param results: Bulk list results
        :type  rolled_back: :class:`bool` or ``None``
        :param rolled_back: Optional flag indicating that all items were rolled back even if
            succeeded initially
        """
        self.has_errors = has_errors
        self.results = results
        self.rolled_back = rolled_back
        VapiStruct.__init__(self)


BatchResponse._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.batch_response', {
        'has_errors': type.OptionalType(type.BooleanType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'BatchResponseItem'))),
        'rolled_back': type.OptionalType(type.BooleanType()),
    },
    BatchResponse,
    False,
    None))



class BatchResponseItem(VapiStruct):
    """
    A single respose in a list of batched responses

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'body': 'body',
                            'code': 'code',
                            'headers': 'headers',
                            }

    def __init__(self,
                 body=None,
                 code=None,
                 headers=None,
                ):
        """
        :type  body: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param body: object returned by api
        :type  code: :class:`long` or ``None``
        :param code: http status code format: int64
        :type  headers: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param headers: The headers returned by the API call
        """
        self.body = body
        self.code = code
        self.headers = headers
        VapiStruct.__init__(self)


BatchResponseItem._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.batch_response_item', {
        'body': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct)),
        'code': type.OptionalType(type.IntegerType()),
        'headers': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct)),
    },
    BatchResponseItem,
    False,
    None))



class BfdProfile(VapiStruct):
    """
    Bidirectional Forwarding Detection configuration for BGP peers

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'relative_path': 'relative_path',
                            'unique_id': 'unique_id',
                            'children': 'children',
                            'marked_for_delete': 'marked_for_delete',
                            'overridden': 'overridden',
                            'interval': 'interval',
                            'multiple': 'multiple',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 parent_path=None,
                 path=None,
                 relative_path=None,
                 unique_id=None,
                 children=None,
                 marked_for_delete=None,
                 overridden=None,
                 interval=None,
                 multiple=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  unique_id: :class:`str` or ``None``
        :param unique_id: This is a UUID generated by the GM/LM to uniquely identify entites
            in a federated environment. For entities that are stretched across
            multiple sites, the same ID will be used on all the stretched
            sites.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  children: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param children: subtree for this type within policy tree containing nested
            elements.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ChildPolicyConfigResource`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`ChildPolicyConfigResource`.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: Intent objects are not directly deleted from the system when a
            delete is invoked on them. They are marked for deletion and only
            when all the realized entities for that intent object gets deleted,
            the intent object is deleted. Objects that are marked for deletion
            are not returned in GET call. One can use the search API to get
            these objects.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  overridden: :class:`bool` or ``None``
        :param overridden: Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  interval: :class:`long` or ``None``
        :param interval: Time interval between heartbeat packets in milliseconds. format:
            int32
        :type  multiple: :class:`long` or ``None``
        :param multiple: Declare dead multiple. Number of times heartbeat packet is missed
            before BFD declares the neighbor is down. format: int32
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.parent_path = parent_path
        self.path = path
        self.relative_path = relative_path
        self.unique_id = unique_id
        self.children = children
        self.marked_for_delete = marked_for_delete
        self.overridden = overridden
        self.interval = interval
        self.multiple = multiple
        VapiStruct.__init__(self)


BfdProfile._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.bfd_profile', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'unique_id': type.OptionalType(type.StringType()),
        'children': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ChildPolicyConfigResource')]))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'overridden': type.OptionalType(type.BooleanType()),
        'interval': type.OptionalType(type.IntegerType()),
        'multiple': type.OptionalType(type.IntegerType()),
    },
    BfdProfile,
    False,
    None))



class BfdProfileListResult(VapiStruct):
    """
    Paged Collection of BfdProfile.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`BfdProfile` or ``None``
        :param results: Bfd Profile list results.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


BfdProfileListResult._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.bfd_profile_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'BfdProfile'))),
    },
    BfdProfileListResult,
    False,
    None))



class BgpAddressFamily(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    TYPE_IPV4_UNICAST = "IPV4_UNICAST"
    """


    """
    TYPE_VPNV4_UNICAST = "VPNV4_UNICAST"
    """


    """
    TYPE_IPV6_UNICAST = "IPV6_UNICAST"
    """


    """
    TYPE_L2VPN_EVPN = "L2VPN_EVPN"
    """


    """



    _canonical_to_pep_names = {
                            'in_prefix_count': 'in_prefix_count',
                            'out_prefix_count': 'out_prefix_count',
                            'type': 'type',
                            }

    def __init__(self,
                 in_prefix_count=None,
                 out_prefix_count=None,
                 type=None,
                ):
        """
        :type  in_prefix_count: :class:`long` or ``None``
        :param in_prefix_count: Count of in prefixes format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  out_prefix_count: :class:`long` or ``None``
        :param out_prefix_count: Count of out prefixes format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  type: :class:`str` or ``None``
        :param type: Possible values are: 
            
            * :attr:`BgpAddressFamily.TYPE_IPV4_UNICAST`
            * :attr:`BgpAddressFamily.TYPE_VPNV4_UNICAST`
            * :attr:`BgpAddressFamily.TYPE_IPV6_UNICAST`
            * :attr:`BgpAddressFamily.TYPE_L2VPN_EVPN`
            
             BGP address family type
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.in_prefix_count = in_prefix_count
        self.out_prefix_count = out_prefix_count
        self.type = type
        VapiStruct.__init__(self)


BgpAddressFamily._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.bgp_address_family', {
        'in_prefix_count': type.OptionalType(type.IntegerType()),
        'out_prefix_count': type.OptionalType(type.IntegerType()),
        'type': type.OptionalType(type.StringType()),
    },
    BgpAddressFamily,
    False,
    None))



class BgpBfdConfig(VapiStruct):
    """
    BFD configuration for BGP peers

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'enabled': 'enabled',
                            'interval': 'interval',
                            'multiple': 'multiple',
                            }

    def __init__(self,
                 enabled=None,
                 interval=None,
                 multiple=None,
                ):
        """
        :type  enabled: :class:`bool` or ``None``
        :param enabled: Flag to enable BFD cofiguration.
        :type  interval: :class:`long` or ``None``
        :param interval: Time interval between heartbeat packets in milliseconds. format:
            int32
        :type  multiple: :class:`long` or ``None``
        :param multiple: Declare dead multiple. Number of times heartbeat packet is missed
            before BFD declares the neighbor is down. format: int32
        """
        self.enabled = enabled
        self.interval = interval
        self.multiple = multiple
        VapiStruct.__init__(self)


BgpBfdConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.bgp_bfd_config', {
        'enabled': type.OptionalType(type.BooleanType()),
        'interval': type.OptionalType(type.IntegerType()),
        'multiple': type.OptionalType(type.IntegerType()),
    },
    BgpBfdConfig,
    False,
    None))



class BgpGracefulRestartConfig(VapiStruct):
    """
    Configuration field to hold BGP restart mode and timer.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    MODE_DISABLE = "DISABLE"
    """


    """
    MODE_GR_AND_HELPER = "GR_AND_HELPER"
    """


    """
    MODE_HELPER_ONLY = "HELPER_ONLY"
    """


    """



    _canonical_to_pep_names = {
                            'mode': 'mode',
                            'timer': 'timer',
                            }

    def __init__(self,
                 mode=None,
                 timer=None,
                ):
        """
        :type  mode: :class:`str` or ``None``
        :param mode: Possible values are: 
            
            * :attr:`BgpGracefulRestartConfig.MODE_DISABLE`
            * :attr:`BgpGracefulRestartConfig.MODE_GR_AND_HELPER`
            * :attr:`BgpGracefulRestartConfig.MODE_HELPER_ONLY`
            
            If mode is DISABLE, then graceful restart and helper modes are
            disabled. If mode is GR_AND_HELPER, then both graceful restart and
            helper modes are enabled. If mode is HELPER_ONLY, then helper mode
            is enabled. HELPER_ONLY mode is the ability for a BGP speaker to
            indicate its ability to preserve forwarding state during BGP
            restart. GRACEFUL_RESTART mode is the ability of a BGP speaker to
            advertise its restart to its peers.
        :type  timer: :class:`BgpGracefulRestartTimer` or ``None``
        :param timer: Configuration field to hold BGP restart timers.
        """
        self.mode = mode
        self.timer = timer
        VapiStruct.__init__(self)


BgpGracefulRestartConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.bgp_graceful_restart_config', {
        'mode': type.OptionalType(type.StringType()),
        'timer': type.OptionalType(type.ReferenceType(__name__, 'BgpGracefulRestartTimer')),
    },
    BgpGracefulRestartConfig,
    False,
    None))



class BgpGracefulRestartTimer(VapiStruct):
    """
    Configuration field to hold BGP restart timers

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'restart_timer': 'restart_timer',
                            'stale_route_timer': 'stale_route_timer',
                            }

    def __init__(self,
                 restart_timer=None,
                 stale_route_timer=None,
                ):
        """
        :type  restart_timer: :class:`long` or ``None``
        :param restart_timer: Maximum time taken (in seconds) for a BGP session to be established
            after a restart. This can be used to speed up routing convergence
            by its peer in case the BGP speaker does not come back up after a
            restart. If the session is not re-established within this timer,
            the receiving speaker will delete all the stale routes from that
            peer. format: int64
        :type  stale_route_timer: :class:`long` or ``None``
        :param stale_route_timer: Maximum time (in seconds) before stale routes are removed from the
            RIB (Routing Information Base) when BGP restarts. format: int64
        """
        self.restart_timer = restart_timer
        self.stale_route_timer = stale_route_timer
        VapiStruct.__init__(self)


BgpGracefulRestartTimer._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.bgp_graceful_restart_timer', {
        'restart_timer': type.OptionalType(type.IntegerType()),
        'stale_route_timer': type.OptionalType(type.IntegerType()),
    },
    BgpGracefulRestartTimer,
    False,
    None))



class BgpNeighborConfig(VapiStruct):
    """
    Contains information necessary to configure a BGP neighbor.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    GRACEFUL_RESTART_MODE_DISABLE = "DISABLE"
    """


    """
    GRACEFUL_RESTART_MODE_GR_AND_HELPER = "GR_AND_HELPER"
    """


    """
    GRACEFUL_RESTART_MODE_HELPER_ONLY = "HELPER_ONLY"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'relative_path': 'relative_path',
                            'unique_id': 'unique_id',
                            'children': 'children',
                            'marked_for_delete': 'marked_for_delete',
                            'overridden': 'overridden',
                            'allow_as_in': 'allow_as_in',
                            'bfd': 'bfd',
                            'graceful_restart_mode': 'graceful_restart_mode',
                            'hold_down_time': 'hold_down_time',
                            'in_route_filters': 'in_route_filters',
                            'keep_alive_time': 'keep_alive_time',
                            'maximum_hop_limit': 'maximum_hop_limit',
                            'neighbor_address': 'neighbor_address',
                            'out_route_filters': 'out_route_filters',
                            'password': 'password',
                            'remote_as_num': 'remote_as_num',
                            'route_filtering': 'route_filtering',
                            'source_addresses': 'source_addresses',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 parent_path=None,
                 path=None,
                 relative_path=None,
                 unique_id=None,
                 children=None,
                 marked_for_delete=None,
                 overridden=None,
                 allow_as_in=None,
                 bfd=None,
                 graceful_restart_mode=None,
                 hold_down_time=None,
                 in_route_filters=None,
                 keep_alive_time=None,
                 maximum_hop_limit=None,
                 neighbor_address=None,
                 out_route_filters=None,
                 password=None,
                 remote_as_num=None,
                 route_filtering=None,
                 source_addresses=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  unique_id: :class:`str` or ``None``
        :param unique_id: This is a UUID generated by the GM/LM to uniquely identify entites
            in a federated environment. For entities that are stretched across
            multiple sites, the same ID will be used on all the stretched
            sites.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  children: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param children: subtree for this type within policy tree containing nested
            elements.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ChildPolicyConfigResource`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`ChildPolicyConfigResource`.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: Intent objects are not directly deleted from the system when a
            delete is invoked on them. They are marked for deletion and only
            when all the realized entities for that intent object gets deleted,
            the intent object is deleted. Objects that are marked for deletion
            are not returned in GET call. One can use the search API to get
            these objects.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  overridden: :class:`bool` or ``None``
        :param overridden: Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  allow_as_in: :class:`bool` or ``None``
        :param allow_as_in: Flag to enable allowas_in option for BGP neighbor
        :type  bfd: :class:`BgpBfdConfig` or ``None``
        :param bfd: BFD configuration for failure detection. BFD is enabled with
            default values when not configured.
        :type  graceful_restart_mode: :class:`str` or ``None``
        :param graceful_restart_mode: Possible values are: 
            
            * :attr:`BgpNeighborConfig.GRACEFUL_RESTART_MODE_DISABLE`
            * :attr:`BgpNeighborConfig.GRACEFUL_RESTART_MODE_GR_AND_HELPER`
            * :attr:`BgpNeighborConfig.GRACEFUL_RESTART_MODE_HELPER_ONLY`
            
            If mode is DISABLE, then graceful restart and helper modes are
            disabled. If mode is GR_AND_HELPER, then both graceful restart and
            helper modes are enabled. If mode is HELPER_ONLY, then helper mode
            is enabled. HELPER_ONLY mode is the ability for a BGP speaker to
            indicate its ability to preserve forwarding state during BGP
            restart. GRACEFUL_RESTART mode is the ability of a BGP speaker to
            advertise its restart to its peers.
        :type  hold_down_time: :class:`long` or ``None``
        :param hold_down_time: Wait time in seconds before declaring peer dead. format: int32
        :type  in_route_filters: :class:`list` of :class:`str` or ``None``
        :param in_route_filters: Specify path of prefix-list or route map to filter routes for IN
            direction. This property is deprecated, use route_filtering
            instead. Specifying different values for both properties will
            result in error.
        :type  keep_alive_time: :class:`long` or ``None``
        :param keep_alive_time: Interval (in seconds) between keep alive messages sent to peer.
            format: int32
        :type  maximum_hop_limit: :class:`long` or ``None``
        :param maximum_hop_limit: Maximum number of hops allowed to reach BGP neighbor. format: int32
        :type  neighbor_address: :class:`str` or ``None``
        :param neighbor_address: Neighbor IP Address format: ip
        :type  out_route_filters: :class:`list` of :class:`str` or ``None``
        :param out_route_filters: Specify path of prefix-list or route map to filter routes for OUT
            direction. When not specified, a built-in prefix-list named
            'prefixlist-out-default' is automatically applied. This property is
            deprecated, use route_filtering instead. Specifying different
            values for both properties will result in error.
        :type  password: :class:`str` or ``None``
        :param password: Specify password for BGP neighbor authentication. Empty string
            (\"\") clears existing password.
        :type  remote_as_num: :class:`str` or ``None``
        :param remote_as_num: 4 Byte ASN of the neighbor in ASPLAIN Format
        :type  route_filtering: :class:`list` of :class:`BgpRouteFiltering` or ``None``
        :param route_filtering: Enable address families and route filtering in each direction.
        :type  source_addresses: :class:`list` of :class:`str` or ``None``
        :param source_addresses: Source addresses should belong to Tier0 external or loopback
            interface IP Addresses . BGP peering is formed from all these
            addresses. This property is mandatory when maximum_hop_limit is
            greater than 1. format: ip
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.parent_path = parent_path
        self.path = path
        self.relative_path = relative_path
        self.unique_id = unique_id
        self.children = children
        self.marked_for_delete = marked_for_delete
        self.overridden = overridden
        self.allow_as_in = allow_as_in
        self.bfd = bfd
        self.graceful_restart_mode = graceful_restart_mode
        self.hold_down_time = hold_down_time
        self.in_route_filters = in_route_filters
        self.keep_alive_time = keep_alive_time
        self.maximum_hop_limit = maximum_hop_limit
        self.neighbor_address = neighbor_address
        self.out_route_filters = out_route_filters
        self.password = password
        self.remote_as_num = remote_as_num
        self.route_filtering = route_filtering
        self.source_addresses = source_addresses
        VapiStruct.__init__(self)


BgpNeighborConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.bgp_neighbor_config', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'unique_id': type.OptionalType(type.StringType()),
        'children': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ChildPolicyConfigResource')]))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'overridden': type.OptionalType(type.BooleanType()),
        'allow_as_in': type.OptionalType(type.BooleanType()),
        'bfd': type.OptionalType(type.ReferenceType(__name__, 'BgpBfdConfig')),
        'graceful_restart_mode': type.OptionalType(type.StringType()),
        'hold_down_time': type.OptionalType(type.IntegerType()),
        'in_route_filters': type.OptionalType(type.ListType(type.StringType())),
        'keep_alive_time': type.OptionalType(type.IntegerType()),
        'maximum_hop_limit': type.OptionalType(type.IntegerType()),
        'neighbor_address': type.OptionalType(type.StringType()),
        'out_route_filters': type.OptionalType(type.ListType(type.StringType())),
        'password': type.OptionalType(type.StringType()),
        'remote_as_num': type.OptionalType(type.StringType()),
        'route_filtering': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'BgpRouteFiltering'))),
        'source_addresses': type.OptionalType(type.ListType(type.StringType())),
    },
    BgpNeighborConfig,
    False,
    None))



class BgpNeighborConfigListResult(VapiStruct):
    """
    Paged collection of BGP Neighbor Configs

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`BgpNeighborConfig` or ``None``
        :param results: BGP neighbor configs list results
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


BgpNeighborConfigListResult._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.bgp_neighbor_config_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'BgpNeighborConfig'))),
    },
    BgpNeighborConfigListResult,
    False,
    None))



class BgpNeighborRouteDetailsCsvRecord(VapiStruct):
    """
    BGP neighbor learned/advertised route details.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'as_path': 'as_path',
                            'local_pref': 'local_pref',
                            'logical_router_id': 'logical_router_id',
                            'med': 'med',
                            'neighbor_address': 'neighbor_address',
                            'neighbor_id': 'neighbor_id',
                            'network': 'network',
                            'next_hop': 'next_hop',
                            'source_address': 'source_address',
                            'transport_node_id': 'transport_node_id',
                            'weight': 'weight',
                            }

    def __init__(self,
                 as_path=None,
                 local_pref=None,
                 logical_router_id=None,
                 med=None,
                 neighbor_address=None,
                 neighbor_id=None,
                 network=None,
                 next_hop=None,
                 source_address=None,
                 transport_node_id=None,
                 weight=None,
                ):
        """
        :type  as_path: :class:`str` or ``None``
        :param as_path: BGP AS path attribute.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  local_pref: :class:`long` or ``None``
        :param local_pref: BGP Local Preference attribute. format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  logical_router_id: :class:`str` or ``None``
        :param logical_router_id: Logical router id
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  med: :class:`long` or ``None``
        :param med: BGP Multi Exit Discriminator attribute. format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  neighbor_address: :class:`str` or ``None``
        :param neighbor_address: BGP neighbor peer IP address. format: ip
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  neighbor_id: :class:`str` or ``None``
        :param neighbor_id: BGP neighbor id
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  network: :class:`str` or ``None``
        :param network: CIDR network address. format: ip-cidr-block
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  next_hop: :class:`str` or ``None``
        :param next_hop: Next hop IP address. format: ip
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  source_address: :class:`str` or ``None``
        :param source_address: BGP neighbor source address. format: ip
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  transport_node_id: :class:`str` or ``None``
        :param transport_node_id: Transport node id
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  weight: :class:`long` or ``None``
        :param weight: BGP Weight attribute. format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.as_path = as_path
        self.local_pref = local_pref
        self.logical_router_id = logical_router_id
        self.med = med
        self.neighbor_address = neighbor_address
        self.neighbor_id = neighbor_id
        self.network = network
        self.next_hop = next_hop
        self.source_address = source_address
        self.transport_node_id = transport_node_id
        self.weight = weight
        VapiStruct.__init__(self)


BgpNeighborRouteDetailsCsvRecord._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.bgp_neighbor_route_details_csv_record', {
        'as_path': type.OptionalType(type.StringType()),
        'local_pref': type.OptionalType(type.IntegerType()),
        'logical_router_id': type.OptionalType(type.StringType()),
        'med': type.OptionalType(type.IntegerType()),
        'neighbor_address': type.OptionalType(type.StringType()),
        'neighbor_id': type.OptionalType(type.StringType()),
        'network': type.OptionalType(type.StringType()),
        'next_hop': type.OptionalType(type.StringType()),
        'source_address': type.OptionalType(type.StringType()),
        'transport_node_id': type.OptionalType(type.StringType()),
        'weight': type.OptionalType(type.IntegerType()),
    },
    BgpNeighborRouteDetailsCsvRecord,
    False,
    None))



class BgpNeighborRouteDetailsInCsvFormat(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'file_name': 'file_name',
                            'results': 'results',
                            }

    def __init__(self,
                 file_name=None,
                 results=None,
                ):
        """
        :type  file_name: :class:`str` or ``None``
        :param file_name: File name set by HTTP server if API returns CSV result as a file.
        :type  results: :class:`list` of :class:`BgpNeighborRouteDetailsCsvRecord` or ``None``
        :param results: 
        """
        self.file_name = file_name
        self.results = results
        VapiStruct.__init__(self)


BgpNeighborRouteDetailsInCsvFormat._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.bgp_neighbor_route_details_in_csv_format', {
        'file_name': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'BgpNeighborRouteDetailsCsvRecord'))),
    },
    BgpNeighborRouteDetailsInCsvFormat,
    False,
    None))



class BgpNeighborRoutes(VapiStruct):
    """
    BGP neighbor learned/advertised route details.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'egde_node_routes': 'egde_node_routes',
                            'enforcement_point_path': 'enforcement_point_path',
                            'neighbor_path': 'neighbor_path',
                            }

    def __init__(self,
                 egde_node_routes=None,
                 enforcement_point_path=None,
                 neighbor_path=None,
                ):
        """
        :type  egde_node_routes: :class:`list` of :class:`RoutesPerTransportNode` or ``None``
        :param egde_node_routes: Array of BGP neighbor route details per edge node.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: Enforcement point policy path
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  neighbor_path: :class:`str` or ``None``
        :param neighbor_path: BGP neighbor policy path
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.egde_node_routes = egde_node_routes
        self.enforcement_point_path = enforcement_point_path
        self.neighbor_path = neighbor_path
        VapiStruct.__init__(self)


BgpNeighborRoutes._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.bgp_neighbor_routes', {
        'egde_node_routes': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'RoutesPerTransportNode'))),
        'enforcement_point_path': type.OptionalType(type.StringType()),
        'neighbor_path': type.OptionalType(type.StringType()),
    },
    BgpNeighborRoutes,
    False,
    None))



class BgpNeighborRoutesListResult(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`BgpNeighborRoutes` or ``None``
        :param results: Paged Collection of Bgp neighbor routes.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


BgpNeighborRoutesListResult._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.bgp_neighbor_routes_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'BgpNeighborRoutes'))),
    },
    BgpNeighborRoutesListResult,
    False,
    None))



class BgpRouteFiltering(VapiStruct):
    """
    Enable address_families and route filtering in each direction

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    ADDRESS_FAMILY_IPV4 = "IPV4"
    """


    """
    ADDRESS_FAMILY_IPV6 = "IPV6"
    """


    """
    ADDRESS_FAMILY_L2VPN_EVPN = "L2VPN_EVPN"
    """


    """



    _canonical_to_pep_names = {
                            'address_family': 'address_family',
                            'enabled': 'enabled',
                            'in_route_filters': 'in_route_filters',
                            'maximum_routes': 'maximum_routes',
                            'out_route_filters': 'out_route_filters',
                            }

    def __init__(self,
                 address_family=None,
                 enabled=None,
                 in_route_filters=None,
                 maximum_routes=None,
                 out_route_filters=None,
                ):
        """
        :type  address_family: :class:`str` or ``None``
        :param address_family: Possible values are: 
            
            * :attr:`BgpRouteFiltering.ADDRESS_FAMILY_IPV4`
            * :attr:`BgpRouteFiltering.ADDRESS_FAMILY_IPV6`
            * :attr:`BgpRouteFiltering.ADDRESS_FAMILY_L2VPN_EVPN`
            
            Address family type. If not configured, this property automatically
            derived for IPv4 & IPv6 peer configuration.
        :type  enabled: :class:`bool` or ``None``
        :param enabled: Flag to enable address family.
        :type  in_route_filters: :class:`list` of :class:`str` or ``None``
        :param in_route_filters: Specify path of prefix-list or route map to filter routes for IN
            direction.
        :type  maximum_routes: :class:`long` or ``None``
        :param maximum_routes: Maximum number of routes for the address family. format: int32
        :type  out_route_filters: :class:`list` of :class:`str` or ``None``
        :param out_route_filters: Specify path of prefix-list or route map to filter routes for OUT
            direction. When not specified, a built-in prefix-list named
            'prefixlist-out-default' is automatically applied.
        """
        self.address_family = address_family
        self.enabled = enabled
        self.in_route_filters = in_route_filters
        self.maximum_routes = maximum_routes
        self.out_route_filters = out_route_filters
        VapiStruct.__init__(self)


BgpRouteFiltering._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.bgp_route_filtering', {
        'address_family': type.OptionalType(type.StringType()),
        'enabled': type.OptionalType(type.BooleanType()),
        'in_route_filters': type.OptionalType(type.ListType(type.StringType())),
        'maximum_routes': type.OptionalType(type.IntegerType()),
        'out_route_filters': type.OptionalType(type.ListType(type.StringType())),
    },
    BgpRouteFiltering,
    False,
    None))



class BgpRoutingConfig(VapiStruct):
    """
    Contains BGP routing configuration.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'relative_path': 'relative_path',
                            'unique_id': 'unique_id',
                            'children': 'children',
                            'marked_for_delete': 'marked_for_delete',
                            'overridden': 'overridden',
                            'ecmp': 'ecmp',
                            'enabled': 'enabled',
                            'graceful_restart': 'graceful_restart',
                            'graceful_restart_config': 'graceful_restart_config',
                            'inter_sr_ibgp': 'inter_sr_ibgp',
                            'local_as_num': 'local_as_num',
                            'multipath_relax': 'multipath_relax',
                            'route_aggregations': 'route_aggregations',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 parent_path=None,
                 path=None,
                 relative_path=None,
                 unique_id=None,
                 children=None,
                 marked_for_delete=None,
                 overridden=None,
                 ecmp=None,
                 enabled=None,
                 graceful_restart=None,
                 graceful_restart_config=None,
                 inter_sr_ibgp=None,
                 local_as_num=None,
                 multipath_relax=None,
                 route_aggregations=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  unique_id: :class:`str` or ``None``
        :param unique_id: This is a UUID generated by the GM/LM to uniquely identify entites
            in a federated environment. For entities that are stretched across
            multiple sites, the same ID will be used on all the stretched
            sites.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  children: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param children: subtree for this type within policy tree containing nested
            elements.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ChildPolicyConfigResource`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`ChildPolicyConfigResource`.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: Intent objects are not directly deleted from the system when a
            delete is invoked on them. They are marked for deletion and only
            when all the realized entities for that intent object gets deleted,
            the intent object is deleted. Objects that are marked for deletion
            are not returned in GET call. One can use the search API to get
            these objects.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  overridden: :class:`bool` or ``None``
        :param overridden: Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  ecmp: :class:`bool` or ``None``
        :param ecmp: Flag to enable ECMP.
        :type  enabled: :class:`bool` or ``None``
        :param enabled: Flag to enable BGP configuration. Disabling will stop feature and
            BGP peering.
        :type  graceful_restart: :class:`bool` or ``None``
        :param graceful_restart: Flag to enable graceful restart. This field is deprecated, please
            use graceful_restart_config parameter for graceful restart
            configuration. If both parameters are set and consistent with each
            other (i.e. graceful_restart=false and
            graceful_restart_mode=HELPER_ONLY OR graceful_restart=true and
            graceful_restart_mode=GR_AND_HELPER) then this is allowed, but if
            inconsistent with each other then this is not allowed and
            validation error will be thrown.
        :type  graceful_restart_config: :class:`BgpGracefulRestartConfig` or ``None``
        :param graceful_restart_config: Configuration field to hold BGP Restart mode and timer.
        :type  inter_sr_ibgp: :class:`bool` or ``None``
        :param inter_sr_ibgp: Flag to enable inter SR IBGP configuration. When not specified,
            inter SR IBGP is automatically enabled if Tier-0 is created in
            ACTIVE_ACTIVE ha_mode.
        :type  local_as_num: :class:`str` or ``None``
        :param local_as_num: Specify BGP AS number for Tier-0 to advertize to BGP peers. AS
            number can be specified in ASPLAIN (e.g., \"65546\") or ASDOT
            (e.g., \"1.10\") format. Empty string disables BGP feature. It is
            required by normal tier0 but not required in vrf tier0.
        :type  multipath_relax: :class:`bool` or ``None``
        :param multipath_relax: Flag to enable BGP multipath relax option.
        :type  route_aggregations: :class:`list` of :class:`RouteAggregationEntry` or ``None``
        :param route_aggregations: List of routes to be aggregated.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.parent_path = parent_path
        self.path = path
        self.relative_path = relative_path
        self.unique_id = unique_id
        self.children = children
        self.marked_for_delete = marked_for_delete
        self.overridden = overridden
        self.ecmp = ecmp
        self.enabled = enabled
        self.graceful_restart = graceful_restart
        self.graceful_restart_config = graceful_restart_config
        self.inter_sr_ibgp = inter_sr_ibgp
        self.local_as_num = local_as_num
        self.multipath_relax = multipath_relax
        self.route_aggregations = route_aggregations
        VapiStruct.__init__(self)


BgpRoutingConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.bgp_routing_config', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'unique_id': type.OptionalType(type.StringType()),
        'children': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ChildPolicyConfigResource')]))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'overridden': type.OptionalType(type.BooleanType()),
        'ecmp': type.OptionalType(type.BooleanType()),
        'enabled': type.OptionalType(type.BooleanType()),
        'graceful_restart': type.OptionalType(type.BooleanType()),
        'graceful_restart_config': type.OptionalType(type.ReferenceType(__name__, 'BgpGracefulRestartConfig')),
        'inter_sr_ibgp': type.OptionalType(type.BooleanType()),
        'local_as_num': type.OptionalType(type.StringType()),
        'multipath_relax': type.OptionalType(type.BooleanType()),
        'route_aggregations': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'RouteAggregationEntry'))),
    },
    BgpRoutingConfig,
    False,
    None))



class BinaryPacketData(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "BinaryPacketData"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """



    _canonical_to_pep_names = {
                            'payload': 'payload',
                            'frame_size': 'frame_size',
                            'resource_type': 'resource_type',
                            'routed': 'routed',
                            'transport_type': 'transport_type',
                            }

    def __init__(self,
                 payload=None,
                 frame_size=None,
                 resource_type='BinaryPacketData',
                 routed=None,
                 transport_type=None,
                ):
        """
        :type  payload: :class:`str` or ``None``
        :param payload: Up to 1000 bytes of payload may be supplied (with a base64-encoded
            length of 1336 bytes.) Additional bytes of traceflow metadata will
            be appended to the payload. The payload must contain all headers
            (Ethernet, IP, etc). Note that VLAN is not supported in the logical
            space. Hence, payload must not contain 802.1Q headers.
        :type  frame_size: :class:`long` or ``None``
        :param frame_size: If the requested frame_size is too small (given the payload and
            traceflow metadata requirement of 16 bytes), the traceflow request
            will fail with an appropriate message. The frame will be zero
            padded to the requested size. format: int64
        :type  resource_type: :class:`str`
        :param resource_type: Possible values are: 
            
            * :attr:`PacketData.RESOURCE_TYPE_BINARYPACKETDATA`
            * :attr:`PacketData.RESOURCE_TYPE_FIELDSPACKETDATA`
            
             Packet configuration
        :type  routed: :class:`bool` or ``None``
        :param routed: A flag, when set true, indicates that the traceflow packet is of L3
            routing.
        :type  transport_type: :class:`str` or ``None``
        :param transport_type: Possible values are: 
            
            * :attr:`PacketData.TRANSPORT_TYPE_BROADCAST`
            * :attr:`PacketData.TRANSPORT_TYPE_UNICAST`
            * :attr:`PacketData.TRANSPORT_TYPE_MULTICAST`
            * :attr:`PacketData.TRANSPORT_TYPE_UNKNOWN`
            
             transport type of the traceflow packet
        """
        self.payload = payload
        self.frame_size = frame_size
        self._resource_type = resource_type
        self.routed = routed
        self.transport_type = transport_type
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

BinaryPacketData._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.binary_packet_data', {
        'payload': type.OptionalType(type.StringType()),
        'frame_size': type.OptionalType(type.IntegerType()),
        'resource_type': type.StringType(),
        'routed': type.OptionalType(type.BooleanType()),
        'transport_type': type.OptionalType(type.StringType()),
    },
    BinaryPacketData,
    False,
    None))



class BridgeProfileConfig(VapiStruct):
    """
    configuration parameters for Bridge Profile

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'bridge_profile_path': 'bridge_profile_path',
                            'uplink_teaming_policy_name': 'uplink_teaming_policy_name',
                            'vlan_ids': 'vlan_ids',
                            'vlan_transport_zone_path': 'vlan_transport_zone_path',
                            }

    def __init__(self,
                 bridge_profile_path=None,
                 uplink_teaming_policy_name=None,
                 vlan_ids=None,
                 vlan_transport_zone_path=None,
                ):
        """
        :type  bridge_profile_path: :class:`str` or ``None``
        :param bridge_profile_path: Same bridge profile can be configured on different segments. Each
            bridge profile on a segment must unique.
        :type  uplink_teaming_policy_name: :class:`str` or ``None``
        :param uplink_teaming_policy_name: The name of the switching uplink teaming policy for the bridge
            endpoint. This name corresponds to one fot he switching uplink
            teaming policy names listed in teh transport zone. When this
            property is not specified, the teaming policy is assigned by MP.
        :type  vlan_ids: :class:`list` of :class:`str` or ``None``
        :param vlan_ids: VLAN specification for bridge endpoint. Either VLAN ID or VLAN
            ranges can be specified. Not both.
        :type  vlan_transport_zone_path: :class:`str` or ``None``
        :param vlan_transport_zone_path: VLAN transport zone should belong to the enforcment-point as the
            transport zone specified in the segment.
        """
        self.bridge_profile_path = bridge_profile_path
        self.uplink_teaming_policy_name = uplink_teaming_policy_name
        self.vlan_ids = vlan_ids
        self.vlan_transport_zone_path = vlan_transport_zone_path
        VapiStruct.__init__(self)


BridgeProfileConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.bridge_profile_config', {
        'bridge_profile_path': type.OptionalType(type.StringType()),
        'uplink_teaming_policy_name': type.OptionalType(type.StringType()),
        'vlan_ids': type.OptionalType(type.ListType(type.StringType())),
        'vlan_transport_zone_path': type.OptionalType(type.StringType()),
    },
    BridgeProfileConfig,
    False,
    None))



class ByodPolicyServiceInstance(VapiStruct):
    """
    Represents an instance of partner's service whose wiring will be done by
    partner itself. As partner does all the wiring, we call it as Byod - Bring
    your own device.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    DEPLOYMENT_MODE_STAND_ALONE = "STAND_ALONE"
    """


    """
    DEPLOYMENT_MODE_ACTIVE_STANDBY = "ACTIVE_STANDBY"
    """


    """
    TRANSPORT_TYPE_L2_BRIDGE = "L2_BRIDGE"
    """


    """
    TRANSPORT_TYPE_L3_ROUTED = "L3_ROUTED"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'relative_path': 'relative_path',
                            'unique_id': 'unique_id',
                            'children': 'children',
                            'marked_for_delete': 'marked_for_delete',
                            'overridden': 'overridden',
                            'deployment_mode': 'deployment_mode',
                            'partner_service_name': 'partner_service_name',
                            'transport_type': 'transport_type',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 parent_path=None,
                 path=None,
                 relative_path=None,
                 unique_id=None,
                 children=None,
                 marked_for_delete=None,
                 overridden=None,
                 deployment_mode=None,
                 partner_service_name=None,
                 transport_type=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  unique_id: :class:`str` or ``None``
        :param unique_id: This is a UUID generated by the GM/LM to uniquely identify entites
            in a federated environment. For entities that are stretched across
            multiple sites, the same ID will be used on all the stretched
            sites.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  children: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param children: subtree for this type within policy tree containing nested
            elements.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ChildPolicyConfigResource`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`ChildPolicyConfigResource`.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: Intent objects are not directly deleted from the system when a
            delete is invoked on them. They are marked for deletion and only
            when all the realized entities for that intent object gets deleted,
            the intent object is deleted. Objects that are marked for deletion
            are not returned in GET call. One can use the search API to get
            these objects.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  overridden: :class:`bool` or ``None``
        :param overridden: Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  deployment_mode: :class:`str` or ``None``
        :param deployment_mode: Possible values are: 
            
            * :attr:`ByodPolicyServiceInstance.DEPLOYMENT_MODE_STAND_ALONE`
            * :attr:`ByodPolicyServiceInstance.DEPLOYMENT_MODE_ACTIVE_STANDBY`
            
            Deployment mode specifies how the partner appliance will be
            deployed i.e. in HA or standalone mode.
        :type  partner_service_name: :class:`str` or ``None``
        :param partner_service_name: Unique name of Partner Service in the Marketplace
        :type  transport_type: :class:`str` or ``None``
        :param transport_type: Possible values are: 
            
            * :attr:`ByodPolicyServiceInstance.TRANSPORT_TYPE_L2_BRIDGE`
            * :attr:`ByodPolicyServiceInstance.TRANSPORT_TYPE_L3_ROUTED`
            
             Transport to be used while deploying Service-VM.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.parent_path = parent_path
        self.path = path
        self.relative_path = relative_path
        self.unique_id = unique_id
        self.children = children
        self.marked_for_delete = marked_for_delete
        self.overridden = overridden
        self.deployment_mode = deployment_mode
        self.partner_service_name = partner_service_name
        self.transport_type = transport_type
        VapiStruct.__init__(self)


ByodPolicyServiceInstance._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.byod_policy_service_instance', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'unique_id': type.OptionalType(type.StringType()),
        'children': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ChildPolicyConfigResource')]))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'overridden': type.OptionalType(type.BooleanType()),
        'deployment_mode': type.OptionalType(type.StringType()),
        'partner_service_name': type.OptionalType(type.StringType()),
        'transport_type': type.OptionalType(type.StringType()),
    },
    ByodPolicyServiceInstance,
    False,
    None))



class ByodPolicyServiceInstanceListResult(VapiStruct):
    """
    Collection of only Byod SI objects

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`ByodPolicyServiceInstance` or ``None``
        :param results: Byod Service instance list results
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


ByodPolicyServiceInstanceListResult._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.byod_policy_service_instance_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ByodPolicyServiceInstance'))),
    },
    ByodPolicyServiceInstanceListResult,
    False,
    None))



class ChildApplication(VapiStruct):
    """
    Child wrapper object for Application, used in hierarchical API

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'Application': 'application',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 application=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  application: :class:`Application` or ``None``
        :param application: Contains the actual Application object
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.application = application
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildApplication._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_application', {
        'Application': type.OptionalType(type.ReferenceType(__name__, 'Application')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildApplication,
    False,
    None))



class ChildApplicationService(VapiStruct):
    """
    Child wrapper object for ApplicationService, used in hierarchical API

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'ApplicationService': 'application_service',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 application_service=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  application_service: :class:`ApplicationService` or ``None``
        :param application_service: Contains the actual ApplicationService object
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.application_service = application_service
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildApplicationService._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_application_service', {
        'ApplicationService': type.OptionalType(type.ReferenceType(__name__, 'ApplicationService')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildApplicationService,
    False,
    None))



class ChildApplicationTier(VapiStruct):
    """
    Child wrapper object for ApplicationTier, used in hierarchical API

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'ApplicationTier': 'application_tier',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 application_tier=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  application_tier: :class:`ApplicationTier` or ``None``
        :param application_tier: Contains the actual ApplicationTier object
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.application_tier = application_tier
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildApplicationTier._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_application_tier', {
        'ApplicationTier': type.OptionalType(type.ReferenceType(__name__, 'ApplicationTier')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildApplicationTier,
    False,
    None))



class ChildBfdProfile(VapiStruct):
    """
    Child wrapper for BfdProfile, used in hierarchical API.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'BfdProfile': 'bfd_profile',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 bfd_profile=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  bfd_profile: :class:`BfdProfile` or ``None``
        :param bfd_profile: Contains the actual BfdProfile object.
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.bfd_profile = bfd_profile
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildBfdProfile._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_bfd_profile', {
        'BfdProfile': type.OptionalType(type.ReferenceType(__name__, 'BfdProfile')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildBfdProfile,
    False,
    None))



class ChildBgpNeighborConfig(VapiStruct):
    """
    Child wrapper object for BgpNeighborConfig, used in hierarchical API.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'BgpNeighborConfig': 'bgp_neighbor_config',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 bgp_neighbor_config=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  bgp_neighbor_config: :class:`BgpNeighborConfig` or ``None``
        :param bgp_neighbor_config: Contains the actual BgpNeighborConfig object.
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.bgp_neighbor_config = bgp_neighbor_config
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildBgpNeighborConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_bgp_neighbor_config', {
        'BgpNeighborConfig': type.OptionalType(type.ReferenceType(__name__, 'BgpNeighborConfig')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildBgpNeighborConfig,
    False,
    None))



class ChildBgpRoutingConfig(VapiStruct):
    """
    Child wrapper object for BgpRoutingConfig, used in hierarchical API.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'BgpRoutingConfig': 'bgp_routing_config',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 bgp_routing_config=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  bgp_routing_config: :class:`BgpRoutingConfig` or ``None``
        :param bgp_routing_config: Contains the actual BgpRoutingConfig object.
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.bgp_routing_config = bgp_routing_config
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildBgpRoutingConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_bgp_routing_config', {
        'BgpRoutingConfig': type.OptionalType(type.ReferenceType(__name__, 'BgpRoutingConfig')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildBgpRoutingConfig,
    False,
    None))



class ChildByodPolicyServiceInstance(VapiStruct):
    """
    Child wrapper object for ByodPolicyServiceInstance used in hierarchical
    API.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'ByodPolicyServiceInstance': 'byod_policy_service_instance',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 byod_policy_service_instance=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  byod_policy_service_instance: :class:`ByodPolicyServiceInstance` or ``None``
        :param byod_policy_service_instance: Contains actual ByodPolicyServiceInstance.
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.byod_policy_service_instance = byod_policy_service_instance
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildByodPolicyServiceInstance._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_byod_policy_service_instance', {
        'ByodPolicyServiceInstance': type.OptionalType(type.ReferenceType(__name__, 'ByodPolicyServiceInstance')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildByodPolicyServiceInstance,
    False,
    None))



class ChildCommunicationEntry(VapiStruct):
    """
    Child wrapper object for CommunicationEntry, used in hierarchical API This
    type is deprecated. Use the type ChildRule instead.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'CommunicationEntry': 'communication_entry',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 communication_entry=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  communication_entry: :class:`CommunicationEntry` or ``None``
        :param communication_entry: Contains the actual CommunicationEntry object.
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.communication_entry = communication_entry
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildCommunicationEntry._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_communication_entry', {
        'CommunicationEntry': type.OptionalType(type.ReferenceType(__name__, 'CommunicationEntry')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildCommunicationEntry,
    False,
    None))



class ChildCommunicationMap(VapiStruct):
    """
    Child wrapper object for CommunicationMap, used in hierarchical API This
    type is deprecated. Use the type ChildSecurityPolicy instead.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'CommunicationMap': 'communication_map',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 communication_map=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  communication_map: :class:`CommunicationMap` or ``None``
        :param communication_map: Contains the actual CommunicationMap object.
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.communication_map = communication_map
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildCommunicationMap._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_communication_map', {
        'CommunicationMap': type.OptionalType(type.ReferenceType(__name__, 'CommunicationMap')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildCommunicationMap,
    False,
    None))



class ChildCommunityList(VapiStruct):
    """
    Child wrapper object for CommunityList, used in hierarchical API

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'CommunityList': 'community_list',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 community_list=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  community_list: :class:`CommunityList` or ``None``
        :param community_list: Contains the actual CommunityList object
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.community_list = community_list
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildCommunityList._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_community_list', {
        'CommunityList': type.OptionalType(type.ReferenceType(__name__, 'CommunityList')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildCommunityList,
    False,
    None))



class ChildComputeClusterIdfwConfiguration(VapiStruct):
    """
    Wrapper object for ComputeClusterIdfwConfiguration

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'ComputeClusterIdfwConfiguration': 'compute_cluster_idfw_configuration',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 compute_cluster_idfw_configuration=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  compute_cluster_idfw_configuration: :class:`ComputeClusterIdfwConfiguration` or ``None``
        :param compute_cluster_idfw_configuration: Contains the actual compute cluster idfw configuration object.
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.compute_cluster_idfw_configuration = compute_cluster_idfw_configuration
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildComputeClusterIdfwConfiguration._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_compute_cluster_idfw_configuration', {
        'ComputeClusterIdfwConfiguration': type.OptionalType(type.ReferenceType(__name__, 'ComputeClusterIdfwConfiguration')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildComputeClusterIdfwConfiguration,
    False,
    None))



class ChildConstraint(VapiStruct):
    """
    Child wrapper object for Constraint, used in hierarchical API

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'Constraint': 'constraint',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 constraint=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  constraint: :class:`Constraint` or ``None``
        :param constraint: Contains the actual Constraint object
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.constraint = constraint
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildConstraint._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_constraint', {
        'Constraint': type.OptionalType(type.ReferenceType(__name__, 'Constraint')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildConstraint,
    False,
    None))



class ChildDeploymentZone(VapiStruct):
    """
    Child wrapper object for DeploymentZone, used in hierarchical API

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'DeploymentZone': 'deployment_zone',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 deployment_zone=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  deployment_zone: :class:`DeploymentZone` or ``None``
        :param deployment_zone: Contains the actual DeploymentZone object
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.deployment_zone = deployment_zone
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildDeploymentZone._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_deployment_zone', {
        'DeploymentZone': type.OptionalType(type.ReferenceType(__name__, 'DeploymentZone')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildDeploymentZone,
    False,
    None))



class ChildDfwFirewallConfiguration(VapiStruct):
    """
    Wrapper object for FirewallConfiguration

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'DfwFirewallConfiguration': 'dfw_firewall_configuration',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 dfw_firewall_configuration=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  dfw_firewall_configuration: :class:`DfwFirewallConfiguration` or ``None``
        :param dfw_firewall_configuration: Contains the actual dfw firewall configuration list object.
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.dfw_firewall_configuration = dfw_firewall_configuration
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildDfwFirewallConfiguration._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_dfw_firewall_configuration', {
        'DfwFirewallConfiguration': type.OptionalType(type.ReferenceType(__name__, 'DfwFirewallConfiguration')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildDfwFirewallConfiguration,
    False,
    None))



class ChildDhcpRelayConfig(VapiStruct):
    """
    Child wrapper object for DhcpRelayConfig, used in hierarchical API

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'DhcpRelayConfig': 'dhcp_relay_config',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 dhcp_relay_config=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  dhcp_relay_config: :class:`DhcpRelayConfig` or ``None``
        :param dhcp_relay_config: Contains the actual DhcpRelayConfig object
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.dhcp_relay_config = dhcp_relay_config
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildDhcpRelayConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_dhcp_relay_config', {
        'DhcpRelayConfig': type.OptionalType(type.ReferenceType(__name__, 'DhcpRelayConfig')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildDhcpRelayConfig,
    False,
    None))



class ChildDhcpServerConfig(VapiStruct):
    """
    Child wrapper object for DhcpServerConfig, used in hierarchical API

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'DhcpServerConfig': 'dhcp_server_config',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 dhcp_server_config=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  dhcp_server_config: :class:`DhcpServerConfig` or ``None``
        :param dhcp_server_config: Contains the actual DhcpServerConfig object
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.dhcp_server_config = dhcp_server_config
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildDhcpServerConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_dhcp_server_config', {
        'DhcpServerConfig': type.OptionalType(type.ReferenceType(__name__, 'DhcpServerConfig')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildDhcpServerConfig,
    False,
    None))



class ChildDhcpStaticBindingConfig(VapiStruct):
    """
    Child wrapper for DhcpStaticBindingConfig, used in hierarchical API.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'DhcpStaticBindingConfig': 'dhcp_static_binding_config',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 dhcp_static_binding_config=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  dhcp_static_binding_config: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param dhcp_static_binding_config: Contains the actual DhcpStaticBindingConfig object.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`DhcpStaticBindingConfig`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`DhcpStaticBindingConfig`.
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.dhcp_static_binding_config = dhcp_static_binding_config
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildDhcpStaticBindingConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_dhcp_static_binding_config', {
        'DhcpStaticBindingConfig': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'DhcpStaticBindingConfig')])),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildDhcpStaticBindingConfig,
    False,
    None))



class ChildDnsSecurityProfile(VapiStruct):
    """
    Child wrapper object for DnsSecurityProfile, used in hierarchical API

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'DnsSecurityProfile': 'dns_security_profile',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 dns_security_profile=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  dns_security_profile: :class:`DnsSecurityProfile` or ``None``
        :param dns_security_profile: Contains the actual DnsSecurityProfile object
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.dns_security_profile = dns_security_profile
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildDnsSecurityProfile._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_dns_security_profile', {
        'DnsSecurityProfile': type.OptionalType(type.ReferenceType(__name__, 'DnsSecurityProfile')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildDnsSecurityProfile,
    False,
    None))



class ChildDnsSecurityProfileBindingMap(VapiStruct):
    """
    Child wrapper obejct for DnsSecurityProfileBindingMap used in hierarchical
    API

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'DnsSecurityProfileBindingMap': 'dns_security_profile_binding_map',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 dns_security_profile_binding_map=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  dns_security_profile_binding_map: :class:`DnsSecurityProfileBindingMap` or ``None``
        :param dns_security_profile_binding_map: Contains the actual DnsSecurityProfileBindingMap object
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.dns_security_profile_binding_map = dns_security_profile_binding_map
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildDnsSecurityProfileBindingMap._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_dns_security_profile_binding_map', {
        'DnsSecurityProfileBindingMap': type.OptionalType(type.ReferenceType(__name__, 'DnsSecurityProfileBindingMap')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildDnsSecurityProfileBindingMap,
    False,
    None))



class ChildDomain(VapiStruct):
    """
    Child wrapper object for domain, used in hierarchical API.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'Domain': 'domain',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 domain=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  domain: :class:`Domain` or ``None``
        :param domain: Contains the actual domain object.
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.domain = domain
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildDomain._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_domain', {
        'Domain': type.OptionalType(type.ReferenceType(__name__, 'Domain')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildDomain,
    False,
    None))



class ChildDomainDeploymentMap(VapiStruct):
    """
    Child wrapper object for DomainDeploymentMap, used in hierarchical API.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'DomainDeploymentMap': 'domain_deployment_map',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 domain_deployment_map=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  domain_deployment_map: :class:`DomainDeploymentMap` or ``None``
        :param domain_deployment_map: Contains the actual DomainDeploymentMap object.
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.domain_deployment_map = domain_deployment_map
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildDomainDeploymentMap._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_domain_deployment_map', {
        'DomainDeploymentMap': type.OptionalType(type.ReferenceType(__name__, 'DomainDeploymentMap')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildDomainDeploymentMap,
    False,
    None))



class ChildEndpointPolicy(VapiStruct):
    """
    Child wrapper object for EndpointPolicy used in hierarchical API.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'EndpointPolicy': 'endpoint_policy',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 endpoint_policy=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  endpoint_policy: :class:`EndpointPolicy` or ``None``
        :param endpoint_policy: Contains actual EndpointPolicy.
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.endpoint_policy = endpoint_policy
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildEndpointPolicy._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_endpoint_policy', {
        'EndpointPolicy': type.OptionalType(type.ReferenceType(__name__, 'EndpointPolicy')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildEndpointPolicy,
    False,
    None))



class ChildEndpointRule(VapiStruct):
    """
    Child wrapper object for EndpointRule used in hierarchical API.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'EndpointRule': 'endpoint_rule',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 endpoint_rule=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  endpoint_rule: :class:`EndpointRule` or ``None``
        :param endpoint_rule: Contains actual EndpointRule.
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.endpoint_rule = endpoint_rule
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildEndpointRule._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_endpoint_rule', {
        'EndpointRule': type.OptionalType(type.ReferenceType(__name__, 'EndpointRule')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildEndpointRule,
    False,
    None))



class ChildEnforcementPoint(VapiStruct):
    """
    Child wrapper object for EnforcementPoint, used in hierarchical API.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'EnforcementPoint': 'enforcement_point',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 enforcement_point=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  enforcement_point: :class:`EnforcementPoint` or ``None``
        :param enforcement_point: Contains the actual Enforcement point object.
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.enforcement_point = enforcement_point
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildEnforcementPoint._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_enforcement_point', {
        'EnforcementPoint': type.OptionalType(type.ReferenceType(__name__, 'EnforcementPoint')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildEnforcementPoint,
    False,
    None))



class ChildEvpnConfig(VapiStruct):
    """
    Child wrapper object for EvpnConfig, used in hierarchical API.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'EvpnConfig': 'evpn_config',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 evpn_config=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  evpn_config: :class:`EvpnConfig` or ``None``
        :param evpn_config: Contains the actual EvpnConfig object.
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.evpn_config = evpn_config
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildEvpnConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_evpn_config', {
        'EvpnConfig': type.OptionalType(type.ReferenceType(__name__, 'EvpnConfig')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildEvpnConfig,
    False,
    None))



class ChildEvpnTunnelEndpointConfig(VapiStruct):
    """
    Child wrapper object for EvpnTunnelEndpointConfig, used in hierarchical
    API.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'EvpnTunnelEndpointConfig': 'evpn_tunnel_endpoint_config',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 evpn_tunnel_endpoint_config=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  evpn_tunnel_endpoint_config: :class:`EvpnTunnelEndpointConfig` or ``None``
        :param evpn_tunnel_endpoint_config: Contains the actual EvpnTunnelEndpointConfig object.
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.evpn_tunnel_endpoint_config = evpn_tunnel_endpoint_config
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildEvpnTunnelEndpointConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_evpn_tunnel_endpoint_config', {
        'EvpnTunnelEndpointConfig': type.OptionalType(type.ReferenceType(__name__, 'EvpnTunnelEndpointConfig')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildEvpnTunnelEndpointConfig,
    False,
    None))



class ChildFirewallIdentityStore(VapiStruct):
    """
    Child wrapper for FirewallIdentityStore, used in hierarchical API.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'FirewallIdentityStore': 'firewall_identity_store',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 firewall_identity_store=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  firewall_identity_store: :class:`FirewallIdentityStore` or ``None``
        :param firewall_identity_store: Contains the actual FirewallIdentityStore object.
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.firewall_identity_store = firewall_identity_store
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildFirewallIdentityStore._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_firewall_identity_store', {
        'FirewallIdentityStore': type.OptionalType(type.ReferenceType(__name__, 'FirewallIdentityStore')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildFirewallIdentityStore,
    False,
    None))



class ChildFloodProtectionProfile(VapiStruct):
    """
    Child wrapper object for FloodProtectionProfile, used in hierarchical API

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'FloodProtectionProfile': 'flood_protection_profile',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 flood_protection_profile=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  flood_protection_profile: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param flood_protection_profile: Contains the actual FloodProtectionProfile object
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`FloodProtectionProfile`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`FloodProtectionProfile`.
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.flood_protection_profile = flood_protection_profile
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildFloodProtectionProfile._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_flood_protection_profile', {
        'FloodProtectionProfile': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'FloodProtectionProfile')])),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildFloodProtectionProfile,
    False,
    None))



class ChildFloodProtectionProfileBindingMap(VapiStruct):
    """
    Child wrapper object for FloodProtectionProfileBindingMap, used in
    hierarchical API

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'FloodProtectionProfileBindingMap': 'flood_protection_profile_binding_map',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 flood_protection_profile_binding_map=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  flood_protection_profile_binding_map: :class:`FloodProtectionProfileBindingMap` or ``None``
        :param flood_protection_profile_binding_map: Contains the actual FloodProtectionProfileBindingMap object
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.flood_protection_profile_binding_map = flood_protection_profile_binding_map
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildFloodProtectionProfileBindingMap._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_flood_protection_profile_binding_map', {
        'FloodProtectionProfileBindingMap': type.OptionalType(type.ReferenceType(__name__, 'FloodProtectionProfileBindingMap')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildFloodProtectionProfileBindingMap,
    False,
    None))



class ChildForwardingPolicy(VapiStruct):
    """
    Child wrapper object for ForwardingPolicy used in Hierarchical API.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'ForwardingPolicy': 'forwarding_policy',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 forwarding_policy=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  forwarding_policy: :class:`ForwardingPolicy` or ``None``
        :param forwarding_policy: Contains actual ForwardingPolicy.
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.forwarding_policy = forwarding_policy
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildForwardingPolicy._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_forwarding_policy', {
        'ForwardingPolicy': type.OptionalType(type.ReferenceType(__name__, 'ForwardingPolicy')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildForwardingPolicy,
    False,
    None))



class ChildForwardingRule(VapiStruct):
    """
    Child wrapper object for ForwardingRule used in Hierarchical API.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'ForwardingRule': 'forwarding_rule',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 forwarding_rule=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  forwarding_rule: :class:`ForwardingRule` or ``None``
        :param forwarding_rule: Contains actual ForwardingRule.
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.forwarding_rule = forwarding_rule
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildForwardingRule._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_forwarding_rule', {
        'ForwardingRule': type.OptionalType(type.ReferenceType(__name__, 'ForwardingRule')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildForwardingRule,
    False,
    None))



class ChildGatewayPolicy(VapiStruct):
    """
    Child wrapper object for GatewayPolicy, used in hierarchical API

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'GatewayPolicy': 'gateway_policy',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 gateway_policy=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  gateway_policy: :class:`GatewayPolicy` or ``None``
        :param gateway_policy: Contains the actual GatewayPolicy object
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.gateway_policy = gateway_policy
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildGatewayPolicy._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_gateway_policy', {
        'GatewayPolicy': type.OptionalType(type.ReferenceType(__name__, 'GatewayPolicy')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildGatewayPolicy,
    False,
    None))



class ChildGatewayQosProfile(VapiStruct):
    """
    Child wrapper for GatewayQosProfile, used in hierarchical API.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'QosProfile': 'qos_profile',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 qos_profile=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  qos_profile: :class:`GatewayQosProfile` or ``None``
        :param qos_profile: Contains the actual GatewayQosProfile object.
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.qos_profile = qos_profile
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildGatewayQosProfile._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_gateway_qos_profile', {
        'QosProfile': type.OptionalType(type.ReferenceType(__name__, 'GatewayQosProfile')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildGatewayQosProfile,
    False,
    None))



class ChildGlobalConfig(VapiStruct):
    """
    Child wrapper object for GlobalConfig, used in hierarchical API

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'GlobalConfig': 'global_config',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 global_config=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  global_config: :class:`GlobalConfig` or ``None``
        :param global_config: Contains the actual GlobalConfig object.
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.global_config = global_config
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildGlobalConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_global_config', {
        'GlobalConfig': type.OptionalType(type.ReferenceType(__name__, 'GlobalConfig')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildGlobalConfig,
    False,
    None))



class ChildGlobalManager(VapiStruct):
    """
    Child wrapper object for Global Manager, used in hierarchical API.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'GlobalManager': 'global_manager',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 global_manager=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  global_manager: :class:`GlobalManager` or ``None``
        :param global_manager: Contains the actual Global Manager object.
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.global_manager = global_manager
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildGlobalManager._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_global_manager', {
        'GlobalManager': type.OptionalType(type.ReferenceType(__name__, 'GlobalManager')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildGlobalManager,
    False,
    None))



class ChildGroup(VapiStruct):
    """
    Child wrapper object for group, used in hierarchical API.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'Group': 'group',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 group=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  group: :class:`Group` or ``None``
        :param group: Contains the actual group objects.
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.group = group
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildGroup._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_group', {
        'Group': type.OptionalType(type.ReferenceType(__name__, 'Group')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildGroup,
    False,
    None))



class ChildGroupDiscoveryProfileBindingMap(VapiStruct):
    """
    Child wrapper obejct for GroupDiscoveryProfileBindingMap used in
    hierarchical API

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'GroupDiscoveryProfileBindingMap': 'group_discovery_profile_binding_map',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 group_discovery_profile_binding_map=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  group_discovery_profile_binding_map: :class:`GroupDiscoveryProfileBindingMap` or ``None``
        :param group_discovery_profile_binding_map: Contains the actual GroupDiscoveryProfileBindingMap object
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.group_discovery_profile_binding_map = group_discovery_profile_binding_map
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildGroupDiscoveryProfileBindingMap._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_group_discovery_profile_binding_map', {
        'GroupDiscoveryProfileBindingMap': type.OptionalType(type.ReferenceType(__name__, 'GroupDiscoveryProfileBindingMap')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildGroupDiscoveryProfileBindingMap,
    False,
    None))



class ChildGroupMonitoringProfileBindingMap(VapiStruct):
    """
    Child wrapper object for GroupMonitoringProfileBindingMap, used in
    hierarchical API

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'GroupMonitoringProfileBindingMap': 'group_monitoring_profile_binding_map',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 group_monitoring_profile_binding_map=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  group_monitoring_profile_binding_map: :class:`GroupMonitoringProfileBindingMap` or ``None``
        :param group_monitoring_profile_binding_map: Contains the actual GroupMonitoringProfileBindingMap object
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.group_monitoring_profile_binding_map = group_monitoring_profile_binding_map
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildGroupMonitoringProfileBindingMap._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_group_monitoring_profile_binding_map', {
        'GroupMonitoringProfileBindingMap': type.OptionalType(type.ReferenceType(__name__, 'GroupMonitoringProfileBindingMap')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildGroupMonitoringProfileBindingMap,
    False,
    None))



class ChildIPDiscoveryProfile(VapiStruct):
    """
    Child wrapper object for IPDiscoveryProfile, used in hierarchical API

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'IPDiscoveryProfile': 'ip_discovery_profile',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 ip_discovery_profile=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  ip_discovery_profile: :class:`IPDiscoveryProfile` or ``None``
        :param ip_discovery_profile: Contains the actual IPDiscoveryProfile object
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.ip_discovery_profile = ip_discovery_profile
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildIPDiscoveryProfile._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_IP_discovery_profile', {
        'IPDiscoveryProfile': type.OptionalType(type.ReferenceType(__name__, 'IPDiscoveryProfile')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildIPDiscoveryProfile,
    False,
    None))



class ChildIPFIXDFWCollectorProfile(VapiStruct):
    """
    Child wrapper object for IPFIXDFWCollectorProfile, used in hierarchical API

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'IPFIXDFWCollectorProfile': 'i_pfixdfw_collector_profile',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 i_pfixdfw_collector_profile=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  i_pfixdfw_collector_profile: :class:`IPFIXDFWCollectorProfile` or ``None``
        :param i_pfixdfw_collector_profile: Contains the actual IPFIXDFWCollectorProfile object
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.i_pfixdfw_collector_profile = i_pfixdfw_collector_profile
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildIPFIXDFWCollectorProfile._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_IPFIXDFW_collector_profile', {
        'IPFIXDFWCollectorProfile': type.OptionalType(type.ReferenceType(__name__, 'IPFIXDFWCollectorProfile')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildIPFIXDFWCollectorProfile,
    False,
    None))



class ChildIPFIXDFWProfile(VapiStruct):
    """
    Child wrapper object for IPFIXDFWProfile, used in hierarchical API

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'IPFIXDFWProfile': 'i_pfixdfw_profile',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 i_pfixdfw_profile=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  i_pfixdfw_profile: :class:`IPFIXDFWProfile` or ``None``
        :param i_pfixdfw_profile: Contains the actual IPFIXDFWProfile object
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.i_pfixdfw_profile = i_pfixdfw_profile
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildIPFIXDFWProfile._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_IPFIXDFW_profile', {
        'IPFIXDFWProfile': type.OptionalType(type.ReferenceType(__name__, 'IPFIXDFWProfile')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildIPFIXDFWProfile,
    False,
    None))



class ChildIPFIXL2CollectorProfile(VapiStruct):
    """
    Child wrapper object for IPFIXL2CollectorProfile, used in hierarchical API

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'IPFIXL2CollectorProfile': 'i_pfix_l2_collector_profile',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 i_pfix_l2_collector_profile=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  i_pfix_l2_collector_profile: :class:`IPFIXL2CollectorProfile` or ``None``
        :param i_pfix_l2_collector_profile: Contains the actual IPFIXL2CollectorProfile object
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.i_pfix_l2_collector_profile = i_pfix_l2_collector_profile
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildIPFIXL2CollectorProfile._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_IPFIX_l2_collector_profile', {
        'IPFIXL2CollectorProfile': type.OptionalType(type.ReferenceType(__name__, 'IPFIXL2CollectorProfile')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildIPFIXL2CollectorProfile,
    False,
    None))



class ChildIPFIXL2Profile(VapiStruct):
    """
    Child wrapper object for IPFIXL2Profile, used in hierarchical API

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'IPFIXL2Profile': 'i_pfix_l2_profile',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 i_pfix_l2_profile=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  i_pfix_l2_profile: :class:`IPFIXL2Profile` or ``None``
        :param i_pfix_l2_profile: Contains the actual IPFIXL2Profile object
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.i_pfix_l2_profile = i_pfix_l2_profile
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildIPFIXL2Profile._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_IPFIX_l2_profile', {
        'IPFIXL2Profile': type.OptionalType(type.ReferenceType(__name__, 'IPFIXL2Profile')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildIPFIXL2Profile,
    False,
    None))



class ChildIPSecVpnDpdProfile(VapiStruct):
    """
    Child wrapper object for IPSecVpnDpdProfile, used in hierarchical API.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'IPSecVpnDpdProfile': 'ip_sec_vpn_dpd_profile',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 ip_sec_vpn_dpd_profile=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  ip_sec_vpn_dpd_profile: :class:`IPSecVpnDpdProfile` or ``None``
        :param ip_sec_vpn_dpd_profile: Contains the actual IPSecVpnDpdProfile object.
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.ip_sec_vpn_dpd_profile = ip_sec_vpn_dpd_profile
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildIPSecVpnDpdProfile._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_IP_sec_vpn_dpd_profile', {
        'IPSecVpnDpdProfile': type.OptionalType(type.ReferenceType(__name__, 'IPSecVpnDpdProfile')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildIPSecVpnDpdProfile,
    False,
    None))



class ChildIPSecVpnIkeProfile(VapiStruct):
    """
    Child wrapper object for IPSecVpnIkeProfile, used in hierarchical API.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'IPSecVpnIkeProfile': 'ip_sec_vpn_ike_profile',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 ip_sec_vpn_ike_profile=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  ip_sec_vpn_ike_profile: :class:`IPSecVpnIkeProfile` or ``None``
        :param ip_sec_vpn_ike_profile: Contains the actual IPSecVpnIkeProfile object.
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.ip_sec_vpn_ike_profile = ip_sec_vpn_ike_profile
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildIPSecVpnIkeProfile._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_IP_sec_vpn_ike_profile', {
        'IPSecVpnIkeProfile': type.OptionalType(type.ReferenceType(__name__, 'IPSecVpnIkeProfile')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildIPSecVpnIkeProfile,
    False,
    None))



class ChildIPSecVpnLocalEndpoint(VapiStruct):
    """
    Child wrapper object for IPSecVpnLocalEndpoint, used in hierarchical API.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'IPSecVpnLocalEndpoint': 'ip_sec_vpn_local_endpoint',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 ip_sec_vpn_local_endpoint=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  ip_sec_vpn_local_endpoint: :class:`IPSecVpnLocalEndpoint` or ``None``
        :param ip_sec_vpn_local_endpoint: Contains the actual IPSecVpnLocalEndpoint object.
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.ip_sec_vpn_local_endpoint = ip_sec_vpn_local_endpoint
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildIPSecVpnLocalEndpoint._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_IP_sec_vpn_local_endpoint', {
        'IPSecVpnLocalEndpoint': type.OptionalType(type.ReferenceType(__name__, 'IPSecVpnLocalEndpoint')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildIPSecVpnLocalEndpoint,
    False,
    None))



class ChildIPSecVpnService(VapiStruct):
    """
    Child wrapper object for IPSecVpnService, used in hierarchical API.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'IPSecVpnService': 'ip_sec_vpn_service',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 ip_sec_vpn_service=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  ip_sec_vpn_service: :class:`IPSecVpnService` or ``None``
        :param ip_sec_vpn_service: Contains the actual IPSecVpnService object.
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.ip_sec_vpn_service = ip_sec_vpn_service
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildIPSecVpnService._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_IP_sec_vpn_service', {
        'IPSecVpnService': type.OptionalType(type.ReferenceType(__name__, 'IPSecVpnService')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildIPSecVpnService,
    False,
    None))



class ChildIPSecVpnSession(VapiStruct):
    """
    Child wrapper object for IPSecVpnSession, used in hierarchical API.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'IPSecVpnSession': 'ip_sec_vpn_session',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 ip_sec_vpn_session=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  ip_sec_vpn_session: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param ip_sec_vpn_session: Contains the actual IPSecVpnSession object.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`IPSecVpnSession`. When methods return a value of this class
            as a return value, the attribute will contain all the attributes
            defined in :class:`IPSecVpnSession`.
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.ip_sec_vpn_session = ip_sec_vpn_session
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildIPSecVpnSession._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_IP_sec_vpn_session', {
        'IPSecVpnSession': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'IPSecVpnSession')])),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildIPSecVpnSession,
    False,
    None))



class ChildIPSecVpnTunnelProfile(VapiStruct):
    """
    Child wrapper object for IPSecVpnTunnelProfile, used in hierarchical API.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'IPSecVpnTunnelProfile': 'ip_sec_vpn_tunnel_profile',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 ip_sec_vpn_tunnel_profile=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  ip_sec_vpn_tunnel_profile: :class:`IPSecVpnTunnelProfile` or ``None``
        :param ip_sec_vpn_tunnel_profile: Contains the actual IPSecVpnTunnelProfile object
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.ip_sec_vpn_tunnel_profile = ip_sec_vpn_tunnel_profile
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildIPSecVpnTunnelProfile._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_IP_sec_vpn_tunnel_profile', {
        'IPSecVpnTunnelProfile': type.OptionalType(type.ReferenceType(__name__, 'IPSecVpnTunnelProfile')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildIPSecVpnTunnelProfile,
    False,
    None))



class ChildIdsClusterConfig(VapiStruct):
    """
    Child wrapper object for IdsClusterConfig, used in hierarchical API

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'IdsClusterConfig': 'ids_cluster_config',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 ids_cluster_config=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  ids_cluster_config: :class:`IdsClusterConfig` or ``None``
        :param ids_cluster_config: Contains the IdsClusterConfig object
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.ids_cluster_config = ids_cluster_config
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildIdsClusterConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_ids_cluster_config', {
        'IdsClusterConfig': type.OptionalType(type.ReferenceType(__name__, 'IdsClusterConfig')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildIdsClusterConfig,
    False,
    None))



class ChildIdsProfile(VapiStruct):
    """
    Child wrapper object for IdsProfile, used in hierarchical API

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'IdsProfile': 'ids_profile',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 ids_profile=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  ids_profile: :class:`IdsProfile` or ``None``
        :param ids_profile: Contains the IdsProfile object
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.ids_profile = ids_profile
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildIdsProfile._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_ids_profile', {
        'IdsProfile': type.OptionalType(type.ReferenceType(__name__, 'IdsProfile')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildIdsProfile,
    False,
    None))



class ChildIdsRule(VapiStruct):
    """
    Child wrapper object for IdsRule, used in hierarchical API

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'IdsRule': 'ids_rule',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 ids_rule=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  ids_rule: :class:`IdsRule` or ``None``
        :param ids_rule: Contains the IdsRule object
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.ids_rule = ids_rule
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildIdsRule._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_ids_rule', {
        'IdsRule': type.OptionalType(type.ReferenceType(__name__, 'IdsRule')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildIdsRule,
    False,
    None))



class ChildIdsSecurityPolicy(VapiStruct):
    """
    Child wrapper object for IdsSecurityPolicy, used in hierarchical API

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'IdsSecurityPolicy': 'ids_security_policy',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 ids_security_policy=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  ids_security_policy: :class:`IdsSecurityPolicy` or ``None``
        :param ids_security_policy: Contains the IdsSecurityPolicy object
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.ids_security_policy = ids_security_policy
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildIdsSecurityPolicy._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_ids_security_policy', {
        'IdsSecurityPolicy': type.OptionalType(type.ReferenceType(__name__, 'IdsSecurityPolicy')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildIdsSecurityPolicy,
    False,
    None))



class ChildIdsSignature(VapiStruct):
    """
    Child wrapper object for IdsSignature, used in hierarchical API

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'IdsSignature': 'ids_signature',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 ids_signature=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  ids_signature: :class:`IdsSignature` or ``None``
        :param ids_signature: Contains the IdsSignature object
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.ids_signature = ids_signature
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildIdsSignature._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_ids_signature', {
        'IdsSignature': type.OptionalType(type.ReferenceType(__name__, 'IdsSignature')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildIdsSignature,
    False,
    None))



class ChildIdsStandaloneHostConfig(VapiStruct):
    """
    Child wrapper object for IdsStandaloneHostConfig, used in hierarchical API

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'IdsStandaloneHostConfig': 'ids_standalone_host_config',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 ids_standalone_host_config=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  ids_standalone_host_config: :class:`IdsStandaloneHostConfig` or ``None``
        :param ids_standalone_host_config: Contains the IdsStandaloneHostConfig object
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.ids_standalone_host_config = ids_standalone_host_config
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildIdsStandaloneHostConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_ids_standalone_host_config', {
        'IdsStandaloneHostConfig': type.OptionalType(type.ReferenceType(__name__, 'IdsStandaloneHostConfig')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildIdsStandaloneHostConfig,
    False,
    None))



class ChildIpAddressAllocation(VapiStruct):
    """
    Child wrapper object for IpAddressAllocation, used in hierarchical API

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'IpAddressAllocation': 'ip_address_allocation',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 ip_address_allocation=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  ip_address_allocation: :class:`IpAddressAllocation` or ``None``
        :param ip_address_allocation: Contains the actual IpAddressAllocation object
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.ip_address_allocation = ip_address_allocation
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildIpAddressAllocation._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_ip_address_allocation', {
        'IpAddressAllocation': type.OptionalType(type.ReferenceType(__name__, 'IpAddressAllocation')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildIpAddressAllocation,
    False,
    None))



class ChildIpAddressBlock(VapiStruct):
    """
    Child wrapper object for IpAddressBlock, used in hierarchical API

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'IpAddressBlock': 'ip_address_block',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 ip_address_block=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  ip_address_block: :class:`IpAddressBlock` or ``None``
        :param ip_address_block: Contains the actual IpAddressBlock object
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.ip_address_block = ip_address_block
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildIpAddressBlock._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_ip_address_block', {
        'IpAddressBlock': type.OptionalType(type.ReferenceType(__name__, 'IpAddressBlock')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildIpAddressBlock,
    False,
    None))



class ChildIpAddressPool(VapiStruct):
    """
    Child wrapper object for IpAddressPool, used in hierarchical API

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'IpAddressPool': 'ip_address_pool',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 ip_address_pool=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  ip_address_pool: :class:`IpAddressPool` or ``None``
        :param ip_address_pool: Contains the actual IpAddressPool object
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.ip_address_pool = ip_address_pool
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildIpAddressPool._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_ip_address_pool', {
        'IpAddressPool': type.OptionalType(type.ReferenceType(__name__, 'IpAddressPool')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildIpAddressPool,
    False,
    None))



class ChildIpAddressPoolSubnet(VapiStruct):
    """
    Child wrapper object for IpAddressPoolSubnet, used in hierarchical API

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'IpAddressPoolSubnet': 'ip_address_pool_subnet',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 ip_address_pool_subnet=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  ip_address_pool_subnet: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param ip_address_pool_subnet: Contains the actual IpAddressPoolSubnet object
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`IpAddressPoolSubnet`. When methods return a value of this
            class as a return value, the attribute will contain all the
            attributes defined in :class:`IpAddressPoolSubnet`.
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.ip_address_pool_subnet = ip_address_pool_subnet
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildIpAddressPoolSubnet._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_ip_address_pool_subnet', {
        'IpAddressPoolSubnet': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'IpAddressPoolSubnet')])),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildIpAddressPoolSubnet,
    False,
    None))



class ChildIpv6DadProfile(VapiStruct):
    """
    Child wrapper object for Ipv6DadProfile, used in hierarchical API

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'Ipv6DadProfile': 'ipv6_dad_profile',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 ipv6_dad_profile=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  ipv6_dad_profile: :class:`Ipv6DadProfile` or ``None``
        :param ipv6_dad_profile: Contains the actual Ipv6DadProfile objects
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.ipv6_dad_profile = ipv6_dad_profile
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildIpv6DadProfile._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_ipv6_dad_profile', {
        'Ipv6DadProfile': type.OptionalType(type.ReferenceType(__name__, 'Ipv6DadProfile')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildIpv6DadProfile,
    False,
    None))



class ChildIpv6NdraProfile(VapiStruct):
    """
    Child wrapper object for Ipv6NdraProfile, used in hierarchical API

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'Ipv6NdraProfile': 'ipv6_ndra_profile',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 ipv6_ndra_profile=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  ipv6_ndra_profile: :class:`Ipv6NdraProfile` or ``None``
        :param ipv6_ndra_profile: Contains the actual Ipv6NdraProfile objects
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.ipv6_ndra_profile = ipv6_ndra_profile
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildIpv6NdraProfile._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_ipv6_ndra_profile', {
        'Ipv6NdraProfile': type.OptionalType(type.ReferenceType(__name__, 'Ipv6NdraProfile')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildIpv6NdraProfile,
    False,
    None))



class ChildL2BridgeEndpointProfile(VapiStruct):
    """
    Child wrapper object for L2BridgeEndpointProfile, used in hierarchical API

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'L2BridgeEndpointProfile': 'l2_bridge_endpoint_profile',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 l2_bridge_endpoint_profile=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  l2_bridge_endpoint_profile: :class:`L2BridgeEndpointProfile` or ``None``
        :param l2_bridge_endpoint_profile: Contains the actual L2BridgeEndpointProfile object
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.l2_bridge_endpoint_profile = l2_bridge_endpoint_profile
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildL2BridgeEndpointProfile._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_l2_bridge_endpoint_profile', {
        'L2BridgeEndpointProfile': type.OptionalType(type.ReferenceType(__name__, 'L2BridgeEndpointProfile')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildL2BridgeEndpointProfile,
    False,
    None))



class ChildL2VPNService(VapiStruct):
    """
    Child wrapper object for L2VPNService, used in hierarchical API.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'L2VPNService': 'l2_vpn_service',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 l2_vpn_service=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  l2_vpn_service: :class:`L2VPNService` or ``None``
        :param l2_vpn_service: Contains the actual L2VPNService object.
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.l2_vpn_service = l2_vpn_service
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildL2VPNService._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_l2_VPN_service', {
        'L2VPNService': type.OptionalType(type.ReferenceType(__name__, 'L2VPNService')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildL2VPNService,
    False,
    None))



class ChildL2VPNSession(VapiStruct):
    """
    Child wrapper object for L2VPNSession, used in hierarchical API.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'L2VPNSession': 'l2_vpn_session',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 l2_vpn_session=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  l2_vpn_session: :class:`L2VPNSession` or ``None``
        :param l2_vpn_session: Contains the actual L2VPNSession object.
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.l2_vpn_session = l2_vpn_session
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildL2VPNSession._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_l2_VPN_session', {
        'L2VPNSession': type.OptionalType(type.ReferenceType(__name__, 'L2VPNSession')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildL2VPNSession,
    False,
    None))



class ChildL2Vpn(VapiStruct):
    """
    Child wrapper object for L2Vpn, used in hierarchical API.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'L2Vpn': 'l2_vpn',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 l2_vpn=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  l2_vpn: :class:`L2Vpn` or ``None``
        :param l2_vpn: Contains the actual L2Vpn object.
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.l2_vpn = l2_vpn
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildL2Vpn._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_l2_vpn', {
        'L2Vpn': type.OptionalType(type.ReferenceType(__name__, 'L2Vpn')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildL2Vpn,
    False,
    None))



class ChildL2VpnContext(VapiStruct):
    """
    Child wrapper object for L2VpnContext, used in hierarchical API.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'L2VpnContext': 'l2_vpn_context',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 l2_vpn_context=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  l2_vpn_context: :class:`L2VpnContext` or ``None``
        :param l2_vpn_context: Contains the actual L2VpnContext object.
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.l2_vpn_context = l2_vpn_context
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildL2VpnContext._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_l2_vpn_context', {
        'L2VpnContext': type.OptionalType(type.ReferenceType(__name__, 'L2VpnContext')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildL2VpnContext,
    False,
    None))



class ChildL3Vpn(VapiStruct):
    """
    Child wrapper object for L3Vpn, used in hierarchical API.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'L3Vpn': 'l3_vpn',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 l3_vpn=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  l3_vpn: :class:`L3Vpn` or ``None``
        :param l3_vpn: Contains the actual L3Vpn object.
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.l3_vpn = l3_vpn
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildL3Vpn._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_l3_vpn', {
        'L3Vpn': type.OptionalType(type.ReferenceType(__name__, 'L3Vpn')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildL3Vpn,
    False,
    None))



class ChildL3VpnContext(VapiStruct):
    """
    Child wrapper object for L3VpnContext, used in hierarchical API.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'L3VpnContext': 'l3_vpn_context',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 l3_vpn_context=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  l3_vpn_context: :class:`L3VpnContext` or ``None``
        :param l3_vpn_context: Contains the actual L3VpnContext object.
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        """
        self.l3_vpn_context = l3_vpn_context
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildL3VpnContext._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_l3_vpn_context', {
        'L3VpnContext': type.OptionalType(type.ReferenceType(__name__, 'L3VpnContext')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
    },
    ChildL3VpnContext,
    False,
    None))



class ChildLBAppProfile(VapiStruct):
    """
    Child wrapper for LBAppProfile, used in hierarchical API.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'LBAppProfile': 'lb_app_profile',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            }

    def __init__(self,
                 lb_app_profile=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                ):
        """
        :type  lb_app_profile: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param lb_app_profile: Contains the actual LBAppProfile object.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`LBAppProfile`. When methods return a value of this class as
            a return value, the attribute will contain all the attributes
            defined in :class:`LBAppProfile`.
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be pre